/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.filter.binary;

import boofcv.abst.filter.binary.AdaptiveGaussianBinaryFilter;
import boofcv.abst.filter.binary.AdaptiveSauvolaBinaryFilter;
import boofcv.abst.filter.binary.AdaptiveSquareBinaryFilter;
import boofcv.abst.filter.binary.GlobalEntropyBinaryFilter;
import boofcv.abst.filter.binary.GlobalFixedBinaryFilter;
import boofcv.abst.filter.binary.GlobalOtsuBinaryFilter;
import boofcv.abst.filter.binary.InputToBinary;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageType;

public class FactoryThresholdBinary {
    public static <T extends ImageSingleBand> InputToBinary<T> adaptiveGaussian(int radius, double bias, boolean down, Class<T> inputType) {
        return new AdaptiveGaussianBinaryFilter<T>(radius, bias, down, ImageType.single(inputType));
    }

    public static <T extends ImageSingleBand> InputToBinary<T> adaptiveSauvola(int radius, float k, boolean down, Class<T> inputType) {
        return new AdaptiveSauvolaBinaryFilter<T>(radius, k, down, ImageType.single(inputType));
    }

    public static <T extends ImageSingleBand> InputToBinary<T> adaptiveSquare(int radius, double bias, boolean down, Class<T> inputType) {
        return new AdaptiveSquareBinaryFilter<T>(radius, bias, down, ImageType.single(inputType));
    }

    public static <T extends ImageSingleBand> InputToBinary<T> globalEntropy(int minValue, int maxValue, boolean down, Class<T> inputType) {
        return new GlobalEntropyBinaryFilter<T>(minValue, maxValue, down, ImageType.single(inputType));
    }

    public static <T extends ImageSingleBand> InputToBinary<T> globalFixed(double threshold, boolean down, Class<T> inputType) {
        return new GlobalFixedBinaryFilter<T>(threshold, down, ImageType.single(inputType));
    }

    public static <T extends ImageSingleBand> InputToBinary<T> globalOtsu(int minValue, int maxValue, boolean down, Class<T> inputType) {
        return new GlobalOtsuBinaryFilter<T>(minValue, maxValue, down, ImageType.single(inputType));
    }
}

