/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.convolve;

import boofcv.struct.convolve.Kernel2D;

public class Kernel2D_I32
extends Kernel2D {
    public int[] data;

    public Kernel2D_I32(int width, int[] data) {
        super(width);
        this.data = new int[width * width];
        System.arraycopy(data, 0, this.data, 0, this.data.length);
    }

    public Kernel2D_I32(int width) {
        super(width);
        this.data = new int[width * width];
    }

    protected Kernel2D_I32() {
    }

    public static Kernel2D_I32 wrap(int[] data, int width) {
        if (width % 2 == 0 && width <= 0 && width * width > data.length) {
            throw new IllegalArgumentException("invalid width");
        }
        return new Kernel2D_I32(width, data);
    }

    public int[] getData() {
        return this.data;
    }

    public void print() {
        for (int i = 0; i < this.width; ++i) {
            for (int j = 0; j < this.width; ++j) {
                System.out.printf("%3d ", this.data[i * this.width + j]);
            }
            System.out.println();
        }
    }

    @Override
    public boolean isInteger() {
        return true;
    }

    public int get(int x, int y) {
        return this.data[y * this.width + x];
    }

    public int computeSum() {
        int N = this.width * this.width;
        int total = 0;
        for (int i = 0; i < N; ++i) {
            total += this.data[i];
        }
        return total;
    }

    public void set(int x, int y, int value) {
        this.data[y * this.width + x] = value;
    }

    @Override
    public double getDouble(int x, int y) {
        return this.get(x, y);
    }
}

