/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.distort;

import boofcv.alg.distort.ImageDistort;
import boofcv.alg.interpolate.InterpolatePixel;
import boofcv.struct.distort.PixelTransform_F32;
import boofcv.struct.image.ImageBase;

public abstract class ImageDistortBasic<Input extends ImageBase, Output extends ImageBase, Interpolate extends InterpolatePixel<Input>>
implements ImageDistort<Input, Output> {
    protected PixelTransform_F32 dstToSrc;
    protected Interpolate interp;
    protected int x0;
    protected int y0;
    protected int x1;
    protected int y1;
    protected boolean renderAll = true;
    protected Input srcImg;
    protected Output dstImg;

    public ImageDistortBasic(Interpolate interp) {
        this.interp = interp;
    }

    @Override
    public void setModel(PixelTransform_F32 dstToSrc) {
        this.dstToSrc = dstToSrc;
    }

    @Override
    public void apply(Input srcImg, Output dstImg) {
        this.init(srcImg, dstImg);
        this.x0 = 0;
        this.y0 = 0;
        this.x1 = ((ImageBase)dstImg).width;
        this.y1 = ((ImageBase)dstImg).height;
        if (this.renderAll) {
            this.applyAll();
        } else {
            this.applyOnlyInside();
        }
    }

    @Override
    public void apply(Input srcImg, Output dstImg, int dstX0, int dstY0, int dstX1, int dstY1) {
        this.init(srcImg, dstImg);
        this.x0 = dstX0;
        this.y0 = dstY0;
        this.x1 = dstX1;
        this.y1 = dstY1;
        if (this.renderAll) {
            this.applyAll();
        } else {
            this.applyOnlyInside();
        }
    }

    protected void init(Input srcImg, Output dstImg) {
        this.srcImg = srcImg;
        this.dstImg = dstImg;
        this.interp.setImage(srcImg);
    }

    protected abstract void applyAll();

    protected abstract void applyOnlyInside();

    @Override
    public void setRenderAll(boolean renderAll) {
        this.renderAll = renderAll;
    }

    @Override
    public boolean getRenderAll() {
        return this.renderAll;
    }
}

