/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.filter.convolve;

import boofcv.alg.InputSanityCheck;
import boofcv.alg.filter.convolve.border.ConvolveJustBorder_General;
import boofcv.alg.filter.convolve.noborder.ImplConvolveBox;
import boofcv.core.image.border.ImageBorderValue;
import boofcv.factory.filter.kernel.FactoryKernel;
import boofcv.struct.convolve.Kernel1D_F32;
import boofcv.struct.convolve.Kernel1D_I32;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayI16;
import boofcv.struct.image.GrayS16;
import boofcv.struct.image.GrayS32;
import boofcv.struct.image.GrayU8;

public class ConvolveImageBox {
    public static void horizontal(GrayF32 input, GrayF32 output, int radius) {
        InputSanityCheck.checkSameShape(input, output);
        Kernel1D_F32 kernel = FactoryKernel.table1D_F32(radius, false);
        ConvolveJustBorder_General.horizontal(kernel, ImageBorderValue.wrap(input, 0.0f), output);
        ImplConvolveBox.horizontal(input, output, radius);
    }

    public static void horizontal(GrayU8 input, GrayI16 output, int radius) {
        InputSanityCheck.checkSameShape(input, output);
        Kernel1D_I32 kernel = FactoryKernel.table1D_I32(radius);
        ConvolveJustBorder_General.horizontal(kernel, ImageBorderValue.wrap(input, 0), output);
        ImplConvolveBox.horizontal(input, output, radius);
    }

    public static void horizontal(GrayU8 input, GrayS32 output, int radius) {
        InputSanityCheck.checkSameShape(input, output);
        Kernel1D_I32 kernel = FactoryKernel.table1D_I32(radius);
        ConvolveJustBorder_General.horizontal(kernel, ImageBorderValue.wrap(input, 0), output);
        ImplConvolveBox.horizontal(input, output, radius);
    }

    public static void horizontal(GrayS16 input, GrayI16 output, int radius) {
        InputSanityCheck.checkSameShape(input, output);
        Kernel1D_I32 kernel = FactoryKernel.table1D_I32(radius);
        ConvolveJustBorder_General.horizontal(kernel, ImageBorderValue.wrap(input, 0), output);
        ImplConvolveBox.horizontal(input, output, radius);
    }

    public static void vertical(GrayF32 input, GrayF32 output, int radius) {
        InputSanityCheck.checkSameShape(input, output);
        Kernel1D_F32 kernel = FactoryKernel.table1D_F32(radius, false);
        ConvolveJustBorder_General.vertical(kernel, ImageBorderValue.wrap(input, 0.0f), output);
        ImplConvolveBox.vertical(input, output, radius);
    }

    public static void vertical(GrayU8 input, GrayI16 output, int radius) {
        InputSanityCheck.checkSameShape(input, output);
        Kernel1D_I32 kernel = FactoryKernel.table1D_I32(radius);
        ConvolveJustBorder_General.vertical(kernel, ImageBorderValue.wrap(input, 0), output);
        ImplConvolveBox.vertical(input, output, radius);
    }

    public static void vertical(GrayU8 input, GrayS32 output, int radius) {
        InputSanityCheck.checkSameShape(input, output);
        Kernel1D_I32 kernel = FactoryKernel.table1D_I32(radius);
        ConvolveJustBorder_General.vertical(kernel, ImageBorderValue.wrap(input, 0), output);
        ImplConvolveBox.vertical(input, output, radius);
    }

    public static void vertical(GrayS16 input, GrayI16 output, int radius) {
        InputSanityCheck.checkSameShape(input, output);
        Kernel1D_I32 kernel = FactoryKernel.table1D_I32(radius);
        ConvolveJustBorder_General.vertical(kernel, ImageBorderValue.wrap(input, 0), output);
        ImplConvolveBox.vertical(input, output, radius);
    }
}

