/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.filter.binary;

import boofcv.factory.filter.binary.ConfigThresholdBlockMinMax;
import boofcv.factory.filter.binary.ThresholdType;
import boofcv.struct.Configuration;

public class ConfigThreshold
implements Configuration {
    public ThresholdType type;
    public double fixedThreshold;
    public double scale = 0.95;
    public boolean down = true;
    public int radius;
    public float savolaK = 0.3f;
    public int minPixelValue = 0;
    public int maxPixelValue = 255;

    public static ConfigThreshold fixed(double value) {
        ConfigThreshold config = new ConfigThreshold();
        config.type = ThresholdType.FIXED;
        config.fixedThreshold = value;
        return config;
    }

    public static ConfigThreshold global(ThresholdType type) {
        if (!type.isAdaptive()) {
            throw new IllegalArgumentException("Type must be adaptive");
        }
        if (!type.isGlobal()) {
            throw new IllegalArgumentException("Type must be global");
        }
        ConfigThreshold config = new ConfigThreshold();
        config.type = type;
        return config;
    }

    public static ConfigThreshold local(ThresholdType type, int radius) {
        if (!type.isAdaptive()) {
            throw new IllegalArgumentException("Type must be adaptive");
        }
        if (type.isGlobal()) {
            throw new IllegalArgumentException("Type must be local");
        }
        if (type == ThresholdType.LOCAL_SQUARE_BLOCK_MIN_MAX) {
            return new ConfigThresholdBlockMinMax(radius, 10.0, true);
        }
        ConfigThreshold config = new ConfigThreshold();
        config.type = type;
        config.radius = radius;
        return config;
    }

    @Override
    public void checkValidity() {
    }

    public String toString() {
        return "ConfigThreshold{type=" + (Object)((Object)this.type) + ", fixedThreshold=" + this.fixedThreshold + ", scale=" + this.scale + ", down=" + this.down + ", radius=" + this.radius + ", savolaK=" + this.savolaK + ", minPixelValue=" + this.minPixelValue + ", maxPixelValue=" + this.maxPixelValue + '}';
    }
}

