/*
 * Decompiled with CFR 0.152.
 */
package boofcv.misc;

import boofcv.misc.Performer;

public class ProfileOperation {
    public static void profile(Performer performer, int num) {
        long deltaTime = ProfileOperation.measureTime(performer, num);
        System.out.printf("%30s time = %8d ms per frame = %8.3f\n", performer.getName(), deltaTime, (double)deltaTime / (double)num);
    }

    public static void printOpsPerSec(Performer performer, long minTestTime) {
        try {
            double opsPerSecond = ProfileOperation.profileOpsPerSec(performer, minTestTime, false);
            String name = performer.getName() == null ? performer.getClass().getSimpleName() : performer.getName();
            System.out.printf("%30s  ops/sec = %7.3f\n", name, opsPerSecond);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            System.out.printf("%30s  FAILED\n", performer.getClass().getSimpleName());
        }
    }

    public static double profileOpsPerSec(Performer performer, long minTestTime, boolean warmUp) {
        long elapsedTime;
        if (warmUp) {
            performer.process();
        }
        int N = 1;
        while ((elapsedTime = ProfileOperation.measureTime(performer, N)) < minTestTime) {
            N *= 2;
        }
        return (double)N / ((double)elapsedTime / 1000.0);
    }

    public static long measureTime(Performer performer, int num) {
        long startTime = System.nanoTime();
        for (int i = 0; i < num; ++i) {
            performer.process();
        }
        long stopTime = System.nanoTime();
        return (stopTime - startTime) / 1000000L;
    }
}

