/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.bow;

import boofcv.struct.learning.ClassificationHistogram;
import boofcv.struct.learning.Confusion;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;

public abstract class LearnSceneFromFiles {
    protected Random rand;
    protected List<String> scenes = new ArrayList<String>();
    int minimumTrain;
    int minimumCross;
    int minimumTest;
    double fractionTrain;
    double fractionCross;
    protected Map<String, List<String>> train;
    protected Map<String, List<String>> cross;
    protected Map<String, List<String>> test;

    public Confusion evaluateTest() {
        return this.evaluate(this.test);
    }

    protected Confusion evaluate(Map<String, List<String>> set) {
        int i;
        ClassificationHistogram histogram = new ClassificationHistogram(this.scenes.size());
        int total = 0;
        for (i = 0; i < this.scenes.size(); ++i) {
            total += set.get(this.scenes.get(i)).size();
        }
        System.out.println("total images " + total);
        for (i = 0; i < this.scenes.size(); ++i) {
            String scene = this.scenes.get(i);
            List<String> images = set.get(scene);
            System.out.println("  " + scene + " " + images.size());
            for (String image : images) {
                int predicted = this.classify(image);
                histogram.increment(i, predicted);
            }
        }
        return histogram.createConfusion();
    }

    protected abstract int classify(String var1);

    public void loadSets(File dirTraining, File dirCross, File dirTest) {
        this.train = LearnSceneFromFiles.findImages(dirTraining);
        if (dirCross != null) {
            this.cross = LearnSceneFromFiles.findImages(dirCross);
        }
        this.test = LearnSceneFromFiles.findImages(dirTest);
        this.extractKeys(this.train);
        this.extractKeys(this.test);
    }

    private void extractKeys(Map<String, List<String>> images) {
        Set<String> keys = images.keySet();
        for (String key : keys) {
            if (this.scenes.contains(key)) continue;
            this.scenes.add(key);
        }
    }

    public void loadThenSplit(File directory) {
        Map<String, List<String>> all = LearnSceneFromFiles.findImages(directory);
        this.train = new HashMap<String, List<String>>();
        if (this.fractionCross != 0.0) {
            this.cross = new HashMap<String, List<String>>();
        }
        this.test = new HashMap<String, List<String>>();
        Set<String> keys = all.keySet();
        for (String key : keys) {
            List<String> allImages = all.get(key);
            Collections.shuffle(allImages, this.rand);
            int numTrain = (int)((double)allImages.size() * this.fractionTrain);
            numTrain = Math.max(this.minimumTrain, numTrain);
            int numCross = (int)((double)allImages.size() * this.fractionCross);
            numCross = Math.max(this.minimumCross, numCross);
            int numTest = allImages.size() - numTrain - numCross;
            if (numTest < this.minimumTest) {
                throw new RuntimeException("Not enough images to create test set. " + key + " total = " + allImages.size());
            }
            this.createSubSet(key, allImages, this.train, 0, numTrain);
            if (this.cross != null) {
                this.createSubSet(key, allImages, this.cross, numTrain, numCross + numTrain);
            }
            this.createSubSet(key, allImages, this.test, numCross + numTrain, allImages.size());
        }
        this.scenes.addAll(keys);
    }

    private void createSubSet(String key, List<String> allImages, Map<String, List<String>> subset, int start, int end) {
        ArrayList<String> trainImages = new ArrayList<String>();
        for (int i = start; i < end; ++i) {
            trainImages.add(allImages.get(i));
        }
        subset.put(key, trainImages);
    }

    public static Map<String, List<String>> findImages(File rootDir) {
        File[] files = rootDir.listFiles();
        if (files == null) {
            return null;
        }
        ArrayList<File> imageDirectories = new ArrayList<File>();
        for (File f : files) {
            if (!f.isDirectory()) continue;
            imageDirectories.add(f);
        }
        HashMap<String, List<String>> out = new HashMap<String, List<String>>();
        for (File d : imageDirectories) {
            ArrayList<String> images = new ArrayList<String>();
            files = d.listFiles();
            if (files == null) {
                throw new RuntimeException("Should be a directory!");
            }
            for (File f : files) {
                if (f.isHidden() || f.isDirectory() || f.getName().endsWith(".txt")) continue;
                images.add(f.getPath());
            }
            String key = d.getName().toLowerCase();
            out.put(key, images);
        }
        return out;
    }

    public List<String> getScenes() {
        return this.scenes;
    }
}

