/*
 * Decompiled with CFR 0.152.
 */
package boofcv.struct.learning;

import boofcv.struct.learning.Confusion;
import java.util.Arrays;

public class ClassificationHistogram {
    int[] results;
    int numTypes;

    public ClassificationHistogram(int numTypes) {
        this.results = new int[numTypes * numTypes];
        this.numTypes = numTypes;
    }

    public void reset() {
        Arrays.fill(this.results, 0);
    }

    public void increment(int actual, int predicted) {
        int n = actual * this.numTypes + predicted;
        this.results[n] = this.results[n] + 1;
    }

    public Confusion createConfusion() {
        Confusion confusion = new Confusion(this.numTypes);
        for (int i = 0; i < this.numTypes; ++i) {
            int j;
            int totalActual = 0;
            for (j = 0; j < this.numTypes; ++j) {
                totalActual += this.get(i, j);
            }
            confusion.actualCounts[i] = totalActual;
            for (j = 0; j < this.numTypes; ++j) {
                double fraction = (double)this.get(i, j) / (double)totalActual;
                confusion.matrix.set(i, j, fraction);
            }
        }
        return confusion;
    }

    public int get(int actual, int predicted) {
        return this.results[actual * this.numTypes + predicted];
    }
}

