/*
 * Decompiled with CFR 0.152.
 */
package boofcv.openkinect;

import boofcv.struct.image.ImageUInt16;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.image.MultiSpectral;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.ddogleg.struct.GrowQueue_I8;
import org.openkinect.freenect.Resolution;

public class UtilOpenKinect {
    public static final int FREENECT_DEPTH_MM_MAX_VALUE = 10000;
    public static final int FREENECT_DEPTH_MM_NO_VALUE = 0;

    public static int getWidth(Resolution resolution) {
        if (resolution == Resolution.LOW) {
            return 320;
        }
        if (resolution == Resolution.MEDIUM) {
            return 640;
        }
        if (resolution == Resolution.HIGH) {
            return 1280;
        }
        throw new IllegalArgumentException("Unknown resolution " + (Object)((Object)resolution));
    }

    public static int getHeight(Resolution resolution) {
        if (resolution == Resolution.LOW) {
            return 240;
        }
        if (resolution == Resolution.MEDIUM) {
            return 480;
        }
        if (resolution == Resolution.HIGH) {
            return 1024;
        }
        throw new IllegalArgumentException("Unknown resolution " + (Object)((Object)resolution));
    }

    public static void bufferDepthToU16(ByteBuffer input, ImageUInt16 output) {
        int indexIn = 0;
        for (int y = 0; y < output.height; ++y) {
            int indexOut = output.startIndex + y * output.stride;
            int x = 0;
            while (x < output.width) {
                output.data[indexOut] = (short)(input.get(indexIn++) & 0xFF | (input.get(indexIn++) & 0xFF) << 8);
                ++x;
                ++indexOut;
            }
        }
    }

    public static void bufferDepthToU16(byte[] input, ImageUInt16 output) {
        int indexIn = 0;
        for (int y = 0; y < output.height; ++y) {
            int indexOut = output.startIndex + y * output.stride;
            int x = 0;
            while (x < output.width) {
                output.data[indexOut] = (short)(input[indexIn++] & 0xFF | (input[indexIn++] & 0xFF) << 8);
                ++x;
                ++indexOut;
            }
        }
    }

    public static void bufferRgbToMsU8(ByteBuffer input, MultiSpectral<ImageUInt8> output) {
        ImageUInt8 band0 = (ImageUInt8)output.getBand(0);
        ImageUInt8 band1 = (ImageUInt8)output.getBand(1);
        ImageUInt8 band2 = (ImageUInt8)output.getBand(2);
        int indexIn = 0;
        for (int y = 0; y < output.height; ++y) {
            int indexOut = output.startIndex + y * output.stride;
            int x = 0;
            while (x < output.width) {
                band0.data[indexOut] = input.get(indexIn++);
                band1.data[indexOut] = input.get(indexIn++);
                band2.data[indexOut] = input.get(indexIn++);
                ++x;
                ++indexOut;
            }
        }
    }

    public static void bufferRgbToMsU8(byte[] input, MultiSpectral<ImageUInt8> output) {
        ImageUInt8 band0 = (ImageUInt8)output.getBand(0);
        ImageUInt8 band1 = (ImageUInt8)output.getBand(1);
        ImageUInt8 band2 = (ImageUInt8)output.getBand(2);
        int indexIn = 0;
        for (int y = 0; y < output.height; ++y) {
            int indexOut = output.startIndex + y * output.stride;
            int x = 0;
            while (x < output.width) {
                band0.data[indexOut] = input[indexIn++];
                band1.data[indexOut] = input[indexIn++];
                band2.data[indexOut] = input[indexIn++];
                ++x;
                ++indexOut;
            }
        }
    }

    public static void saveDepth(ImageUInt16 depth, String fileName, GrowQueue_I8 data) throws IOException {
        File out = new File(fileName);
        DataOutputStream os = new DataOutputStream(new FileOutputStream(out));
        String header = String.format("%d %d\n", depth.width, depth.height);
        os.write(header.getBytes());
        data.resize(depth.width * depth.height * 2);
        byte[] buffer = data.data;
        int indexOut = 0;
        for (int y = 0; y < depth.height; ++y) {
            int index = depth.startIndex + y * depth.stride;
            int x = 0;
            while (x < depth.width) {
                short pixel = depth.data[index];
                buffer[indexOut++] = (byte)(pixel & 0xFF);
                buffer[indexOut++] = (byte)(pixel >> 8 & 0xFF);
                ++x;
                ++index;
            }
        }
        os.write(buffer, 0, depth.width * depth.height * 2);
        os.close();
    }

    public static void parseDepth(String fileName, ImageUInt16 depth, GrowQueue_I8 data) throws IOException {
        DataInputStream in = new DataInputStream(new FileInputStream(fileName));
        String[] s = UtilOpenKinect.readLine(in).split(" ");
        int w = Integer.parseInt(s[0]);
        int h = Integer.parseInt(s[1]);
        int length = w * h * 2;
        if (data == null) {
            data = new GrowQueue_I8(length);
        } else {
            data.resize(length);
        }
        in.read(data.data, 0, length);
        depth.reshape(w, h);
        UtilOpenKinect.bufferDepthToU16(data.data, depth);
    }

    private static String readLine(DataInputStream in) throws IOException {
        String s = "";
        int b;
        while ((b = in.read()) != 10) {
            s = s + (char)b;
        }
        return s;
    }
}

