/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.tracker;

import boofcv.abst.tracker.TrackerObjectQuad;
import boofcv.alg.tracker.circulant.CirculantTracker;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageType;
import georegression.geometry.UtilPolygons2D_F64;
import georegression.struct.shapes.Quadrilateral_F64;
import georegression.struct.shapes.Rectangle2D_F32;
import georegression.struct.shapes.RectangleCorner2D_F64;

public class Circulant_to_TrackerObjectQuad<T extends ImageSingleBand>
implements TrackerObjectQuad<T> {
    CirculantTracker<T> tracker;
    RectangleCorner2D_F64 rect = new RectangleCorner2D_F64();
    ImageType<T> imageType;

    public Circulant_to_TrackerObjectQuad(CirculantTracker<T> tracker, ImageType<T> imageType) {
        this.tracker = tracker;
        this.imageType = imageType;
    }

    @Override
    public boolean initialize(T image, Quadrilateral_F64 location) {
        UtilPolygons2D_F64.bounding((Quadrilateral_F64)location, (RectangleCorner2D_F64)this.rect);
        int width = (int)(this.rect.x1 - this.rect.x0);
        int height = (int)(this.rect.y1 - this.rect.y0);
        this.tracker.initialize(image, (int)this.rect.x0, (int)this.rect.y0, width, height);
        return true;
    }

    @Override
    public boolean process(T image, Quadrilateral_F64 location) {
        this.tracker.performTracking(image);
        Rectangle2D_F32 r = this.tracker.getTargetLocation();
        if (r.tl_x >= (float)((ImageSingleBand)image).width || r.tl_y >= (float)((ImageSingleBand)image).height) {
            return false;
        }
        if (r.tl_x + r.width < 0.0f || r.tl_y + r.height < 0.0f) {
            return false;
        }
        float x0 = r.tl_x;
        float y0 = r.tl_y;
        float x1 = r.tl_x + r.width;
        float y1 = r.tl_y + r.height;
        location.a.x = x0;
        location.a.y = y0;
        location.b.x = x1;
        location.b.y = y0;
        location.c.x = x1;
        location.c.y = y1;
        location.d.x = x0;
        location.d.y = y1;
        return true;
    }

    @Override
    public ImageType<T> getImageType() {
        return this.imageType;
    }
}

