/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker.meanshift;

import boofcv.alg.tracker.meanshift.PixelLikelihood;
import boofcv.struct.image.ImageUInt8;
import boofcv.struct.image.MultiSpectral;
import georegression.struct.shapes.Rectangle2D_I32;

public class LikelihoodHistCoupled_U8
implements PixelLikelihood<MultiSpectral<ImageUInt8>> {
    MultiSpectral<ImageUInt8> image;
    int maxPixelValue;
    int numBins;
    float[] hist = new float[0];

    public LikelihoodHistCoupled_U8(int maxPixelValue, int numBins) {
        this.maxPixelValue = maxPixelValue + 1;
        this.numBins = numBins;
    }

    @Override
    public void setImage(MultiSpectral<ImageUInt8> image) {
        this.image = image;
        int histElements = 1;
        for (int i = 0; i < image.getNumBands(); ++i) {
            histElements *= this.numBins;
        }
        if (this.hist.length != histElements) {
            this.hist = new float[histElements];
        }
    }

    public boolean isInBounds(int x, int y) {
        return this.image.isInBounds(x, y);
    }

    @Override
    public void createModel(Rectangle2D_I32 target) {
        for (int y = 0; y < target.height; ++y) {
            int index = this.image.startIndex + (y + target.tl_y) * this.image.stride + target.tl_x;
            int x = 0;
            while (x < target.width) {
                int indexBin = 0;
                int binStride = 1;
                for (int i = 0; i < this.image.getNumBands(); ++i) {
                    ImageUInt8 band = (ImageUInt8)this.image.getBand(i);
                    int value = band.data[index] & 0xFF;
                    int bin = this.numBins * value / this.maxPixelValue;
                    indexBin += bin * binStride;
                    binStride *= this.numBins;
                }
                int n = indexBin;
                this.hist[n] = this.hist[n] + 1.0f;
                ++x;
                ++index;
            }
        }
        float total = target.width * target.height;
        int i = 0;
        while (i < this.hist.length) {
            int n = i++;
            this.hist[n] = this.hist[n] / total;
        }
    }

    public float compute(int x, int y) {
        int index = this.image.startIndex + y * this.image.stride + x;
        int indexBin = 0;
        int binStride = 1;
        for (int i = 0; i < this.image.getNumBands(); ++i) {
            ImageUInt8 band = (ImageUInt8)this.image.getBand(i);
            int value = band.data[index] & 0xFF;
            int bin = this.numBins * value / this.maxPixelValue;
            indexBin += bin * binStride;
            binStride *= this.numBins;
        }
        return this.hist[indexBin];
    }
}

