/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker.meanshift;

import boofcv.alg.misc.ImageMiscOps;
import boofcv.alg.tracker.meanshift.PixelLikelihood;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageFloat32;
import boofcv.struct.sparse.SparseImageSample_F32;
import georegression.struct.shapes.Rectangle2D_I32;
import georegression.struct.shapes.RectangleCorner2D_I32;

public class TrackerMeanShiftLikelihood<T extends ImageBase> {
    private SparseImageSample_F32<T> targetModel;
    private ImageFloat32 pdf = new ImageFloat32(1, 1);
    private Rectangle2D_I32 location = new Rectangle2D_I32();
    private RectangleCorner2D_I32 dirty = new RectangleCorner2D_I32();
    private int maxIterations;
    private float minimumSum;
    private float minFractionDrop;
    private boolean failed;

    public TrackerMeanShiftLikelihood(PixelLikelihood<T> targetModel, int maxIterations, float minFractionDrop) {
        this.targetModel = targetModel;
        this.maxIterations = maxIterations;
        this.minFractionDrop = minFractionDrop;
    }

    public void initialize(T image, Rectangle2D_I32 initial) {
        if (!image.isInBounds(initial.tl_x, initial.tl_y)) {
            throw new IllegalArgumentException("Initial rectangle is out of bounds!");
        }
        if (!image.isInBounds(initial.tl_x + initial.width, initial.tl_y + initial.height)) {
            throw new IllegalArgumentException("Initial rectangle is out of bounds!");
        }
        this.pdf.reshape(((ImageBase)image).width, ((ImageBase)image).height);
        ImageMiscOps.fill((ImageFloat32)this.pdf, (float)-1.0f);
        this.location.set(initial);
        this.location.width += 1 - this.location.width % 2;
        this.location.height += 1 - this.location.height % 2;
        this.failed = false;
        this.minimumSum = 0.0f;
        this.targetModel.setImage(image);
        for (int y = 0; y < initial.height; ++y) {
            for (int x = 0; x < initial.width; ++x) {
                this.minimumSum += this.targetModel.compute(x + initial.tl_x, y + initial.tl_y);
            }
        }
        this.minimumSum *= this.minFractionDrop;
    }

    public boolean process(T image) {
        if (this.failed) {
            return false;
        }
        this.targetModel.setImage(image);
        this.dirty.set(this.location.tl_x, this.location.tl_y, this.location.tl_x + this.location.width, this.location.tl_y + this.location.height);
        this.updatePdfImage(this.location.tl_x, this.location.tl_y, this.location.tl_x + this.location.width, this.location.tl_y + this.location.height);
        int tl_x = this.location.tl_x;
        int tl_y = this.location.tl_y;
        int prevX = tl_x;
        int prevY = tl_y;
        for (int i = 0; i < this.maxIterations; ++i) {
            float totalPdf = 0.0f;
            float sumX = 0.0f;
            float sumY = 0.0f;
            for (int y = 0; y < this.location.height; ++y) {
                int indexPdf = this.pdf.startIndex + this.pdf.stride * (y + tl_y) + tl_x;
                for (int x = 0; x < this.location.width; ++x) {
                    float p = this.pdf.data[indexPdf++];
                    totalPdf += p;
                    sumX += (float)(tl_x + x) * p;
                    sumY += (float)(tl_y + y) * p;
                }
            }
            if (totalPdf <= this.minimumSum) {
                this.failed = true;
                return false;
            }
            tl_x = (int)(sumX / totalPdf - (float)(this.location.width / 2) + 0.5f);
            tl_y = (int)(sumY / totalPdf - (float)(this.location.height / 2) + 0.5f);
            if (tl_x < 0) {
                tl_x = 0;
            } else if (tl_x >= ((ImageBase)image).width - this.location.width) {
                tl_x = ((ImageBase)image).width - this.location.width;
            }
            if (tl_y < 0) {
                tl_y = 0;
            } else if (tl_y >= ((ImageBase)image).height - this.location.height) {
                tl_y = ((ImageBase)image).height - this.location.height;
            }
            if (tl_x == prevX && tl_y == prevY) break;
            prevX = tl_x;
            prevY = tl_y;
            this.updatePdfImage(tl_x, tl_y, tl_x + this.location.width, tl_y + this.location.height);
        }
        this.location.tl_x = tl_x;
        this.location.tl_y = tl_y;
        ImageMiscOps.fillRectangle((ImageFloat32)this.pdf, (float)-1.0f, (int)this.dirty.x0, (int)this.dirty.y0, (int)(this.dirty.x1 - this.dirty.x0), (int)(this.dirty.y1 - this.dirty.y0));
        return true;
    }

    protected void updatePdfImage(int x0, int y0, int x1, int y1) {
        for (int y = y0; y < y1; ++y) {
            int indexOut = this.pdf.startIndex + this.pdf.stride * y + x0;
            int x = x0;
            while (x < x1) {
                if (this.pdf.data[indexOut] < 0.0f) {
                    this.pdf.data[indexOut] = this.targetModel.compute(x, y);
                }
                ++x;
                ++indexOut;
            }
        }
        if (this.dirty.x0 > x0) {
            this.dirty.x0 = x0;
        }
        if (this.dirty.y0 > y0) {
            this.dirty.y0 = y0;
        }
        if (this.dirty.x1 < x1) {
            this.dirty.x1 = x1;
        }
        if (this.dirty.y1 < y1) {
            this.dirty.y1 = y1;
        }
    }

    public Rectangle2D_I32 getLocation() {
        return this.location;
    }

    public boolean isFailed() {
        return this.failed;
    }
}

