/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.tracker.tld;

import boofcv.struct.ImageRectangle;
import georegression.struct.shapes.RectangleCorner2D_F64;
import georegression.struct.shapes.RectangleCorner2D_I32;

public class TldHelperFunctions {
    private ImageRectangle work = new ImageRectangle();

    public double computeOverlap(ImageRectangle a, ImageRectangle b) {
        if (!a.intersection(b, this.work)) {
            return 0.0;
        }
        int areaI = this.work.area();
        int bottom = a.area() + b.area() - areaI;
        return (double)areaI / (double)bottom;
    }

    public static void convertRegion(RectangleCorner2D_F64 input, RectangleCorner2D_I32 output) {
        output.x0 = (int)(input.x0 + 0.5);
        output.x1 = (int)(input.x1 + 0.5);
        output.y0 = (int)(input.y0 + 0.5);
        output.y1 = (int)(input.y1 + 0.5);
    }

    public static void convertRegion(RectangleCorner2D_I32 input, RectangleCorner2D_F64 output) {
        output.x0 = input.x0;
        output.x1 = input.x1;
        output.y0 = input.y0;
        output.y1 = input.y1;
    }
}

