/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.fiducial;

import boofcv.abst.fiducial.FiducialDetector;
import boofcv.alg.fiducial.DetectFiducialSquareImage;
import boofcv.alg.fiducial.FoundFiducial;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageType;
import georegression.struct.se.Se3_F64;

public class SquareImage_to_FiducialDetector<T extends ImageSingleBand>
implements FiducialDetector<T> {
    DetectFiducialSquareImage<T> alg;
    double targetWidth;
    ImageType<T> type;

    public SquareImage_to_FiducialDetector(DetectFiducialSquareImage<T> alg, double targetWidth) {
        this.alg = alg;
        this.targetWidth = targetWidth;
        this.type = ImageType.single(alg.getInputType());
    }

    public void addTarget(T target, double threshold) {
        this.alg.addImage(target, threshold);
    }

    @Override
    public void detect(T input) {
        this.alg.process(input);
    }

    @Override
    public void setIntrinsic(IntrinsicParameters intrinsic) {
        this.alg.configure(this.targetWidth, intrinsic);
    }

    @Override
    public int totalFound() {
        return this.alg.getFound().size;
    }

    @Override
    public void getFiducialToWorld(int which, Se3_F64 fiducialToSensor) {
        fiducialToSensor.set(((FoundFiducial)this.alg.getFound().get((int)which)).targetToSensor);
    }

    @Override
    public int getId(int which) {
        return ((FoundFiducial)this.alg.getFound().get((int)which)).index;
    }

    @Override
    public ImageType<T> getInputType() {
        return this.type;
    }

    public double getTargetWidth() {
        return this.targetWidth;
    }
}

