/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial;

import georegression.fitting.line.FitLine_F64;
import georegression.geometry.UtilLine2D_F64;
import georegression.metric.Intersection2D_F64;
import georegression.struct.line.LineGeneral2D_F64;
import georegression.struct.line.LinePolar2D_F64;
import georegression.struct.line.LineSegment2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point2D_I32;
import georegression.struct.shapes.Quadrilateral_F64;
import java.util.List;
import org.ddogleg.sorting.QuickSortObj_F64;
import org.ddogleg.sorting.SortableParameter_F64;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.GrowQueue_F64;
import org.ddogleg.struct.GrowQueue_I32;

public class FitQuadrilaterialEM {
    private double maxDistance = 6.0;
    private int iterationsEM = 10;
    private QuickSortObj_F64 sorterLength = new QuickSortObj_F64();
    private FastQueue<Segment> segments = new FastQueue(Segment.class, true);
    private FastQueue<Point> points = new FastQueue(Point.class, true);
    protected LineGeneral2D_F64[] lines;
    private GrowQueue_F64 weights = new GrowQueue_F64();
    private LineSegment2D_F64 work = new LineSegment2D_F64();
    private LinePolar2D_F64 polar = new LinePolar2D_F64();

    public FitQuadrilaterialEM(double maxDistance, int iterationsEM) {
        this();
        this.maxDistance = maxDistance;
        this.iterationsEM = iterationsEM;
    }

    public FitQuadrilaterialEM() {
        this.lines = new LineGeneral2D_F64[4];
        for (int i = 0; i < this.lines.length; ++i) {
            this.lines[i] = new LineGeneral2D_F64();
        }
    }

    public boolean fit(List<Point2D_I32> contour, GrowQueue_I32 corners, Quadrilateral_F64 output) {
        int i;
        this.segments.reset();
        for (i = 0; i < corners.size; ++i) {
            int next = (i + 1) % corners.size;
            ((Segment)((Object)this.segments.grow())).set(corners.get(i), corners.get(next), contour.size());
        }
        this.sorterLength.sort((SortableParameter_F64[])this.segments.data, this.segments.size);
        FitQuadrilaterialEM.bubbleSortLines(this.segments);
        for (i = 0; i < 4; ++i) {
            this.createLine((Segment)((Object)this.segments.get(i)), contour, this.lines[i]);
        }
        this.performLineEM(contour);
        return FitQuadrilaterialEM.convert(this.lines, output);
    }

    protected static void bubbleSortLines(FastQueue<Segment> segments) {
        for (int i = 0; i < 4; ++i) {
            int bestValue = ((Segment)((Object)segments.get((int)i))).index0;
            int bestIndex = i;
            for (int j = i + 1; j < 4; ++j) {
                Segment b = (Segment)((Object)segments.get(j));
                if (b.index0 >= bestValue) continue;
                bestIndex = j;
                bestValue = b.index0;
            }
            if (bestIndex == i) continue;
            Segment tmp = ((Segment[])segments.data)[i];
            ((Segment[])segments.data)[i] = ((Segment[])segments.data)[bestIndex];
            ((Segment[])segments.data)[bestIndex] = tmp;
        }
    }

    protected void performLineEM(List<Point2D_I32> contour) {
        this.points.reset();
        for (int i = 0; i < contour.size(); ++i) {
            Point2D_I32 p = contour.get(i);
            ((Point)((Object)this.points.grow())).set(p.x, p.y);
        }
        this.weights.resize(this.points.size);
        for (int EM = 0; EM < this.iterationsEM; ++EM) {
            this.computePointWeights();
            this.computeLineEquations();
        }
        this.computeLineEquationsNoAmbiguous();
    }

    private void computePointWeights() {
        for (int i = 0; i < this.points.size; ++i) {
            int j;
            Point p = (Point)((Object)this.points.get(i));
            double totalWeight = 0.0;
            for (j = 0; j < 4; ++j) {
                p.distance[j] = FitQuadrilaterialEM.distance(this.lines[j], p);
                p.weight[j] = Math.max(0.0, 1.0 - p.distance[j] / this.maxDistance);
                totalWeight += p.weight[j];
            }
            if (totalWeight > 0.0) {
                j = 0;
                while (j < 4) {
                    int n = j++;
                    p.weight[n] = p.weight[n] / totalWeight;
                }
                continue;
            }
            for (j = 0; j < 4; ++j) {
                p.weight[j] = 0.0;
            }
        }
    }

    private void computeLineEquations() {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < this.points.size; ++j) {
                this.weights.data[j] = ((Point[])this.points.data)[j].weight[i];
            }
            FitLine_F64.polar((List)this.points.toList(), (double[])this.weights.data, (LinePolar2D_F64)this.polar);
            UtilLine2D_F64.convert((LinePolar2D_F64)this.polar, (LineGeneral2D_F64)this.lines[i]);
        }
    }

    private void computeLineEquationsNoAmbiguous() {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < this.points.size; ++j) {
                double w = ((Point[])this.points.data)[j].weight[i];
                this.weights.data[j] = w < 0.9 ? 0.0 : w;
            }
            FitLine_F64.polar((List)this.points.toList(), (double[])this.weights.data, (LinePolar2D_F64)this.polar);
            UtilLine2D_F64.convert((LinePolar2D_F64)this.polar, (LineGeneral2D_F64)this.lines[i]);
        }
    }

    protected static double distance(LineGeneral2D_F64 line, Point2D_F64 p) {
        return Math.abs(line.A * p.x + line.B * p.y + line.C);
    }

    private void createLine(Segment segment, List<Point2D_I32> contour, LineGeneral2D_F64 line) {
        Point2D_I32 p0 = contour.get(segment.index0);
        Point2D_I32 p1 = contour.get(segment.index1);
        this.work.a.set((double)p0.x, (double)p0.y);
        this.work.b.set((double)p1.x, (double)p1.y);
        UtilLine2D_F64.convert((LineSegment2D_F64)this.work, (LineGeneral2D_F64)line);
        line.normalize();
    }

    protected static boolean convert(LineGeneral2D_F64[] lines, Quadrilateral_F64 quad) {
        if (null == Intersection2D_F64.intersection((LineGeneral2D_F64)lines[0], (LineGeneral2D_F64)lines[1], (Point2D_F64)quad.a)) {
            return false;
        }
        if (null == Intersection2D_F64.intersection((LineGeneral2D_F64)lines[2], (LineGeneral2D_F64)lines[1], (Point2D_F64)quad.b)) {
            return false;
        }
        if (null == Intersection2D_F64.intersection((LineGeneral2D_F64)lines[2], (LineGeneral2D_F64)lines[3], (Point2D_F64)quad.c)) {
            return false;
        }
        return null != Intersection2D_F64.intersection((LineGeneral2D_F64)lines[0], (LineGeneral2D_F64)lines[3], (Point2D_F64)quad.d);
    }

    public static class Point
    extends Point2D_F64 {
        public double[] weight = new double[4];
        public double[] distance = new double[4];
    }

    public static class Segment
    extends SortableParameter_F64 {
        public int index0;
        public int index1;

        public void set(int index0, int index1, int contourSize) {
            this.index0 = index0;
            this.index1 = index1;
            this.sortValue = index1 > index0 ? (double)(index1 - index0) : (double)(contourSize - index0 + index1);
            this.sortValue = -this.sortValue;
        }
    }
}

