/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.fiducial;

import boofcv.abst.calib.ConfigChessboard;
import boofcv.abst.calib.ConfigSquareGrid;
import boofcv.abst.fiducial.CalibrationFiducialDetector;
import boofcv.abst.fiducial.FiducialDetector;
import boofcv.abst.fiducial.SquareBinary_to_FiducialDetector;
import boofcv.abst.fiducial.SquareImage_to_FiducialDetector;
import boofcv.abst.filter.binary.InputToBinary;
import boofcv.alg.feature.shapes.SplitMergeLineFitLoop;
import boofcv.alg.fiducial.DetectFiducialSquareBinary;
import boofcv.alg.fiducial.DetectFiducialSquareImage;
import boofcv.factory.fiducial.ConfigFiducialBinary;
import boofcv.factory.fiducial.ConfigFiducialImage;
import boofcv.factory.filter.binary.FactoryThresholdBinary;
import boofcv.struct.image.ImageSingleBand;

public class FactoryFiducial {
    public static <T extends ImageSingleBand> FiducialDetector<T> squareBinaryFast(ConfigFiducialBinary config, int binaryThreshold, Class<T> imageType) {
        InputToBinary binary = FactoryThresholdBinary.globalFixed((double)binaryThreshold, (boolean)true, imageType);
        SplitMergeLineFitLoop poly = new SplitMergeLineFitLoop((double)config.borderTolerance, 0.05, config.borderMaxIterations);
        DetectFiducialSquareBinary<T> alg = new DetectFiducialSquareBinary<T>(binary, poly, config.minContourFraction, imageType);
        return new SquareBinary_to_FiducialDetector<T>(alg, config.targetWidth);
    }

    public static <T extends ImageSingleBand> FiducialDetector<T> squareBinaryRobust(ConfigFiducialBinary config, int thresholdRadius, Class<T> imageType) {
        InputToBinary binary = FactoryThresholdBinary.adaptiveSquare((int)thresholdRadius, (double)0.0, (boolean)true, imageType);
        SplitMergeLineFitLoop poly = new SplitMergeLineFitLoop((double)config.borderTolerance, 0.05, config.borderMaxIterations);
        DetectFiducialSquareBinary<T> alg = new DetectFiducialSquareBinary<T>(binary, poly, config.minContourFraction, imageType);
        return new SquareBinary_to_FiducialDetector<T>(alg, config.targetWidth);
    }

    public static <T extends ImageSingleBand> SquareImage_to_FiducialDetector<T> squareImageFast(ConfigFiducialImage config, int binaryThreshold, Class<T> imageType) {
        InputToBinary binary = FactoryThresholdBinary.globalFixed((double)binaryThreshold, (boolean)true, imageType);
        SplitMergeLineFitLoop poly = new SplitMergeLineFitLoop((double)config.borderTolerance, 0.05, config.borderMaxIterations);
        DetectFiducialSquareImage<T> alg = new DetectFiducialSquareImage<T>(binary, poly, config.minContourFraction, config.maxErrorFraction, imageType);
        return new SquareImage_to_FiducialDetector<T>(alg, config.targetWidth);
    }

    public static <T extends ImageSingleBand> SquareImage_to_FiducialDetector<T> squareImageRobust(ConfigFiducialImage config, int thresholdRadius, Class<T> imageType) {
        InputToBinary binary = FactoryThresholdBinary.adaptiveSquare((int)thresholdRadius, (double)0.0, (boolean)true, imageType);
        SplitMergeLineFitLoop poly = new SplitMergeLineFitLoop((double)config.borderTolerance, 0.05, config.borderMaxIterations);
        DetectFiducialSquareImage<T> alg = new DetectFiducialSquareImage<T>(binary, poly, config.minContourFraction, config.maxErrorFraction, imageType);
        return new SquareImage_to_FiducialDetector<T>(alg, config.targetWidth);
    }

    public static <T extends ImageSingleBand> CalibrationFiducialDetector<T> calibChessboard(ConfigChessboard config, double sizeOfSquares, Class<T> imageType) {
        return new CalibrationFiducialDetector<T>(config, sizeOfSquares, imageType);
    }

    public static <T extends ImageSingleBand> CalibrationFiducialDetector<T> calibSquareGrid(ConfigSquareGrid config, double sizeOfSquares, Class<T> imageType) {
        return new CalibrationFiducialDetector<T>(config, sizeOfSquares, imageType);
    }
}

