/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.fiducial.calib;

import boofcv.factory.fiducial.ConfigFiducialBinary;
import boofcv.factory.filter.binary.ConfigThreshold;
import boofcv.factory.filter.binary.ThresholdType;
import boofcv.struct.Configuration;
import java.io.BufferedReader;
import java.io.IOException;

public class ConfigSquareGridBinary
implements Configuration {
    public ConfigFiducialBinary configDetector = new ConfigFiducialBinary();
    public ConfigThreshold configThreshold = ConfigThreshold.local((ThresholdType)ThresholdType.LOCAL_SQUARE, (int)20);
    public long[] ids;
    public int numRows = -1;
    public int numCols = -1;
    public double squareWidth;
    public double spaceWidth;

    public ConfigSquareGridBinary(int numRows, int numCols, double squareWidth, double spaceWidth) {
        this.configDetector.gridWidth = 3;
        this.numRows = numRows;
        this.numCols = numCols;
        this.squareWidth = squareWidth;
        this.spaceWidth = spaceWidth;
        this.ids = new long[numRows * numCols];
        for (int i = 0; i < this.ids.length; ++i) {
            this.ids[i] = i;
        }
    }

    public ConfigSquareGridBinary() {
        this.configDetector.gridWidth = 3;
    }

    public void checkValidity() {
        if (this.ids == null) {
            throw new IllegalArgumentException("Need to specify expected ids");
        }
    }

    public static ConfigSquareGridBinary parseSimple(BufferedReader reader) throws IOException {
        ConfigSquareGridBinary config = new ConfigSquareGridBinary();
        String line = reader.readLine();
        while (line != null) {
            if (line.charAt(0) != '#') {
                String[] words = line.split(" ");
                if (words[0].equals("binary_width")) {
                    config.configDetector.gridWidth = Integer.parseInt(words[1]);
                } else if (words[0].equals("grid_shape")) {
                    config.numRows = Integer.parseInt(words[1]);
                    config.numCols = Integer.parseInt(words[2]);
                } else if (words[0].equals("square_width")) {
                    config.squareWidth = Double.parseDouble(words[1]);
                } else if (words[0].equals("space_width")) {
                    config.spaceWidth = Double.parseDouble(words[1]);
                } else if (words[0].equals("numbers")) {
                    config.ids = new long[words.length - 1];
                    for (int i = 1; i < words.length; ++i) {
                        config.ids[i - 1] = Integer.parseInt(words[i]);
                    }
                }
            }
            line = reader.readLine();
        }
        return config;
    }
}

