/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.squares;

import boofcv.alg.fiducial.calib.squares.SquareEdge;
import boofcv.alg.fiducial.calib.squares.SquareGrid;
import boofcv.alg.fiducial.calib.squares.SquareNode;
import boofcv.misc.CircularIndex;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.struct.FastQueue;

public class CrossClustersIntoGrids {
    private boolean verbose = false;
    FastQueue<SquareGrid> grids = new FastQueue(SquareGrid.class, true);
    protected boolean invalid;

    public void process(List<List<SquareNode>> clusters) {
        this.grids.reset();
        for (int i = 0; i < clusters.size(); ++i) {
            if (!this.checkPreconditions(clusters.get(i))) continue;
            this.processCluster(clusters.get(i));
        }
    }

    protected boolean checkPreconditions(List<SquareNode> cluster) {
        for (int i = 0; i < cluster.size(); ++i) {
            SquareNode n = cluster.get(i);
            for (int j = 0; j < n.corners.size(); ++j) {
                SquareEdge e0 = n.edges[j];
                if (e0 == null) continue;
                for (int k = j + 1; k < n.corners.size(); ++k) {
                    SquareEdge e1 = n.edges[k];
                    if (e1 == null || e0.destination(n) != e1.destination(n)) continue;
                    return false;
                }
            }
        }
        return true;
    }

    protected void processCluster(List<SquareNode> cluster) {
        List previous;
        List<SquareNode> firstRow;
        SquareNode n;
        this.invalid = false;
        if (cluster.size() == 1 && (n = cluster.get(0)).getNumberOfConnections() == 0) {
            SquareGrid grid = (SquareGrid)this.grids.grow();
            grid.reset();
            grid.rows = 1;
            grid.columns = 1;
            grid.nodes.add(n);
            return;
        }
        for (int i = 0; i < cluster.size(); ++i) {
            cluster.get((int)i).graph = -2;
        }
        SquareNode seed = CrossClustersIntoGrids.findSeedNode(cluster);
        if (seed == null) {
            return;
        }
        if (seed.getNumberOfConnections() == 1) {
            firstRow = this.firstRow1(seed);
        } else if (seed.getNumberOfConnections() == 2) {
            firstRow = this.firstRow2(seed);
        } else {
            throw new RuntimeException("BUG");
        }
        if (this.invalid || firstRow == null) {
            return;
        }
        ArrayList<List<SquareNode>> listRows = new ArrayList<List<SquareNode>>();
        listRows.add(firstRow);
        while (this.addNextRow((SquareNode)(previous = (List)listRows.get(listRows.size() - 1)).get(0), listRows)) {
        }
        if (this.invalid || listRows.size() < 2) {
            return;
        }
        SquareGrid grid = this.assembleGrid(listRows);
        if (grid == null || !this.checkEdgeCount(grid)) {
            this.grids.removeTail();
        }
    }

    private SquareGrid assembleGrid(List<List<SquareNode>> listRows) {
        SquareGrid grid = (SquareGrid)this.grids.grow();
        grid.reset();
        List<SquareNode> row0 = listRows.get(0);
        List<SquareNode> row1 = listRows.get(1);
        int offset = row0.get(0).getNumberOfConnections() == 1 ? 0 : 1;
        grid.columns = row0.size() + row1.size();
        grid.rows = listRows.size();
        for (int i = 0; i < grid.columns * grid.rows; ++i) {
            grid.nodes.add(null);
        }
        for (int row = 0; row < listRows.size(); ++row) {
            List<SquareNode> list;
            int startCol = offset - row % 2 == 0 ? 0 : 1;
            int adjustedLength = grid.columns - startCol;
            if (adjustedLength - adjustedLength / 2 != (list = listRows.get(row)).size()) {
                return null;
            }
            int listIndex = 0;
            for (int col = startCol; col < grid.columns; col += 2) {
                grid.set(row, col, list.get(listIndex++));
            }
        }
        return grid;
    }

    private boolean checkEdgeCount(SquareGrid grid) {
        int left = 0;
        int right = grid.columns - 1;
        int top = 0;
        int bottom = grid.rows - 1;
        for (int row = 0; row < grid.rows; ++row) {
            boolean skip = grid.get(row, 0) == null;
            for (int col = 0; col < grid.columns; ++col) {
                SquareNode n = grid.get(row, col);
                if (skip) {
                    if (n != null) {
                        return false;
                    }
                } else {
                    boolean horizontalEdge = col == left || col == right;
                    boolean verticalEdge = row == top || row == bottom;
                    boolean outer = horizontalEdge || verticalEdge;
                    int connections = n.getNumberOfConnections();
                    if (outer ? (horizontalEdge && verticalEdge ? connections != 1 : connections != 2) : connections != 4) {
                        return false;
                    }
                }
                skip = !skip;
            }
        }
        return true;
    }

    List<SquareNode> firstRow1(SquareNode seed) {
        for (int i = 0; i < seed.corners.size(); ++i) {
            if (!CrossClustersIntoGrids.isOpenEdge(seed, i)) continue;
            ArrayList<SquareNode> list = new ArrayList<SquareNode>();
            seed.graph = 0;
            int corner = seed.edges[i].destinationSide(seed);
            SquareNode dst = seed.edges[i].destination(seed);
            int l = CircularIndex.addOffset((int)corner, (int)-1, (int)dst.corners.size());
            int u = CircularIndex.addOffset((int)corner, (int)1, (int)dst.corners.size());
            if (dst.edges[u] != null) {
                list.add(seed);
                if (!this.addToRow(seed, i, -1, true, list)) {
                    return null;
                }
            } else if (dst.edges[l] != null) {
                ArrayList<SquareNode> tmp = new ArrayList<SquareNode>();
                if (!this.addToRow(seed, i, 1, true, tmp)) {
                    return null;
                }
                this.flipAdd(tmp, list);
                list.add(seed);
            } else {
                list.add(seed);
            }
            return list;
        }
        throw new RuntimeException("BUG");
    }

    List<SquareNode> firstRow2(SquareNode seed) {
        int indexLower = CrossClustersIntoGrids.lowerEdgeIndex(seed);
        int indexUpper = CircularIndex.addOffset((int)indexLower, (int)1, (int)seed.corners.size());
        ArrayList<SquareNode> listDown = new ArrayList<SquareNode>();
        ArrayList<SquareNode> list = new ArrayList<SquareNode>();
        if (!this.addToRow(seed, indexUpper, 1, true, listDown)) {
            return null;
        }
        this.flipAdd(listDown, list);
        list.add(seed);
        seed.graph = 0;
        if (!this.addToRow(seed, indexLower, -1, true, list)) {
            return null;
        }
        return list;
    }

    boolean addNextRow(SquareNode seed, List<List<SquareNode>> grid) {
        ArrayList<SquareNode> row = new ArrayList<SquareNode>();
        ArrayList<SquareNode> tmp = new ArrayList<SquareNode>();
        int numConnections = CrossClustersIntoGrids.numberOfOpenEdges(seed);
        if (numConnections == 0) {
            return false;
        }
        if (numConnections == 1) {
            for (int i = 0; i < seed.corners.size(); ++i) {
                SquareEdge edge = seed.edges[i];
                if (edge == null) continue;
                SquareNode dst = edge.destination(seed);
                if (dst.graph != -2) continue;
                int corner = edge.destinationSide(seed);
                int l = CircularIndex.addOffset((int)corner, (int)-1, (int)dst.corners.size());
                int u = CircularIndex.addOffset((int)corner, (int)1, (int)dst.corners.size());
                if (CrossClustersIntoGrids.isClosedValidEdge(dst, l)) {
                    if (!this.addToRow(seed, i, 1, false, tmp)) {
                        return false;
                    }
                    this.flipAdd(tmp, row);
                } else if (CrossClustersIntoGrids.isClosedValidEdge(dst, u)) {
                    if (!this.addToRow(seed, i, -1, false, row)) {
                        return false;
                    }
                } else {
                    dst.graph = 0;
                    row.add(dst);
                }
                break;
            }
        } else if (numConnections == 2) {
            int indexLower = CrossClustersIntoGrids.lowerEdgeIndex(seed);
            int indexUpper = CircularIndex.addOffset((int)indexLower, (int)1, (int)seed.corners.size());
            if (!this.addToRow(seed, indexUpper, 1, false, tmp)) {
                return false;
            }
            this.flipAdd(tmp, row);
            if (!this.addToRow(seed, indexLower, -1, false, row)) {
                return false;
            }
        } else {
            return false;
        }
        grid.add(row);
        return true;
    }

    private void flipAdd(List<SquareNode> tmp, List<SquareNode> row) {
        for (int i = tmp.size() - 1; i >= 0; --i) {
            row.add(tmp.get(i));
        }
    }

    static int lowerEdgeIndex(SquareNode node) {
        for (int i = 0; i < node.corners.size(); ++i) {
            int previous;
            if (!CrossClustersIntoGrids.isOpenEdge(node, i)) continue;
            int next = CircularIndex.addOffset((int)i, (int)1, (int)node.corners.size());
            if (CrossClustersIntoGrids.isOpenEdge(node, next)) {
                return i;
            }
            if (i == 0 && CrossClustersIntoGrids.isOpenEdge(node, previous = node.corners.size() - 1)) {
                return previous;
            }
            return i;
        }
        throw new RuntimeException("BUG!");
    }

    static int numberOfOpenEdges(SquareNode node) {
        int total = 0;
        for (int i = 0; i < node.corners.size(); ++i) {
            if (!CrossClustersIntoGrids.isOpenEdge(node, i)) continue;
            ++total;
        }
        return total;
    }

    static boolean isOpenEdge(SquareNode node, int index) {
        if (node.edges[index] == null) {
            return false;
        }
        int marker = node.edges[index].destination((SquareNode)node).graph;
        return marker == -2;
    }

    static boolean isClosedValidEdge(SquareNode node, int index) {
        if (node.edges[index] == null) {
            return false;
        }
        int marker = node.edges[index].destination((SquareNode)node).graph;
        return marker != -2;
    }

    boolean addToRow(SquareNode n, int corner, int sign, boolean skip, List<SquareNode> row) {
        SquareEdge e;
        while ((e = n.edges[corner]) != null) {
            if (e.a == n) {
                n = e.b;
                corner = e.sideB;
            } else {
                n = e.a;
                corner = e.sideA;
            }
            if (!skip) {
                if (n.graph != -2) {
                    this.invalid = true;
                    return false;
                }
                n.graph = 0;
                row.add(n);
            }
            skip = !skip;
            corner = CircularIndex.addOffset((int)corner, (int)(sign *= -1), (int)n.corners.size());
        }
        return true;
    }

    static SquareNode findSeedNode(List<SquareNode> cluster) {
        SquareNode seed = null;
        for (int i = 0; i < cluster.size(); ++i) {
            SquareNode n = cluster.get(i);
            int numConnections = n.getNumberOfConnections();
            if (numConnections == 0 || numConnections > 2) continue;
            seed = n;
            break;
        }
        return seed;
    }

    public FastQueue<SquareGrid> getGrids() {
        return this.grids;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

