/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.fiducial.calib.squares;

import boofcv.alg.fiducial.calib.squares.SquareEdge;
import boofcv.alg.fiducial.calib.squares.SquareNode;
import boofcv.alg.fiducial.calib.squares.SquaresIntoClusters;
import boofcv.misc.CircularIndex;
import georegression.geometry.UtilLine2D_F64;
import georegression.metric.Distance2D_F64;
import georegression.metric.Intersection2D_F64;
import georegression.metric.UtilAngle;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.line.LineGeneral2D_F64;
import georegression.struct.line.LineSegment2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Vector2D_F64;
import georegression.struct.shapes.Polygon2D_F64;
import java.util.List;
import org.ddogleg.nn.FactoryNearestNeighbor;
import org.ddogleg.nn.NearestNeighbor;
import org.ddogleg.nn.NnData;
import org.ddogleg.struct.FastQueue;
import org.ddogleg.struct.RecycleManager;

public class SquaresIntoRegularClusters
extends SquaresIntoClusters {
    public int maxNeighbors;
    double distanceTol = 0.2;
    double maxNeighborDistanceRatio;
    private double spaceToSquareRatio;
    protected RecycleManager<SquareEdge> edges = new RecycleManager(SquareEdge.class);
    private LineGeneral2D_F64 line = new LineGeneral2D_F64();
    private Point2D_F64 intersection = new Point2D_F64();
    private NearestNeighbor<SquareNode> search = FactoryNearestNeighbor.kdtree();
    private FastQueue<double[]> searchPoints;
    private FastQueue<NnData<SquareNode>> searchResults = new FastQueue(NnData.class, true);
    Vector2D_F64 vector0 = new Vector2D_F64();
    Vector2D_F64 vector1 = new Vector2D_F64();

    public SquaresIntoRegularClusters(double spaceToSquareRatio, int maxNeighbors, double maxNeighborDistanceRatio) {
        this.spaceToSquareRatio = spaceToSquareRatio;
        this.maxNeighbors = maxNeighbors;
        if (this.maxNeighbors == Integer.MAX_VALUE) {
            this.maxNeighbors = 0x7FFFFFFE;
        }
        this.maxNeighborDistanceRatio = maxNeighborDistanceRatio;
        this.searchPoints = new FastQueue<double[]>(double[].class, true){

            protected double[] createInstance() {
                return new double[2];
            }
        };
        this.search.init(2);
    }

    public List<List<SquareNode>> process(List<Polygon2D_F64> squares) {
        this.recycleData();
        this.computeNodeInfo(squares);
        this.connectNodes();
        this.findClusters();
        return this.clusters.toList();
    }

    void computeNodeInfo(List<Polygon2D_F64> squares) {
        for (int i = 0; i < squares.size(); ++i) {
            SquareNode n = (SquareNode)this.nodes.grow();
            n.reset();
            n.corners = squares.get(i);
            if (n.corners.size() != 4) {
                throw new RuntimeException("Sqaures have four corners not " + n.corners.size());
            }
            this.lineA.a = n.corners.get(0);
            this.lineA.b = n.corners.get(2);
            this.lineB.a = n.corners.get(1);
            this.lineB.b = n.corners.get(3);
            Intersection2D_F64.intersection((LineSegment2D_F64)this.lineA, (LineSegment2D_F64)this.lineB, (Point2D_F64)n.center);
            for (int j = 0; j < 4; ++j) {
                double l;
                int k = (j + 1) % 4;
                n.sideLengths[j] = l = n.corners.get(j).distance((GeoTuple2D_F64)n.corners.get(k));
                n.largestSide = Math.max(n.largestSide, l);
            }
        }
    }

    void connectNodes() {
        this.setupSearch();
        for (int i = 0; i < this.nodes.size(); ++i) {
            SquareNode n = (SquareNode)this.nodes.get(i);
            double[] point = (double[])this.searchPoints.get(i);
            double neighborDistance = n.largestSide * (1.0 + this.spaceToSquareRatio) * this.maxNeighborDistanceRatio;
            this.searchResults.reset();
            this.search.findNearest(point, neighborDistance * neighborDistance, this.maxNeighbors + 1, this.searchResults);
            for (int j = 0; j < this.searchResults.size(); ++j) {
                NnData neighbor = (NnData)this.searchResults.get(j);
                if (neighbor.data == n) continue;
                this.considerConnect(n, (SquareNode)neighbor.data);
            }
        }
    }

    private void setupSearch() {
        this.searchPoints.reset();
        for (int i = 0; i < this.nodes.size(); ++i) {
            SquareNode n = (SquareNode)this.nodes.get(i);
            double[] point = (double[])this.searchPoints.grow();
            point[0] = n.center.x;
            point[1] = n.center.y;
        }
        this.search.setPoints(this.searchPoints.toList(), this.nodes.toList());
    }

    void considerConnect(SquareNode node0, SquareNode node1) {
        double ratio;
        double sideSideRatio1;
        this.lineA.a = node0.center;
        this.lineA.b = node1.center;
        int intersection0 = this.findSideIntersect(node0, this.lineA, this.lineB);
        int intersection1 = this.findSideIntersect(node1, this.lineA, this.lineB);
        if (intersection1 < 0 || intersection0 < 0) {
            return;
        }
        double sideSideRatio0 = node0.largestSide / node0.smallestSideLength();
        if (Math.abs(sideSideRatio0 - (sideSideRatio1 = node1.largestSide / node1.smallestSideLength())) > 1.2) {
            return;
        }
        double closeSide0 = node0.sideLengths[intersection0];
        double closeSide1 = node1.sideLengths[intersection1];
        double d = ratio = closeSide0 > closeSide1 ? closeSide1 / closeSide0 : closeSide0 / closeSide1;
        if (ratio < 0.5) {
            return;
        }
        double distanceApart = this.lineA.getLength();
        if (!this.mostParallel(node0, intersection0, node1, intersection1)) {
            return;
        }
        if (!this.areMiddlePointsClose(node0.corners.get(SquaresIntoRegularClusters.add(intersection0, -1)), node0.corners.get(intersection0), node1.corners.get(SquaresIntoRegularClusters.add(intersection1, 1)), node1.corners.get(SquaresIntoRegularClusters.add(intersection1, 2)))) {
            return;
        }
        if (!this.areMiddlePointsClose(node0.corners.get(SquaresIntoRegularClusters.add(intersection0, 2)), node0.corners.get(SquaresIntoRegularClusters.add(intersection0, 1)), node1.corners.get(intersection1), node1.corners.get(SquaresIntoRegularClusters.add(intersection1, -1)))) {
            return;
        }
        this.checkConnect(node0, intersection0, node1, intersection1, distanceApart);
    }

    int findSideIntersect(SquareNode n, LineSegment2D_F64 line, LineSegment2D_F64 storage) {
        for (int i = 0; i < 4; ++i) {
            int j = (i + 1) % 4;
            storage.a = n.corners.get(i);
            storage.b = n.corners.get(j);
            if (Intersection2D_F64.intersection((LineSegment2D_F64)line, (LineSegment2D_F64)storage, (Point2D_F64)this.intersection) == null) continue;
            return i;
        }
        return -1;
    }

    boolean mostParallel(SquareNode a, int sideA, SquareNode b, int sideB) {
        double selected = this.acuteAngle(a, sideA, b, sideB);
        if (selected > this.acuteAngle(a, sideA, b, SquaresIntoRegularClusters.add(sideB, 1)) || selected > this.acuteAngle(a, sideA, b, SquaresIntoRegularClusters.add(sideB, -1))) {
            return false;
        }
        return !(selected > this.acuteAngle(a, SquaresIntoRegularClusters.add(sideA, 1), b, sideB)) && !(selected > this.acuteAngle(a, SquaresIntoRegularClusters.add(sideA, -1), b, sideB));
    }

    double acuteAngle(SquareNode a, int sideA, SquareNode b, int sideB) {
        Point2D_F64 a0 = a.corners.get(sideA);
        Point2D_F64 a1 = a.corners.get(SquaresIntoRegularClusters.add(sideA, 1));
        Point2D_F64 b0 = b.corners.get(sideB);
        Point2D_F64 b1 = b.corners.get(SquaresIntoRegularClusters.add(sideB, 1));
        this.vector0.set(a1.x - a0.x, a1.y - a0.y);
        this.vector1.set(b1.x - b0.x, b1.y - b0.y);
        double acute = this.vector0.acute(this.vector1);
        return Math.min(UtilAngle.dist((double)Math.PI, (double)acute), acute);
    }

    boolean areMiddlePointsClose(Point2D_F64 p0, Point2D_F64 p1, Point2D_F64 p2, Point2D_F64 p3) {
        UtilLine2D_F64.convert((Point2D_F64)p0, (Point2D_F64)p3, (LineGeneral2D_F64)this.line);
        double tol1 = p0.distance((GeoTuple2D_F64)p1) * this.distanceTol;
        if (Distance2D_F64.distance((LineGeneral2D_F64)this.line, (Point2D_F64)p1) > tol1) {
            return false;
        }
        double tol2 = p2.distance((GeoTuple2D_F64)p3) * this.distanceTol;
        if (Distance2D_F64.distance((LineSegment2D_F64)this.lineB, (Point2D_F64)p2) > tol2) {
            return false;
        }
        UtilLine2D_F64.convert((Point2D_F64)p0, (Point2D_F64)p1, (LineGeneral2D_F64)this.line);
        if (Distance2D_F64.distance((LineGeneral2D_F64)this.line, (Point2D_F64)p2) > tol2) {
            return false;
        }
        UtilLine2D_F64.convert((Point2D_F64)p3, (Point2D_F64)p2, (LineGeneral2D_F64)this.line);
        return !(Distance2D_F64.distance((LineGeneral2D_F64)this.line, (Point2D_F64)p1) > tol1);
    }

    void checkConnect(SquareNode a, int indexA, SquareNode b, int indexB, double distance) {
        if (a.edges[indexA] != null && a.edges[indexA].distance > distance) {
            this.detachEdge(a.edges[indexA]);
        }
        if (b.edges[indexB] != null && b.edges[indexB].distance > distance) {
            this.detachEdge(b.edges[indexB]);
        }
        if (a.edges[indexA] == null && b.edges[indexB] == null) {
            this.connect(a, indexA, b, indexB, distance);
        }
    }

    private static int add(int index, int value) {
        return CircularIndex.addOffset((int)index, (int)value, (int)4);
    }
}

