/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm;

import boofcv.abst.feature.disparity.StereoDisparitySparse;
import boofcv.abst.sfm.ImagePixelTo3D;
import boofcv.alg.geo.RectifyImageOps;
import boofcv.alg.sfm.StereoProcessingBase;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.distort.PointTransform_F64;
import boofcv.struct.image.ImageSingleBand;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import org.ejml.data.DenseMatrix64F;

public class StereoSparse3D<T extends ImageSingleBand>
extends StereoProcessingBase<T>
implements ImagePixelTo3D {
    private StereoDisparitySparse<T> disparity;
    private PointTransform_F64 leftPixelToRect;
    private Point2D_F64 pixelRect = new Point2D_F64();
    private Point3D_F64 pointLeft = new Point3D_F64();
    private double w;

    public StereoSparse3D(StereoDisparitySparse<T> disparity, Class<T> imageType) {
        super(imageType);
        this.disparity = disparity;
    }

    @Override
    public void setCalibration(StereoParameters stereoParam) {
        super.setCalibration(stereoParam);
        this.leftPixelToRect = RectifyImageOps.transformPixelToRect_F64((IntrinsicParameters)stereoParam.left, (DenseMatrix64F)this.rect1);
    }

    @Override
    public void setImages(T leftImage, T rightImage) {
        super.setImages(leftImage, rightImage);
        this.disparity.setImages(this.imageLeftRect, this.imageRightRect);
    }

    @Override
    public boolean process(double x, double y) {
        this.leftPixelToRect.compute(x, y, this.pixelRect);
        if (!this.disparity.process((int)(this.pixelRect.x + 0.5), (int)(this.pixelRect.y + 0.5))) {
            return false;
        }
        this.w = this.disparity.getDisparity();
        this.computeHomo3D(this.pixelRect.x, this.pixelRect.y, this.pointLeft);
        return true;
    }

    @Override
    public double getX() {
        return this.pointLeft.x;
    }

    @Override
    public double getY() {
        return this.pointLeft.y;
    }

    @Override
    public double getZ() {
        return this.pointLeft.z;
    }

    @Override
    public double getW() {
        return this.w;
    }
}

