/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.overhead;

import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.interpolate.TypeInterpolate;
import boofcv.alg.sfm.overhead.CreateSyntheticOverheadView;
import boofcv.core.image.FactoryGImageSingleBand;
import boofcv.core.image.GImageSingleBand;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.MultiSpectral;
import georegression.struct.point.Point2D_F32;

public class CreateSyntheticOverheadViewMS<T extends ImageSingleBand>
extends CreateSyntheticOverheadView<MultiSpectral<T>> {
    private InterpolatePixelS<T>[] interp;
    private GImageSingleBand[] output;

    public CreateSyntheticOverheadViewMS(InterpolatePixelS<T>[] interp) {
        this.interp = interp;
        this.output = new GImageSingleBand[interp.length];
    }

    public CreateSyntheticOverheadViewMS(TypeInterpolate type, int numBands, Class<T> imageType) {
        this.interp = new InterpolatePixelS[numBands];
        for (int i = 0; i < numBands; ++i) {
            this.interp[i] = FactoryInterpolation.createPixelS((double)0.0, (double)255.0, (TypeInterpolate)type, imageType);
        }
        this.output = new GImageSingleBand[this.interp.length];
    }

    @Override
    public void process(MultiSpectral<T> input, MultiSpectral<T> output) {
        int N = input.getNumBands();
        for (int i = 0; i < N; ++i) {
            this.output[i] = FactoryGImageSingleBand.wrap((ImageSingleBand)output.getBand(i), (GImageSingleBand)this.output[i]);
            this.interp[i].setImage((ImageBase)input.getBand(i));
        }
        int indexMap = 0;
        for (int i = 0; i < output.height; ++i) {
            int indexOut = output.startIndex + i * output.stride;
            int j = 0;
            while (j < output.width) {
                Point2D_F32 p = this.mapPixels[indexMap];
                if (p != null) {
                    for (int k = 0; k < N; ++k) {
                        this.output[k].set(indexOut, this.interp[k].get(p.x, p.y));
                    }
                }
                ++j;
                ++indexOut;
                ++indexMap;
            }
        }
    }
}

