/*
 * Decompiled with CFR 0.152.
 */
package boofcv.alg.sfm.robust;

import boofcv.alg.sfm.overhead.CameraPlaneProjection;
import boofcv.struct.sfm.PlanePtPixel;
import georegression.fitting.MotionTransformPoint;
import georegression.fitting.se.MotionSe2PointSVD_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.se.Se2_F64;
import georegression.struct.se.Se3_F64;
import java.util.ArrayList;
import java.util.List;
import org.ddogleg.fitting.modelset.ModelGenerator;
import org.ddogleg.struct.FastQueue;

public class GenerateSe2_PlanePtPixel
implements ModelGenerator<Se2_F64, PlanePtPixel> {
    MotionTransformPoint<Se2_F64, Point2D_F64> estimator;
    private CameraPlaneProjection planeProjection = new CameraPlaneProjection();
    List<Point2D_F64> from = new ArrayList<Point2D_F64>();
    FastQueue<Point2D_F64> to = new FastQueue(Point2D_F64.class, true);

    public GenerateSe2_PlanePtPixel(MotionTransformPoint<Se2_F64, Point2D_F64> estimator) {
        this.estimator = estimator;
    }

    public GenerateSe2_PlanePtPixel() {
        this.estimator = new MotionSe2PointSVD_F64();
    }

    public void setExtrinsic(Se3_F64 planeToCamera) {
        this.planeProjection.setPlaneToCamera(planeToCamera, true);
    }

    public boolean generate(List<PlanePtPixel> dataSet, Se2_F64 keyToCurr) {
        this.from.clear();
        this.to.reset();
        for (int i = 0; i < dataSet.size(); ++i) {
            PlanePtPixel p = dataSet.get(i);
            Point2D_F64 planeCurr = (Point2D_F64)this.to.grow();
            if (this.planeProjection.normalToPlane(p.normalizedCurr.x, p.normalizedCurr.y, planeCurr)) {
                this.from.add(p.getPlaneKey());
                continue;
            }
            this.to.removeTail();
        }
        if (!this.estimator.process(this.from, this.to.toList())) {
            return false;
        }
        keyToCurr.set((Se2_F64)this.estimator.getMotion());
        return true;
    }

    public int getMinimumPoints() {
        return this.estimator.getMinimumPoints();
    }
}

