/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.sfm.d3;

import boofcv.abst.feature.tracker.PointTrack;
import boofcv.abst.sfm.AccessPointTracks3D;
import boofcv.abst.sfm.d3.StereoVisualOdometry;
import boofcv.alg.distort.LensDistortionOps;
import boofcv.alg.geo.DistanceModelMonoPixels;
import boofcv.alg.sfm.StereoSparse3D;
import boofcv.alg.sfm.d3.VisOdomPixelDepthPnP;
import boofcv.struct.calib.IntrinsicParameters;
import boofcv.struct.calib.StereoParameters;
import boofcv.struct.distort.PointTransform_F64;
import boofcv.struct.geo.Point2D3D;
import boofcv.struct.image.ImageSingleBand;
import boofcv.struct.image.ImageType;
import boofcv.struct.sfm.Point2D3DTrack;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.se.Se3_F64;
import java.util.ArrayList;
import java.util.List;

public class WrapVisOdomPixelDepthPnP<T extends ImageSingleBand>
implements StereoVisualOdometry<T>,
AccessPointTracks3D {
    VisOdomPixelDepthPnP<T> alg;
    StereoSparse3D<T> stereo;
    DistanceModelMonoPixels<Se3_F64, Point2D3D> distance;
    Class<T> imageType;
    boolean success;
    List<PointTrack> active = new ArrayList<PointTrack>();

    public WrapVisOdomPixelDepthPnP(VisOdomPixelDepthPnP<T> alg, StereoSparse3D<T> stereo, DistanceModelMonoPixels<Se3_F64, Point2D3D> distance, Class<T> imageType) {
        this.alg = alg;
        this.stereo = stereo;
        this.distance = distance;
        this.imageType = imageType;
    }

    @Override
    public Point3D_F64 getTrackLocation(int index) {
        PointTrack t = (PointTrack)this.alg.getTracker().getActiveTracks(null).get(index);
        return ((Point2D3D)t.getCookie()).getLocation();
    }

    @Override
    public long getTrackId(int index) {
        return this.active.get((int)index).featureId;
    }

    @Override
    public List<Point2D_F64> getAllTracks() {
        return this.active;
    }

    @Override
    public boolean isInlier(int index) {
        Point2D3DTrack t = (Point2D3DTrack)((Object)this.active.get(index).getCookie());
        return t.lastInlier == this.alg.getTick();
    }

    @Override
    public boolean isNew(int index) {
        PointTrack t = (PointTrack)this.alg.getTracker().getActiveTracks(null).get(index);
        return this.alg.getTracker().getNewTracks(null).contains(t);
    }

    @Override
    public void setCalibration(StereoParameters parameters) {
        this.stereo.setCalibration(parameters);
        IntrinsicParameters l = parameters.left;
        PointTransform_F64 leftPixelToNorm = LensDistortionOps.transformRadialToNorm_F64((IntrinsicParameters)l);
        PointTransform_F64 leftNormToPixel = LensDistortionOps.transformNormToRadial_F64((IntrinsicParameters)l);
        this.alg.setPixelToNorm(leftPixelToNorm);
        this.alg.setNormToPixel(leftNormToPixel);
        this.distance.setIntrinsic(l.fx, l.fy, l.skew);
    }

    @Override
    public boolean process(T leftImage, T rightImage) {
        this.stereo.setImages(leftImage, rightImage);
        this.success = this.alg.process(leftImage);
        this.active.clear();
        this.alg.getTracker().getActiveTracks(this.active);
        return this.success;
    }

    @Override
    public ImageType<T> getImageType() {
        return ImageType.single(this.imageType);
    }

    @Override
    public void reset() {
        this.alg.reset();
    }

    @Override
    public boolean isFault() {
        return !this.success;
    }

    @Override
    public Se3_F64 getCameraToWorld() {
        return this.alg.getCurrToWorld();
    }
}

