/*
 * Decompiled with CFR 0.152.
 */
package boofcv.abst.sfm.d2;

import boofcv.abst.sfm.AccessPointTracks;
import boofcv.abst.sfm.d2.ImageMotion2D;
import boofcv.core.image.GConvertImage;
import boofcv.core.image.GeneralizedImageOps;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.Planar;
import georegression.struct.InvertibleTransform;
import georegression.struct.point.Point2D_F64;
import java.util.List;

public class PlToGrayMotion2D<T extends ImageGray, IT extends InvertibleTransform>
implements ImageMotion2D<Planar<T>, IT>,
AccessPointTracks {
    ImageMotion2D<T, IT> motion;
    AccessPointTracks access;
    T gray;

    public PlToGrayMotion2D(ImageMotion2D<T, IT> motion, Class<T> imageType) {
        this.motion = motion;
        this.gray = GeneralizedImageOps.createSingleBand(imageType, (int)1, (int)1);
        if (motion instanceof AccessPointTracks) {
            this.access = (AccessPointTracks)((Object)motion);
        }
    }

    @Override
    public boolean process(Planar<T> input) {
        this.gray.reshape(input.width, input.height);
        GConvertImage.average(input, this.gray);
        return this.motion.process(this.gray);
    }

    @Override
    public void reset() {
        this.motion.reset();
    }

    @Override
    public void setToFirst() {
        this.motion.setToFirst();
    }

    @Override
    public IT getFirstToCurrent() {
        return this.motion.getFirstToCurrent();
    }

    @Override
    public Class<IT> getTransformType() {
        return this.motion.getTransformType();
    }

    @Override
    public long getTrackId(int index) {
        return this.access.getTrackId(index);
    }

    @Override
    public List<Point2D_F64> getAllTracks() {
        return this.access.getAllTracks();
    }

    @Override
    public boolean isInlier(int index) {
        return this.access.isInlier(index);
    }

    @Override
    public boolean isNew(int index) {
        return this.access.isNew(index);
    }
}

