/*
 * Decompiled with CFR 0.152.
 */
package boofcv.factory.sfm;

import boofcv.abst.feature.tracker.PointTracker;
import boofcv.abst.sfm.d2.ImageMotion2D;
import boofcv.abst.sfm.d2.WrapImageMotionPtkSmartRespawn;
import boofcv.alg.distort.ImageDistort;
import boofcv.alg.geo.robust.DistanceAffine2DSq;
import boofcv.alg.geo.robust.DistanceHomographySq;
import boofcv.alg.geo.robust.DistanceSe2Sq;
import boofcv.alg.geo.robust.GenerateAffine2D;
import boofcv.alg.geo.robust.GenerateHomographyLinear;
import boofcv.alg.geo.robust.GenerateSe2_AssociatedPair;
import boofcv.alg.interpolate.InterpolatePixelS;
import boofcv.alg.interpolate.TypeInterpolate;
import boofcv.alg.sfm.d2.FactoryStitchingTransform;
import boofcv.alg.sfm.d2.ImageMotionPointTrackerKey;
import boofcv.alg.sfm.d2.ImageMotionPtkSmartRespawn;
import boofcv.alg.sfm.d2.StitchingFromMotion2D;
import boofcv.alg.sfm.d2.StitchingTransform;
import boofcv.core.image.border.BorderType;
import boofcv.factory.distort.FactoryDistort;
import boofcv.factory.interpolate.FactoryInterpolation;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import boofcv.struct.image.Planar;
import georegression.fitting.MotionTransformPoint;
import georegression.fitting.affine.ModelManagerAffine2D_F64;
import georegression.fitting.homography.ModelManagerHomography2D_F64;
import georegression.fitting.se.ModelManagerSe2_F64;
import georegression.fitting.se.MotionSe2PointSVD_F64;
import georegression.struct.InvertibleTransform;
import georegression.struct.affine.Affine2D_F64;
import georegression.struct.homography.Homography2D_F64;
import georegression.struct.se.Se2_F64;
import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ddogleg.fitting.modelset.ModelGenerator;
import org.ddogleg.fitting.modelset.ModelManager;
import org.ddogleg.fitting.modelset.ransac.Ransac;

public class FactoryMotion2D {
    public static <I extends ImageBase, IT extends InvertibleTransform> ImageMotion2D<I, IT> createMotion2D(int ransacIterations, double inlierThreshold, int outlierPrune, int absoluteMinimumTracks, double respawnTrackFraction, double respawnCoverageFraction, boolean refineEstimate, PointTracker<I> tracker, IT motionModel) {
        DistanceHomographySq distance;
        GenerateHomographyLinear fitter;
        ModelManagerAffine2D_F64 manager;
        GenerateHomographyLinear mf;
        GenerateHomographyLinear modelRefiner = null;
        if (motionModel instanceof Homography2D_F64) {
            mf = new GenerateHomographyLinear(true);
            manager = new ModelManagerHomography2D_F64();
            fitter = mf;
            if (refineEstimate) {
                modelRefiner = mf;
            }
            distance = new DistanceHomographySq();
        } else if (motionModel instanceof Affine2D_F64) {
            manager = new ModelManagerAffine2D_F64();
            fitter = mf = new GenerateAffine2D();
            if (refineEstimate) {
                modelRefiner = mf;
            }
            distance = new DistanceAffine2DSq();
        } else if (motionModel instanceof Se2_F64) {
            manager = new ModelManagerSe2_F64();
            MotionSe2PointSVD_F64 alg = new MotionSe2PointSVD_F64();
            GenerateSe2_AssociatedPair mf2 = new GenerateSe2_AssociatedPair((MotionTransformPoint)alg);
            fitter = mf2;
            distance = new DistanceSe2Sq();
        } else {
            throw new RuntimeException("Unknown model type: " + motionModel.getClass().getSimpleName());
        }
        Ransac modelMatcher = new Ransac(123123L, (ModelManager)manager, (ModelGenerator)fitter, (DistanceFromModel)distance, ransacIterations, inlierThreshold);
        ImageMotionPointTrackerKey<I, IT> lowlevel = new ImageMotionPointTrackerKey<I, IT>(tracker, modelMatcher, modelRefiner, motionModel, outlierPrune);
        ImageMotionPtkSmartRespawn<I, IT> smartRespawn = new ImageMotionPtkSmartRespawn<I, IT>(lowlevel, absoluteMinimumTracks, respawnTrackFraction, respawnCoverageFraction);
        return new WrapImageMotionPtkSmartRespawn<I, IT>(smartRespawn);
    }

    public static <I extends ImageGray, IT extends InvertibleTransform> StitchingFromMotion2D<I, IT> createVideoStitch(double maxJumpFraction, ImageMotion2D<I, IT> motion2D, Class<I> imageType) {
        StitchingTransform<Object> transform = motion2D.getTransformType() == Affine2D_F64.class ? FactoryStitchingTransform.createAffine_F64() : FactoryStitchingTransform.createHomography_F64();
        InterpolatePixelS interp = FactoryInterpolation.createPixelS((double)0.0, (double)255.0, (TypeInterpolate)TypeInterpolate.BILINEAR, (BorderType)BorderType.EXTENDED, imageType);
        ImageDistort distorter = FactoryDistort.distortSB((boolean)false, (InterpolatePixelS)interp, imageType);
        distorter.setRenderAll(false);
        return new StitchingFromMotion2D<I, Affine2D_F64>(motion2D, distorter, transform, maxJumpFraction);
    }

    public static <I extends ImageGray, IT extends InvertibleTransform> StitchingFromMotion2D<Planar<I>, IT> createVideoStitchMS(double maxJumpFraction, ImageMotion2D<Planar<I>, IT> motion2D, Class<I> imageType) {
        StitchingTransform<Object> transform = motion2D.getTransformType() == Affine2D_F64.class ? FactoryStitchingTransform.createAffine_F64() : FactoryStitchingTransform.createHomography_F64();
        InterpolatePixelS interp = FactoryInterpolation.createPixelS((double)0.0, (double)255.0, (TypeInterpolate)TypeInterpolate.BILINEAR, (BorderType)BorderType.EXTENDED, imageType);
        ImageDistort distorter = FactoryDistort.distortPL((boolean)false, (InterpolatePixelS)interp, imageType);
        distorter.setRenderAll(false);
        return new StitchingFromMotion2D<Planar<I>, Affine2D_F64>(motion2D, distorter, transform, maxJumpFraction);
    }
}

