/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.feature;

import boofcv.alg.segmentation.ImageSegmentationOps;
import boofcv.gui.binary.VisualizeBinaryData;
import boofcv.struct.image.ImageSInt32;
import boofcv.struct.image.ImageUInt8;
import java.awt.image.BufferedImage;
import org.ddogleg.struct.FastQueue;

public class VisualizeRegions {
    public static BufferedImage watersheds(ImageSInt32 segments, BufferedImage output) {
        if (output == null) {
            output = new BufferedImage(segments.width, segments.height, 1);
        }
        for (int y = 0; y < segments.height; ++y) {
            for (int x = 0; x < segments.width; ++x) {
                int index = segments.unsafe_get(x, y);
                if (index != 0) continue;
                output.setRGB(x, y, 0xFF0000);
            }
        }
        return output;
    }

    public static BufferedImage regions(ImageSInt32 pixelToRegion, int numRegions, BufferedImage output) {
        return VisualizeBinaryData.renderLabeled(pixelToRegion, numRegions, output);
    }

    public static BufferedImage regionsColor(ImageSInt32 pixelToRegion, FastQueue<float[]> segmentColor, BufferedImage output) {
        if (output == null) {
            output = new BufferedImage(pixelToRegion.width, pixelToRegion.height, 1);
        }
        for (int y = 0; y < pixelToRegion.height; ++y) {
            for (int x = 0; x < pixelToRegion.width; ++x) {
                int b;
                int g;
                int r;
                int index = pixelToRegion.unsafe_get(x, y);
                float[] cv = (float[])segmentColor.get(index);
                if (cv.length == 3) {
                    r = (int)cv[0];
                    g = (int)cv[1];
                    b = (int)cv[2];
                } else {
                    g = b = (int)cv[0];
                    r = b;
                }
                int rgb = r << 16 | g << 8 | b;
                output.setRGB(x, y, rgb);
            }
        }
        return output;
    }

    public static BufferedImage regionBorders(ImageSInt32 pixelToRegion, int borderColor, BufferedImage output) {
        if (output == null) {
            output = new BufferedImage(pixelToRegion.width, pixelToRegion.height, 1);
        }
        ImageUInt8 binary = new ImageUInt8(pixelToRegion.width, pixelToRegion.height);
        ImageSegmentationOps.markRegionBorders((ImageSInt32)pixelToRegion, (ImageUInt8)binary);
        for (int y = 0; y < binary.height; ++y) {
            for (int x = 0; x < binary.width; ++x) {
                if (binary.unsafe_get(x, y) != 1) continue;
                output.setRGB(x, y, borderColor);
            }
        }
        return output;
    }
}

