/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.d3;

import boofcv.gui.d3.ColorPoint3D;
import boofcv.misc.BoofMiscOps;
import boofcv.struct.distort.PointTransform_F64;
import boofcv.struct.image.GrayF32;
import boofcv.struct.image.GrayU8;
import boofcv.struct.image.ImageBase;
import boofcv.struct.image.ImageGray;
import georegression.geometry.ConvertRotation3D_F64;
import georegression.geometry.GeometryMath_F64;
import georegression.struct.EulerType;
import georegression.struct.GeoTuple2D_F64;
import georegression.struct.point.Point2D_F64;
import georegression.struct.point.Point3D_F64;
import georegression.struct.point.Vector3D_F64;
import georegression.struct.se.Se3_F64;
import georegression.transform.se.SePointOps_F64;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import org.ddogleg.struct.FastQueue;
import org.ejml.data.DenseMatrix64F;

public class DisparityPointCloudViewer
extends JPanel {
    FastQueue<ColorPoint3D> cloud = new FastQueue(200, ColorPoint3D.class, true);
    double baseline;
    DenseMatrix64F K;
    double focalLengthX;
    double focalLengthY;
    double centerX;
    double centerY;
    int minDisparity;
    int rangeDisparity;
    double range = 1.0;
    double offsetX;
    double offsetY;
    Pixel[] data = new Pixel[0];
    public int tiltAngle = 0;
    public double radius = 5.0;
    PointTransform_F64 rectifiedToColor;
    Point2D_F64 colorPt = new Point2D_F64();

    public void configure(double baseline, DenseMatrix64F K, PointTransform_F64 rectifiedToColor, int minDisparity, int maxDisparity) {
        this.K = K;
        this.rectifiedToColor = rectifiedToColor;
        this.baseline = baseline;
        this.focalLengthX = K.get(0, 0);
        this.focalLengthY = K.get(1, 1);
        this.centerX = K.get(0, 2);
        this.centerY = K.get(1, 2);
        this.minDisparity = minDisparity;
        this.rangeDisparity = maxDisparity - minDisparity;
    }

    public void process(ImageGray disparity, BufferedImage color) {
        if (disparity instanceof GrayU8) {
            this.process((GrayU8)disparity, color);
        } else {
            this.process((GrayF32)disparity, color);
        }
    }

    private void process(GrayU8 disparity, BufferedImage color) {
        this.cloud.reset();
        for (int y = 0; y < disparity.height; ++y) {
            int index = disparity.startIndex + disparity.stride * y;
            for (int x = 0; x < disparity.width; ++x) {
                int value;
                if ((value = disparity.data[index++] & 0xFF) >= this.rangeDisparity || (value += this.minDisparity) == 0) continue;
                ColorPoint3D p = (ColorPoint3D)((Object)this.cloud.grow());
                p.z = this.baseline * this.focalLengthX / (double)value;
                p.x = p.z * ((double)x - this.centerX) / this.focalLengthX;
                p.y = p.z * ((double)y - this.centerY) / this.focalLengthY;
                this.getColor((ImageBase)disparity, color, x, y, p);
            }
        }
    }

    private void process(GrayF32 disparity, BufferedImage color) {
        this.cloud.reset();
        for (int y = 0; y < disparity.height; ++y) {
            int index = disparity.startIndex + disparity.stride * y;
            for (int x = 0; x < disparity.width; ++x) {
                float value;
                if ((value = disparity.data[index++]) >= (float)this.rangeDisparity || (value += (float)this.minDisparity) == 0.0f) continue;
                ColorPoint3D p = (ColorPoint3D)((Object)this.cloud.grow());
                p.z = this.baseline * this.focalLengthX / (double)value;
                p.x = p.z * ((double)x - this.centerX) / this.focalLengthX;
                p.y = p.z * ((double)y - this.centerY) / this.focalLengthY;
                this.getColor((ImageBase)disparity, color, x, y, p);
            }
        }
    }

    private void getColor(ImageBase disparity, BufferedImage color, int x, int y, ColorPoint3D p) {
        this.rectifiedToColor.compute((double)x, (double)y, this.colorPt);
        p.rgb = BoofMiscOps.checkInside((ImageBase)disparity, (double)this.colorPt.x, (double)this.colorPt.y, (double)0.0) ? color.getRGB((int)this.colorPt.x, (int)this.colorPt.y) : 0;
    }

    @Override
    public synchronized void paintComponent(Graphics g) {
        super.paintComponent(g);
        this.projectScene();
        int width = this.getWidth();
        int h = this.getHeight();
        int r = 2;
        int w = r * 2 + 1;
        Graphics2D g2 = (Graphics2D)g;
        int index = 0;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < width; ++x) {
                Pixel p = this.data[index++];
                if (p.rgb == -1) continue;
                g2.setColor(new Color(p.rgb));
                g2.fillRect(x - r, y - r, w, w);
            }
        }
    }

    private void projectScene() {
        int i;
        int h;
        int w = this.getWidth();
        int N = w * (h = this.getHeight());
        if (this.data.length < N) {
            this.data = new Pixel[N];
            for (i = 0; i < N; ++i) {
                this.data[i] = new Pixel();
            }
        } else {
            for (i = 0; i < N; ++i) {
                this.data[i].reset();
            }
        }
        Se3_F64 pose = this.createWorldToCamera();
        Point3D_F64 cameraPt = new Point3D_F64();
        Point2D_F64 pixel = new Point2D_F64();
        for (int i2 = 0; i2 < this.cloud.size(); ++i2) {
            ColorPoint3D p = (ColorPoint3D)((Object)this.cloud.get(i2));
            SePointOps_F64.transform((Se3_F64)pose, (Point3D_F64)p, (Point3D_F64)cameraPt);
            pixel.x = cameraPt.x / cameraPt.z;
            pixel.y = cameraPt.y / cameraPt.z;
            GeometryMath_F64.mult((DenseMatrix64F)this.K, (GeoTuple2D_F64)pixel, (GeoTuple2D_F64)pixel);
            int x = (int)pixel.x;
            int y = (int)pixel.y;
            if (x < 0 || y < 0 || x >= w || y >= h) continue;
            Pixel d = this.data[y * w + x];
            if (!(d.height > cameraPt.z)) continue;
            d.height = cameraPt.z;
            d.rgb = p.rgb;
        }
    }

    public Se3_F64 createWorldToCamera() {
        double z = this.baseline * this.focalLengthX / (double)(this.minDisparity + this.rangeDisparity);
        double adjust = this.baseline / 20.0;
        Vector3D_F64 rotPt = new Vector3D_F64(this.offsetX * adjust, this.offsetY * adjust, z * this.range);
        double radians = (double)this.tiltAngle * Math.PI / 180.0;
        DenseMatrix64F R = ConvertRotation3D_F64.eulerToMatrix((EulerType)EulerType.XYZ, (double)radians, (double)0.0, (double)0.0, null);
        Se3_F64 a = new Se3_F64(R, rotPt);
        return a;
    }

    private static class Pixel {
        public double height;
        public int rgb;

        private Pixel() {
            this.reset();
        }

        public void reset() {
            this.height = Double.MAX_VALUE;
            this.rgb = -1;
        }
    }
}

