/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui.d3;

import boofcv.gui.d3.DisparityPointCloudViewer;
import boofcv.struct.distort.PointTransform_F64;
import boofcv.struct.image.ImageGray;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JToolBar;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.ejml.data.DenseMatrix64F;

public class PointCloudTiltPanel
extends JPanel
implements ActionListener,
ChangeListener,
MouseListener,
MouseMotionListener {
    DisparityPointCloudViewer view;
    JButton homeButton;
    JSpinner rangeSpinner;
    JSlider tiltSlider;
    double minRange = 0.0;
    double maxRange = 20.0;
    int prevX;
    int prevY;

    public PointCloudTiltPanel() {
        super(new BorderLayout());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.view = new DisparityPointCloudViewer();
        JToolBar toolBar = this.createToolBar();
        this.add((Component)toolBar, "First");
        this.add((Component)this.view, "Center");
    }

    private JToolBar createToolBar() {
        JToolBar toolBar = new JToolBar("Controls");
        this.homeButton = new JButton("Home");
        this.homeButton.addActionListener(this);
        this.rangeSpinner = new JSpinner(new SpinnerNumberModel(this.view.range, this.minRange, this.maxRange, 0.2));
        this.rangeSpinner.addChangeListener(this);
        this.rangeSpinner.setMaximumSize(this.rangeSpinner.getPreferredSize());
        this.tiltSlider = new JSlider(0, -120, 120, this.view.tiltAngle);
        this.tiltSlider.addChangeListener(this);
        this.tiltSlider.setMajorTickSpacing(60);
        this.tiltSlider.setPaintLabels(true);
        toolBar.add(this.homeButton);
        toolBar.add(new JToolBar.Separator(new Dimension(10, 1)));
        toolBar.add(new JLabel("Range:"));
        toolBar.add(this.rangeSpinner);
        toolBar.add(new JToolBar.Separator(new Dimension(10, 1)));
        toolBar.add(new JLabel("Tilt Angle:"));
        toolBar.add(this.tiltSlider);
        return toolBar;
    }

    public void configure(double baseline, DenseMatrix64F K, PointTransform_F64 rectifiedToColor, int minDisparity, int maxDisparity) {
        this.view.configure(baseline, K, rectifiedToColor, minDisparity, maxDisparity);
    }

    public void process(ImageGray disparity, BufferedImage color) {
        this.view.process(disparity, color);
        this.tiltSlider.removeChangeListener(this);
        this.tiltSlider.setValue(this.view.tiltAngle);
        this.tiltSlider.addChangeListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.homeButton) {
            this.view.offsetX = 0.0;
            this.view.offsetY = 0.0;
            this.view.tiltAngle = 0;
            this.view.range = 1.0;
            this.tiltSlider.removeChangeListener(this);
            this.tiltSlider.setValue(this.view.tiltAngle);
            this.tiltSlider.addChangeListener(this);
            this.rangeSpinner.removeChangeListener(this);
            this.rangeSpinner.setValue(this.view.range);
            this.rangeSpinner.addChangeListener(this);
        }
        this.view.repaint();
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.rangeSpinner) {
            this.view.range = ((Number)this.rangeSpinner.getValue()).doubleValue();
        } else if (e.getSource() == this.tiltSlider) {
            this.view.tiltAngle = this.tiltSlider.getValue();
        }
        this.view.repaint();
    }

    @Override
    public synchronized void mouseClicked(MouseEvent e) {
        double range = this.view.range;
        range = e.isShiftDown() ? (range *= 0.75) : (range *= 1.25);
        if (range < this.minRange) {
            range = this.minRange;
        }
        if (range > this.maxRange) {
            range = this.maxRange;
        }
        this.rangeSpinner.setValue(range);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.prevX = e.getX();
        this.prevY = e.getY();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public synchronized void mouseDragged(MouseEvent e) {
        int deltaX = e.getX() - this.prevX;
        int deltaY = e.getY() - this.prevY;
        this.view.offsetX += (double)deltaX;
        this.view.offsetY += (double)deltaY;
        this.prevX = e.getX();
        this.prevY = e.getY();
        this.view.repaint();
    }

    @Override
    public void mouseMoved(MouseEvent e) {
    }
}

