/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui;

import boofcv.abst.scene.ImageClassifier;
import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ScaleOptions;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.Spring;
import javax.swing.SpringLayout;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class ImageClassificationPanel
extends JPanel
implements ListSelectionListener {
    JTextArea textArea = new JTextArea();
    JScrollPane listScroll;
    private JList listPanel;
    private ImagePanel centerImage = new ImagePanel();
    DefaultListModel listModel = new DefaultListModel();
    final List<Image> results = new ArrayList<Image>();

    public ImageClassificationPanel() {
        super(new BorderLayout());
        this.listPanel = new JList(this.listModel);
        this.listPanel.setSelectionMode(0);
        this.listPanel.setSelectedIndex(0);
        this.listPanel.addListSelectionListener(this);
        this.listScroll = new JScrollPane(this.listPanel);
        this.listScroll.setVerticalScrollBarPolicy(22);
        this.listScroll.setHorizontalScrollBarPolicy(31);
        JPanel centerPanel = new JPanel();
        SpringLayout spring = new SpringLayout();
        centerPanel.setLayout(spring);
        centerPanel.add(this.textArea);
        centerPanel.add(this.centerImage);
        centerPanel.setPreferredSize(new Dimension(600, 600));
        Spring pw = spring.getConstraint("Width", centerPanel);
        Spring ph = spring.getConstraint("Height", centerPanel);
        SpringLayout.Constraints c = spring.getConstraints(this.centerImage);
        c.setWidth(Spring.scale(pw, 1.0f));
        c.setHeight(Spring.scale(ph, 1.0f));
        this.centerImage.setScaling(ScaleOptions.DOWN);
        this.centerImage.setOpaque(true);
        this.textArea.setFont(new Font("Courier New", 1, 16));
        this.textArea.setLineWrap(false);
        this.textArea.setOpaque(true);
        this.textArea.setForeground(Color.BLACK);
        this.textArea.setBackground(new Color(255, 255, 255, 125));
        this.add((Component)centerPanel, "Center");
        this.add((Component)this.listScroll, "West");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addImage(BufferedImage image, String name, List<ImageClassifier.Score> scores, List<String> categories) {
        List<Image> list = this.results;
        synchronized (list) {
            final Image a = new Image();
            a.image = image;
            a.name = name;
            for (ImageClassifier.Score score : scores) {
                a.results.add(String.format("%6.2f %s", score.score, categories.get(score.category)));
            }
            this.results.add(a);
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ImageClassificationPanel.this.listModel.addElement(a.name);
                    if (ImageClassificationPanel.this.listModel.size() == 1) {
                        ImageClassificationPanel.this.listPanel.setSelectedIndex(0);
                    }
                    Dimension d = ImageClassificationPanel.this.listPanel.getMinimumSize();
                    ImageClassificationPanel.this.listPanel.setPreferredSize(new Dimension(d.width + ImageClassificationPanel.this.listScroll.getVerticalScrollBar().getWidth(), d.height));
                    ImageClassificationPanel.this.validate();
                }
            });
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        int index = this.listPanel.getSelectedIndex();
        if (index >= 0) {
            Image selected;
            List<Image> list = this.results;
            synchronized (list) {
                selected = this.results.get(index);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ImageClassificationPanel.this.centerImage.setBufferedImage(selected.image);
                    ImageClassificationPanel.this.centerImage.setPreferredSize(new Dimension(selected.image.getWidth(), selected.image.getHeight()));
                    ImageClassificationPanel.this.centerImage.validate();
                    ImageClassificationPanel.this.centerImage.repaint();
                    String text = "";
                    int N = Math.min(5, selected.results.size());
                    for (String s : selected.results.subList(0, N)) {
                        text = text + s + "\n";
                    }
                    ImageClassificationPanel.this.textArea.setText(text);
                }
            });
        }
    }

    private static class Image {
        BufferedImage image;
        String name;
        List<String> results = new ArrayList<String>();

        private Image() {
        }
    }
}

