/*
 * Decompiled with CFR 0.152.
 */
package boofcv.gui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Date;
import java.util.List;

public class JavaRuntimeLauncher {
    String classPath;
    long memoryInMB = 200L;
    long frozenTime = 60000L;
    long durationMilli;
    volatile boolean killRequested = false;
    String[] jvmArgs;
    PrintStream printOut = System.out;
    PrintStream printErr = System.err;
    char[] buffInput = new char[1024];

    public JavaRuntimeLauncher(List<String> pathJars) {
        String sep = System.getProperty("path.separator");
        if (pathJars != null) {
            this.classPath = "";
            for (String s : pathJars) {
                this.classPath = this.classPath + sep + s;
            }
        }
    }

    public void setFrozenTime(long frozenTime) {
        this.frozenTime = frozenTime;
    }

    public void setMemoryInMB(long memoryInMB) {
        this.memoryInMB = memoryInMB;
    }

    public long getDurationMilli() {
        return this.durationMilli;
    }

    public Exit launch(Class mainClass, String ... args) {
        this.jvmArgs = this.configureArguments(mainClass, args);
        try {
            Runtime rt = Runtime.getRuntime();
            Process pr = rt.exec(this.jvmArgs);
            Thread.sleep(500L);
            BufferedReader input = new BufferedReader(new InputStreamReader(pr.getInputStream()));
            BufferedReader error = new BufferedReader(new InputStreamReader(pr.getErrorStream()));
            if (!this.monitorSlave(pr, input, error)) {
                if (this.killRequested) {
                    return Exit.REQUESTED;
                }
                return Exit.FROZEN;
            }
            if (pr.exitValue() != 0) {
                return Exit.RETURN_NOT_ZERO;
            }
            return Exit.NORMAL;
        }
        catch (IOException | InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean monitorSlave(Process pr, BufferedReader input, BufferedReader error) throws IOException, InterruptedException {
        long startTime;
        System.in.skip(System.in.available());
        boolean frozen = false;
        long lastAliveMessage = startTime = System.currentTimeMillis();
        while (true) {
            if (System.in.available() > 0) {
                if (System.in.read() != 113) continue;
                System.out.println("User requested for the application to quit by pressing 'q'");
                System.exit(0);
                continue;
            }
            this.printBuffer(error, this.printErr);
            if (input.ready()) {
                this.printBuffer(input, this.printOut);
            } else {
                Thread.sleep(500L);
            }
            try {
                pr.exitValue();
            }
            catch (IllegalThreadStateException e) {
                if (this.killRequested) {
                    pr.destroy();
                    break;
                }
                if (this.frozenTime > 0L && System.currentTimeMillis() - startTime > this.frozenTime) {
                    pr.destroy();
                    frozen = true;
                    break;
                }
                if (System.currentTimeMillis() - lastAliveMessage <= 60000L) continue;
                System.out.println("\nMaster is still alive: " + new Date() + "  Press 'q' and enter to quit.");
                lastAliveMessage = System.currentTimeMillis();
                continue;
            }
            break;
        }
        this.printBuffer(error, this.printErr);
        this.printBuffer(input, this.printOut);
        this.durationMilli = System.currentTimeMillis() - startTime;
        return !frozen && !this.killRequested;
    }

    protected void printBuffer(BufferedReader input, PrintStream output) throws IOException {
        int val;
        int length = 0;
        while (input.ready() && (val = input.read()) >= 0) {
            this.buffInput[length++] = (char)val;
            if (length != this.buffInput.length) continue;
            output.print(new String(this.buffInput, 0, length));
            length = 0;
        }
        output.print(new String(this.buffInput, 0, length));
    }

    private String[] configureArguments(Class mainClass, String ... args) {
        String app;
        String[] out = new String[7 + args.length];
        out[0] = app = System.getProperty("java.home") + "/bin/java";
        out[1] = "-server";
        out[2] = "-Xms" + this.memoryInMB + "M";
        out[3] = "-Xmx" + this.memoryInMB + "M";
        out[4] = "-classpath";
        out[5] = this.classPath;
        out[6] = mainClass.getName();
        for (int i = 0; i < args.length; ++i) {
            out[7 + i] = args[i];
        }
        return out;
    }

    public String getClassPath() {
        return this.classPath;
    }

    public long getAllocatedMemoryInMB() {
        return this.memoryInMB;
    }

    public long getFrozenTime() {
        return this.frozenTime;
    }

    public String[] getArguments() {
        return this.jvmArgs;
    }

    public void requestKill() {
        this.killRequested = true;
    }

    public boolean isKillRequested() {
        return this.killRequested;
    }

    public PrintStream getPrintOut() {
        return this.printOut;
    }

    public void setPrintOut(PrintStream out) {
        this.printOut = out;
    }

    public PrintStream getPrintErr() {
        return this.printErr;
    }

    public void setPrintErr(PrintStream err) {
        this.printErr = err;
    }

    public static enum Exit {
        NORMAL,
        FROZEN,
        REQUESTED,
        RETURN_NOT_ZERO;

    }
}

