/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.KeyStoreSpi;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BEROctetString;
import org.bouncycastle.asn1.BEROutputStream;
import org.bouncycastle.asn1.DERBMPString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.cryptopro.GOST28147Parameters;
import org.bouncycastle.asn1.nist.NISTObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.AuthenticatedSafe;
import org.bouncycastle.asn1.pkcs.CertBag;
import org.bouncycastle.asn1.pkcs.ContentInfo;
import org.bouncycastle.asn1.pkcs.EncryptedData;
import org.bouncycastle.asn1.pkcs.EncryptedPrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.MacData;
import org.bouncycastle.asn1.pkcs.PBES2Parameters;
import org.bouncycastle.asn1.pkcs.PBKDF2Params;
import org.bouncycastle.asn1.pkcs.PKCS12PBEParams;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.Pfx;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.pkcs.SafeBag;
import org.bouncycastle.asn1.util.ASN1Dump;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.AuthorityKeyIdentifier;
import org.bouncycastle.asn1.x509.DigestInfo;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.SubjectKeyIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.crypto.DigestAlgorithm;
import org.bouncycastle.crypto.PasswordBasedDeriver;
import org.bouncycastle.crypto.PasswordConverter;
import org.bouncycastle.crypto.fips.FipsDigestAlgorithm;
import org.bouncycastle.crypto.fips.FipsOutputDigestCalculator;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.general.PBKD;
import org.bouncycastle.crypto.general.SecureHash;
import org.bouncycastle.jcajce.ConsistentKeyPair;
import org.bouncycastle.jcajce.PKCS12KeyWithParameters;
import org.bouncycastle.jcajce.PKCS12StoreParameter;
import org.bouncycastle.jcajce.provider.AsymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.BaseAlgorithmParameters;
import org.bouncycastle.jcajce.provider.BaseKDFSecretKeyFactory;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.GuardedEngineCreator;
import org.bouncycastle.jcajce.provider.KeyIvSizeProvider;
import org.bouncycastle.jcajce.provider.ProvIOException;
import org.bouncycastle.jcajce.spec.GOST28147ParameterSpec;
import org.bouncycastle.jcajce.spec.PBKDF2KeySpec;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

class ProvPKCS12
extends AsymmetricAlgorithmProvider {
    private static final KeyIvSizeProvider sizeProvider = new KeyIvSizeProvider();
    private static final String PREFIX = "org.bouncycastle.jcajce.provider.keystore.pkcs12.";

    ProvPKCS12() {
    }

    static SecretKey getSecretKey(DigestAlgorithm digestAlgorithm, String string, PBEKeySpec pBEKeySpec, PasswordBasedDeriver.KeyType keyType, int n) {
        PasswordBasedDeriver<PBKD.Parameters> passwordBasedDeriver = new PBKD.DeriverFactory().createDeriver(PBKD.PKCS12.using(digestAlgorithm, PasswordConverter.PKCS12, pBEKeySpec.getPassword()).withIterationCount(pBEKeySpec.getIterationCount()).withSalt(pBEKeySpec.getSalt()));
        byte[] byArray = passwordBasedDeriver.deriveKey(keyType, (n + 7) / 8);
        return new SecretKeySpec(byArray, string);
    }

    static byte[] getSecretKey(SecretKey secretKey, PBEParameterSpec pBEParameterSpec, PasswordBasedDeriver.KeyType keyType, int n) {
        PasswordBasedDeriver<PBKD.Parameters> passwordBasedDeriver = new PBKD.DeriverFactory().createDeriver(PBKD.PKCS12.using(FipsSHS.Algorithm.SHA1, secretKey.getEncoded()).withIterationCount(pBEParameterSpec.getIterationCount()).withSalt(pBEParameterSpec.getSalt()));
        return passwordBasedDeriver.deriveKey(keyType, (n + 7) / 8);
    }

    static byte[] getSecretKey(SecretKey secretKey, DigestAlgorithm digestAlgorithm, PBEParameterSpec pBEParameterSpec, PasswordBasedDeriver.KeyType keyType, int n) {
        PasswordBasedDeriver<PBKD.Parameters> passwordBasedDeriver = new PBKD.DeriverFactory().createDeriver(PBKD.PKCS12.using(digestAlgorithm, secretKey.getEncoded()).withIterationCount(pBEParameterSpec.getIterationCount()).withSalt(pBEParameterSpec.getSalt()));
        return passwordBasedDeriver.deriveKey(keyType, (n + 7) / 8);
    }

    static byte[][] getSecretKeyAndIV(SecretKey secretKey, DigestAlgorithm digestAlgorithm, PBEParameterSpec pBEParameterSpec, PasswordBasedDeriver.KeyType keyType, int n, int n2) {
        PasswordBasedDeriver<PBKD.Parameters> passwordBasedDeriver = new PBKD.DeriverFactory().createDeriver(PBKD.PKCS12.using(digestAlgorithm, secretKey.getEncoded()).withIterationCount(pBEParameterSpec.getIterationCount()).withSalt(pBEParameterSpec.getSalt()));
        return passwordBasedDeriver.deriveKeyAndIV(keyType, (n + 7) / 8, (n2 + 7) / 8);
    }

    public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyStore.PKCS12", "org.bouncycastle.jcajce.provider.keystore.pkcs12.PKCS12KeyStoreSpi$BCPKCS12KeyStore3DES", new EngineCreator(){

            public Object createInstance(Object object) {
                return new BCPKCS12KeyStore3DES(bouncyCastleFipsProvider);
            }
        });
        bouncyCastleFipsProvider.addAlias("Alg.Alias.KeyStore.BCPKCS12", "PKCS12");
        bouncyCastleFipsProvider.addAlias("Alg.Alias.KeyStore.PKCS12-3DES-3DES", "PKCS12");
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyStore.PKCS12-DEF", "org.bouncycastle.jcajce.provider.keystore.pkcs12.PKCS12KeyStoreSpi$DefPKCS12KeyStore3DES", new EngineCreator(){

            public Object createInstance(Object object) {
                return new DefPKCS12KeyStore3DES(bouncyCastleFipsProvider);
            }
        });
        bouncyCastleFipsProvider.addAlias("Alg.Alias.KeyStore.PKCS12-DEF-3DES-3DES", "PKCS12-DEF");
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyStore.PKCS12-3DES-40RC2", "org.bouncycastle.jcajce.provider.keystore.pkcs12.PKCS12KeyStoreSpi$BCPKCS12KeyStore", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new BCPKCS12KeyStore3DES40BitRC2(bouncyCastleFipsProvider);
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyStore.PKCS12-DEF-3DES-40RC2", "org.bouncycastle.jcajce.provider.keystore.pkcs12.PKCS12KeyStoreSpi$DefPKCS12KeyStore", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new DefPKCS12KeyStore3DES40BitRC2(bouncyCastleFipsProvider);
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameters.PBKDF-PKCS12", "org.bouncycastle.jcajce.provider.keystore.pkcs12.PKCS12AlgParams", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new AlgParams();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameters.PBKDF-PKCS12WITHSHA256", "org.bouncycastle.jcajce.provider.keystore.pkcs12.PKCS12SHA256AlgParams", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new AlgParams();
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecretKeyFactory.PBKDF-PKCS12", "org.bouncycastle.jcajce.provider.keystore.pkcs12.PKCS12SecKeyFact", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new GeneralKeyFactory("PBKDF-PKCS12withSHA1", FipsSHS.Algorithm.SHA1, PasswordBasedDeriver.KeyType.CIPHER);
            }
        }));
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecretKeyFactory.PBKDF-PKCS12WITHSHA256", "org.bouncycastle.jcajce.provider.keystore.pkcs12.PKCS12SHA256SecKeyFact", new GuardedEngineCreator(new EngineCreator(){

            public Object createInstance(Object object) {
                return new GeneralKeyFactory("PBKDF-PKCS12withSHA256", FipsSHS.Algorithm.SHA256, PasswordBasedDeriver.KeyType.CIPHER);
            }
        }));
    }

    static class AlgParams
    extends BaseAlgorithmParameters {
        PKCS12PBEParams params;

        AlgParams() {
        }

        protected byte[] localGetEncoded() throws IOException {
            return this.params.getEncoded("DER");
        }

        protected AlgorithmParameterSpec localEngineGetParameterSpec(Class clazz) throws InvalidParameterSpecException {
            if (clazz == PBEParameterSpec.class || clazz == AlgorithmParameterSpec.class) {
                return new PBEParameterSpec(this.params.getIV(), this.params.getIterations().intValue());
            }
            throw new InvalidParameterSpecException("AlgorithmParameterSpec not recognized: " + clazz.getName());
        }

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
            if (!(algorithmParameterSpec instanceof PBEParameterSpec)) {
                throw new InvalidParameterSpecException("PBEParameterSpec required to initialise a PBKDF-PKCS12 parameters algorithm parameters object");
            }
            PBEParameterSpec pBEParameterSpec = (PBEParameterSpec)algorithmParameterSpec;
            this.params = new PKCS12PBEParams(pBEParameterSpec.getSalt(), pBEParameterSpec.getIterationCount());
        }

        protected void localInit(byte[] byArray) throws IOException {
            this.params = PKCS12PBEParams.getInstance(byArray);
        }

        protected String engineToString() {
            return "PBKDF-PKCS12 Parameters";
        }
    }

    private static class BCPKCS12KeyStore3DES
    extends PKCS12KeyStoreSpi {
        public BCPKCS12KeyStore3DES(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            super(bouncyCastleFipsProvider, bouncyCastleFipsProvider, pbeWithSHAAnd3_KeyTripleDES_CBC, pbeWithSHAAnd3_KeyTripleDES_CBC);
        }
    }

    private static class BCPKCS12KeyStore3DES40BitRC2
    extends PKCS12KeyStoreSpi {
        public BCPKCS12KeyStore3DES40BitRC2(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            super(bouncyCastleFipsProvider, bouncyCastleFipsProvider, pbeWithSHAAnd3_KeyTripleDES_CBC, pbeWithSHAAnd40BitRC2_CBC);
        }
    }

    private static class DefPKCS12KeyStore3DES
    extends PKCS12KeyStoreSpi {
        public DefPKCS12KeyStore3DES(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            super(bouncyCastleFipsProvider, null, pbeWithSHAAnd3_KeyTripleDES_CBC, pbeWithSHAAnd3_KeyTripleDES_CBC);
        }
    }

    private static class DefPKCS12KeyStore3DES40BitRC2
    extends PKCS12KeyStoreSpi {
        public DefPKCS12KeyStore3DES40BitRC2(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            super(bouncyCastleFipsProvider, null, pbeWithSHAAnd3_KeyTripleDES_CBC, pbeWithSHAAnd40BitRC2_CBC);
        }
    }

    static class GeneralKeyFactory
    extends BaseKDFSecretKeyFactory {
        private final String algName;
        private final FipsDigestAlgorithm prf;
        private final PasswordBasedDeriver.KeyType keyType;

        protected GeneralKeyFactory(String string, FipsDigestAlgorithm fipsDigestAlgorithm, PasswordBasedDeriver.KeyType keyType) {
            this.algName = string;
            this.prf = fipsDigestAlgorithm;
            this.keyType = keyType;
        }

        protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof PBEKeySpec) {
                PBEKeySpec pBEKeySpec = (PBEKeySpec)keySpec;
                if (pBEKeySpec.getSalt() == null) {
                    throw new InvalidKeySpecException("Missing required salt");
                }
                return ProvPKCS12.getSecretKey(this.prf, this.algName, pBEKeySpec, this.keyType, pBEKeySpec.getKeyLength());
            }
            throw new InvalidKeySpecException("Invalid KeySpec: " + keySpec.getClass().getName());
        }
    }

    static class KeyFactory
    extends BaseKDFSecretKeyFactory {
        private final String algName;
        private final int keySizeInBits;
        private final PasswordBasedDeriver.KeyType keyType;
        private final DigestAlgorithm prf;

        protected KeyFactory(String string, DigestAlgorithm digestAlgorithm, PasswordBasedDeriver.KeyType keyType, int n) {
            this.algName = string;
            this.prf = digestAlgorithm;
            this.keyType = keyType;
            this.keySizeInBits = n;
        }

        protected KeyFactory(String string, PasswordBasedDeriver.KeyType keyType, int n) {
            this(string, FipsSHS.Algorithm.SHA1, keyType, n);
        }

        protected SecretKey engineGenerateSecret(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof PBEKeySpec) {
                PBEKeySpec pBEKeySpec = (PBEKeySpec)keySpec;
                if (pBEKeySpec.getSalt() == null) {
                    throw new InvalidKeySpecException("Missing required salt");
                }
                return ProvPKCS12.getSecretKey(this.prf, this.algName, pBEKeySpec, this.keyType, this.keySizeInBits);
            }
            throw new InvalidKeySpecException("Invalid KeySpec: " + keySpec.getClass().getName());
        }
    }

    private static class PKCS12KeyStoreSpi
    extends KeyStoreSpi
    implements PKCSObjectIdentifiers,
    X509ObjectIdentifiers {
        private static final int SALT_SIZE = 20;
        private static final int MIN_ITERATIONS = 1024;
        private IgnoresCaseHashtable privateKeyCache = new IgnoresCaseHashtable();
        private IgnoresCaseHashtable keys = new IgnoresCaseHashtable();
        private Hashtable localIds = new Hashtable();
        private IgnoresCaseHashtable certs = new IgnoresCaseHashtable();
        private Hashtable chainCerts = new Hashtable();
        private Hashtable keyCerts = new Hashtable();
        private boolean wrongPKCS12Zero = false;
        static final int NULL = 0;
        static final int CERTIFICATE = 1;
        static final int KEY = 2;
        static final int SECRET = 3;
        static final int SEALED = 4;
        static final int KEY_PRIVATE = 0;
        static final int KEY_PUBLIC = 1;
        static final int KEY_SECRET = 2;
        protected final SecureRandom random;
        private CertificateFactory certFact;
        private Provider fipsProvider;
        private ASN1ObjectIdentifier keyAlgorithm;
        private ASN1ObjectIdentifier certAlgorithm;

        public PKCS12KeyStoreSpi(BouncyCastleFipsProvider bouncyCastleFipsProvider, Provider provider, ASN1ObjectIdentifier aSN1ObjectIdentifier, ASN1ObjectIdentifier aSN1ObjectIdentifier2) {
            this.fipsProvider = bouncyCastleFipsProvider;
            this.keyAlgorithm = aSN1ObjectIdentifier;
            this.certAlgorithm = aSN1ObjectIdentifier2;
            this.random = bouncyCastleFipsProvider.getDefaultSecureRandom();
            try {
                this.certFact = provider != null ? CertificateFactory.getInstance("X.509", provider) : CertificateFactory.getInstance("X.509");
            }
            catch (Exception exception) {
                throw new IllegalArgumentException("can't create cert factory - " + exception.toString());
            }
        }

        private SubjectKeyIdentifier createSubjectKeyId(PublicKey publicKey) throws IOException {
            SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(publicKey.getEncoded()));
            return new SubjectKeyIdentifier(this.getDigest(subjectPublicKeyInfo));
        }

        private byte[] getDigest(SubjectPublicKeyInfo subjectPublicKeyInfo) {
            FipsOutputDigestCalculator<FipsSHS.Parameters> fipsOutputDigestCalculator = new FipsSHS.OperatorFactory<FipsSHS.Parameters>().createOutputDigestCalculator(FipsSHS.SHA1);
            fipsOutputDigestCalculator.getDigestStream().update(subjectPublicKeyInfo.getPublicKeyData().getBytes());
            return fipsOutputDigestCalculator.getDigest();
        }

        public Enumeration engineAliases() {
            Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
            Enumeration enumeration = this.certs.keys();
            while (enumeration.hasMoreElements()) {
                hashtable.put(enumeration.nextElement(), "cert");
            }
            enumeration = this.keys.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (hashtable.get(string) != null) continue;
                hashtable.put(string, "key");
            }
            return hashtable.keys();
        }

        public boolean engineContainsAlias(String string) {
            return this.certs.get(string) != null || this.keys.get(string) != null;
        }

        public void engineDeleteEntry(String string) throws KeyStoreException {
            Key key = (Key)this.keys.remove(string);
            this.privateKeyCache.remove(string);
            Certificate certificate = (Certificate)this.certs.remove(string);
            if (certificate != null) {
                this.removeChainCert(certificate);
            }
            if (key != null) {
                String string2 = (String)this.localIds.remove(string);
                if (string2 != null) {
                    certificate = (Certificate)this.keyCerts.remove(string2);
                }
                if (certificate != null) {
                    this.removeChainCert(certificate);
                }
            }
        }

        private void removeChainCert(Certificate certificate) throws KeyStoreException {
            try {
                this.chainCerts.remove(new CertId(certificate.getPublicKey()));
            }
            catch (IOException iOException) {
                throw new KeyStoreException("Exception: " + iOException.getMessage(), iOException);
            }
        }

        public Certificate engineGetCertificate(String string) {
            if (string == null) {
                throw new IllegalArgumentException("null alias passed to getCertificate.");
            }
            Certificate certificate = (Certificate)this.certs.get(string);
            if (certificate == null) {
                String string2 = (String)this.localIds.get(string);
                certificate = string2 != null ? (Certificate)this.keyCerts.get(string2) : (Certificate)this.keyCerts.get(string);
            }
            return certificate;
        }

        public String engineGetCertificateAlias(Certificate certificate) {
            String string;
            Certificate certificate2;
            Enumeration enumeration = this.certs.elements();
            Enumeration enumeration2 = this.certs.keys();
            while (enumeration.hasMoreElements()) {
                certificate2 = (Certificate)enumeration.nextElement();
                string = (String)enumeration2.nextElement();
                if (!certificate2.equals(certificate)) continue;
                return string;
            }
            enumeration = this.keyCerts.elements();
            enumeration2 = this.keyCerts.keys();
            while (enumeration.hasMoreElements()) {
                certificate2 = (Certificate)enumeration.nextElement();
                string = (String)enumeration2.nextElement();
                if (!certificate2.equals(certificate)) continue;
                return string;
            }
            return null;
        }

        public Certificate[] engineGetCertificateChain(String string) {
            if (string == null) {
                throw new IllegalArgumentException("null alias passed to getCertificateChain.");
            }
            if (!this.engineIsKeyEntry(string)) {
                return null;
            }
            Certificate certificate = this.engineGetCertificate(string);
            if (certificate != null) {
                Certificate[] certificateArray;
                Vector<Certificate> vector = new Vector<Certificate>();
                while (certificate != null) {
                    Object object;
                    Object object2;
                    certificateArray = (Certificate[])certificate;
                    Certificate certificate2 = null;
                    byte[] byArray = certificateArray.getExtensionValue(Extension.authorityKeyIdentifier.getId());
                    if (byArray != null && ((AuthorityKeyIdentifier)(object2 = AuthorityKeyIdentifier.getInstance(object = ASN1OctetString.getInstance(byArray).getOctets()))).getKeyIdentifier() != null) {
                        certificate2 = (Certificate)this.chainCerts.get(new CertId(((AuthorityKeyIdentifier)object2).getKeyIdentifier()));
                    }
                    if (certificate2 == null && !(object = (Object)certificateArray.getIssuerDN()).equals(object2 = certificateArray.getSubjectDN())) {
                        Enumeration enumeration = this.chainCerts.keys();
                        while (enumeration.hasMoreElements()) {
                            X509Certificate x509Certificate = (X509Certificate)this.chainCerts.get(enumeration.nextElement());
                            Principal principal = x509Certificate.getSubjectDN();
                            if (!principal.equals(object)) continue;
                            try {
                                certificateArray.verify(x509Certificate.getPublicKey());
                                certificate2 = x509Certificate;
                                break;
                            }
                            catch (Exception exception) {
                            }
                        }
                    }
                    if (vector.contains(certificate)) {
                        certificate = null;
                        continue;
                    }
                    vector.addElement(certificate);
                    if (certificate2 != certificate) {
                        certificate = certificate2;
                        continue;
                    }
                    certificate = null;
                }
                certificateArray = new Certificate[vector.size()];
                for (int i = 0; i != certificateArray.length; ++i) {
                    certificateArray[i] = (Certificate)vector.elementAt(i);
                }
                return certificateArray;
            }
            return null;
        }

        public Date engineGetCreationDate(String string) {
            if (string == null) {
                throw new NullPointerException("alias == null");
            }
            if (this.keys.get(string) == null && this.certs.get(string) == null) {
                return null;
            }
            return new Date();
        }

        public Key engineGetKey(String string, char[] cArray) throws NoSuchAlgorithmException, UnrecoverableKeyException {
            if (string == null) {
                throw new IllegalArgumentException("null alias passed to getKey.");
            }
            Key key = (Key)this.keys.get(string);
            try {
                if (key instanceof PrivateKey) {
                    if (this.privateKeyCache.get(string) != null) {
                        return key;
                    }
                    Certificate certificate = this.engineGetCertificate(string);
                    if (certificate != null) {
                        new ConsistentKeyPair(certificate.getPublicKey(), (PrivateKey)key);
                        this.privateKeyCache.put(string, key);
                    }
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new UnrecoverableKeyException(illegalArgumentException.getMessage());
            }
            return key;
        }

        public boolean engineIsCertificateEntry(String string) {
            return this.certs.get(string) != null && this.keys.get(string) == null;
        }

        public boolean engineIsKeyEntry(String string) {
            return this.keys.get(string) != null;
        }

        public void engineSetCertificateEntry(String string, Certificate certificate) throws KeyStoreException {
            if (this.keys.get(string) != null) {
                throw new KeyStoreException("There is a key entry with the name " + string + ".");
            }
            this.certs.put(string, certificate);
            this.putChainCert(certificate);
        }

        public void engineSetKeyEntry(String string, byte[] byArray, Certificate[] certificateArray) throws KeyStoreException {
            throw new KeyStoreException("operation not supported");
        }

        public void engineSetKeyEntry(String string, Key key, char[] cArray, Certificate[] certificateArray) throws KeyStoreException {
            if (!(key instanceof PrivateKey)) {
                throw new KeyStoreException("PKCS12 does not support non-PrivateKeys");
            }
            if (certificateArray == null) {
                throw new KeyStoreException("no certificate chain for private key");
            }
            if (this.keys.get(string) != null) {
                this.engineDeleteEntry(string);
            }
            try {
                new ConsistentKeyPair(certificateArray[0].getPublicKey(), (PrivateKey)key);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                throw new KeyStoreException(illegalArgumentException.getMessage());
            }
            this.keys.put(string, key);
            this.privateKeyCache.put(string, key);
            this.certs.put(string, certificateArray[0]);
            for (int i = 0; i != certificateArray.length; ++i) {
                this.putChainCert(certificateArray[i]);
            }
        }

        private void putChainCert(Certificate certificate) throws KeyStoreException {
            try {
                this.chainCerts.put(new CertId(certificate.getPublicKey()), certificate);
            }
            catch (IOException iOException) {
                throw new KeyStoreException("Exception: " + iOException.getMessage(), iOException);
            }
        }

        public int engineSize() {
            Hashtable<Object, String> hashtable = new Hashtable<Object, String>();
            Enumeration enumeration = this.certs.keys();
            while (enumeration.hasMoreElements()) {
                hashtable.put(enumeration.nextElement(), "cert");
            }
            enumeration = this.keys.keys();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (hashtable.get(string) != null) continue;
                hashtable.put(string, "key");
            }
            return hashtable.size();
        }

        public void engineSetEntry(String string, KeyStore.Entry entry, KeyStore.ProtectionParameter protectionParameter) throws KeyStoreException {
            if (protectionParameter != null) {
                throw new KeyStoreException("PKCS12 can only accept null as a protection parameter for individual entries.");
            }
            if (entry instanceof KeyStore.PrivateKeyEntry) {
                super.engineSetEntry(string, entry, new KeyStore.PasswordProtection(new char[0]));
            } else {
                if (entry instanceof KeyStore.SecretKeyEntry) {
                    throw new KeyStoreException("PKCS12 does not support storage of symmetric keys.");
                }
                super.engineSetEntry(string, entry, null);
            }
        }

        protected PrivateKey unwrapKey(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, char[] cArray) throws IOException {
            ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
            try {
                Cipher cipher;
                if (aSN1ObjectIdentifier.on(PKCSObjectIdentifiers.pkcs_12PbeIds)) {
                    cipher = this.createPKCS12Cipher(4, cArray, algorithmIdentifier);
                } else if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.id_PBES2)) {
                    cipher = this.createPBES2Cipher(4, cArray, algorithmIdentifier);
                } else {
                    throw new IOException("exception unwrapping private key - cannot recognize: " + aSN1ObjectIdentifier);
                }
                return (PrivateKey)cipher.unwrap(byArray, "", 2);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new ProvIOException("exception unwrapping private key - " + exception.toString(), exception);
            }
        }

        protected byte[] wrapKey(AlgorithmIdentifier algorithmIdentifier, Key key, char[] cArray) throws IOException {
            ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
            try {
                Cipher cipher;
                if (aSN1ObjectIdentifier.on(PKCSObjectIdentifiers.pkcs_12PbeIds)) {
                    cipher = this.createPKCS12Cipher(3, cArray, algorithmIdentifier);
                } else if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.id_PBES2)) {
                    cipher = this.createPBES2Cipher(3, cArray, algorithmIdentifier);
                } else {
                    throw new IOException("exception unwrapping private key - cannot recognize: " + aSN1ObjectIdentifier);
                }
                return cipher.wrap(key);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new ProvIOException("exception unwrapping private key - " + exception.toString(), exception);
            }
        }

        protected byte[] cryptData(boolean bl, AlgorithmIdentifier algorithmIdentifier, char[] cArray, byte[] byArray) throws IOException {
            ASN1ObjectIdentifier aSN1ObjectIdentifier = algorithmIdentifier.getAlgorithm();
            int n = bl ? 1 : 2;
            try {
                Cipher cipher;
                if (aSN1ObjectIdentifier.on(PKCSObjectIdentifiers.pkcs_12PbeIds)) {
                    cipher = this.createPKCS12Cipher(n, cArray, algorithmIdentifier);
                } else if (aSN1ObjectIdentifier.equals(PKCSObjectIdentifiers.id_PBES2)) {
                    cipher = this.createPBES2Cipher(n, cArray, algorithmIdentifier);
                } else {
                    throw new IOException("unknown PBE algorithm: " + aSN1ObjectIdentifier);
                }
                return cipher.doFinal(byArray);
            }
            catch (IOException iOException) {
                throw iOException;
            }
            catch (Exception exception) {
                throw new ProvIOException("exception decrypting data - " + exception.toString(), exception);
            }
        }

        private Cipher createPKCS12Cipher(int n, char[] cArray, AlgorithmIdentifier algorithmIdentifier) throws NoSuchAlgorithmException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
            PKCS12PBEParams pKCS12PBEParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
            Cipher cipher = Cipher.getInstance(algorithmIdentifier.getAlgorithm().getId(), this.fipsProvider);
            cipher.init(n, new PKCS12KeyWithParameters(cArray, this.wrongPKCS12Zero, pKCS12PBEParams.getIV(), pKCS12PBEParams.getIterations().intValue()));
            return cipher;
        }

        private Cipher createPBES2Cipher(int n, char[] cArray, AlgorithmIdentifier algorithmIdentifier) throws NoSuchAlgorithmException, InvalidKeySpecException, NoSuchPaddingException, InvalidKeyException, InvalidAlgorithmParameterException {
            PBES2Parameters pBES2Parameters = PBES2Parameters.getInstance(algorithmIdentifier.getParameters());
            PBKDF2Params pBKDF2Params = PBKDF2Params.getInstance(pBES2Parameters.getKeyDerivationFunc().getParameters());
            AlgorithmIdentifier algorithmIdentifier2 = AlgorithmIdentifier.getInstance(pBES2Parameters.getEncryptionScheme());
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(pBES2Parameters.getKeyDerivationFunc().getAlgorithm().getId(), this.fipsProvider);
            SecretKey secretKey = pBKDF2Params.isDefaultPrf() ? secretKeyFactory.generateSecret(new PBEKeySpec(cArray, pBKDF2Params.getSalt(), pBKDF2Params.getIterationCount().intValue(), sizeProvider.getKeySize(algorithmIdentifier2) * 8)) : secretKeyFactory.generateSecret(new PBKDF2KeySpec(cArray, pBKDF2Params.getSalt(), pBKDF2Params.getIterationCount().intValue(), sizeProvider.getKeySize(algorithmIdentifier2) * 8, pBKDF2Params.getPrf()));
            Cipher cipher = Cipher.getInstance(algorithmIdentifier2.getAlgorithm().getId());
            ASN1Encodable aSN1Encodable = algorithmIdentifier2.getParameters();
            if (aSN1Encodable instanceof ASN1OctetString) {
                cipher.init(n, (Key)secretKey, new IvParameterSpec(ASN1OctetString.getInstance(aSN1Encodable).getOctets()));
            } else {
                GOST28147Parameters gOST28147Parameters = GOST28147Parameters.getInstance(aSN1Encodable);
                cipher.init(n, (Key)secretKey, new GOST28147ParameterSpec(gOST28147Parameters.getEncryptionParamSet(), gOST28147Parameters.getIV()));
            }
            return cipher;
        }

        public void engineLoad(InputStream inputStream, char[] cArray) throws IOException {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            ASN1Object aSN1Object;
            this.privateKeyCache.clear();
            if (inputStream == null) {
                return;
            }
            if (cArray == null) {
                throw new NullPointerException("No password supplied for PKCS#12 KeyStore.");
            }
            BufferedInputStream bufferedInputStream = new BufferedInputStream(inputStream);
            bufferedInputStream.mark(10);
            int n = bufferedInputStream.read();
            if (n != 48) {
                throw new IOException("stream does not represent a PKCS12 key store");
            }
            bufferedInputStream.reset();
            ASN1InputStream aSN1InputStream = new ASN1InputStream(bufferedInputStream);
            ASN1Sequence aSN1Sequence = (ASN1Sequence)aSN1InputStream.readObject();
            Pfx pfx = Pfx.getInstance(aSN1Sequence);
            ContentInfo contentInfo = pfx.getAuthSafe();
            Vector<Object> vector = new Vector<Object>();
            boolean bl = false;
            if (pfx.getMacData() != null) {
                aSN1Object = pfx.getMacData();
                object6 = ((MacData)aSN1Object).getMac();
                AlgorithmIdentifier algorithmIdentifier = ((DigestInfo)object6).getAlgorithmId();
                object5 = ((MacData)aSN1Object).getSalt();
                int n2 = ((MacData)aSN1Object).getIterationCount().intValue();
                byte[] byArray = ((ASN1OctetString)contentInfo.getContent()).getOctets();
                try {
                    object4 = this.calculatePbeMac(algorithmIdentifier, (byte[])object5, n2, cArray, byArray);
                    object3 = ((DigestInfo)object6).getDigest();
                    if (!Arrays.constantTimeAreEqual(object4, (byte[])object3)) {
                        if (cArray.length > 0) {
                            throw new IOException("PKCS12 key store mac invalid - wrong password or corrupted file.");
                        }
                        object4 = this.calculatePbeMacWrongZero(algorithmIdentifier, (byte[])object5, n2, byArray);
                        if (!Arrays.constantTimeAreEqual(object4, (byte[])object3)) {
                            throw new IOException("PKCS12 key store mac invalid - wrong password or corrupted file.");
                        }
                        this.wrongPKCS12Zero = true;
                    }
                }
                catch (IOException iOException) {
                    throw iOException;
                }
                catch (Exception exception) {
                    throw new ProvIOException("error constructing MAC: " + exception.toString(), exception);
                }
            }
            this.keys = new IgnoresCaseHashtable();
            this.localIds = new Hashtable();
            if (contentInfo.getContentType().equals(data)) {
                aSN1InputStream = new ASN1InputStream(((ASN1OctetString)contentInfo.getContent()).getOctets());
                aSN1Object = AuthenticatedSafe.getInstance(aSN1InputStream.readObject());
                object6 = ((AuthenticatedSafe)aSN1Object).getContentInfo();
                for (int i = 0; i != ((ContentInfo[])object6).length; ++i) {
                    ASN1Primitive aSN1Primitive;
                    ASN1Primitive aSN1Primitive2;
                    Object object7;
                    Object object8;
                    Object object9;
                    Object object10;
                    Object object11;
                    if (object6[i].getContentType().equals(data)) {
                        object5 = new ASN1InputStream(((ASN1OctetString)((ContentInfo)object6[i]).getContent()).getOctets());
                        object11 = (ASN1Sequence)((ASN1InputStream)object5).readObject();
                        for (int j = 0; j != ((ASN1Sequence)object11).size(); ++j) {
                            object4 = SafeBag.getInstance(((ASN1Sequence)object11).getObjectAt(j));
                            if (object4.getBagId().equals(pkcs8ShroudedKeyBag)) {
                                object3 = EncryptedPrivateKeyInfo.getInstance(object4.getBagValue());
                                object2 = this.unwrapKey(((EncryptedPrivateKeyInfo)object3).getEncryptionAlgorithm(), ((EncryptedPrivateKeyInfo)object3).getEncryptedData(), cArray);
                                object = null;
                                object10 = null;
                                if (object4.getBagAttributes() != null) {
                                    object9 = object4.getBagAttributes().getObjects();
                                    while (object9.hasMoreElements()) {
                                        object8 = (ASN1Sequence)object9.nextElement();
                                        object7 = (ASN1ObjectIdentifier)((ASN1Sequence)object8).getObjectAt(0);
                                        aSN1Primitive2 = (ASN1Set)((ASN1Sequence)object8).getObjectAt(1);
                                        aSN1Primitive = null;
                                        if (((ASN1Set)aSN1Primitive2).size() <= 0) continue;
                                        aSN1Primitive = (ASN1Primitive)((ASN1Set)aSN1Primitive2).getObjectAt(0);
                                        if (((ASN1Primitive)object7).equals(pkcs_9_at_friendlyName)) {
                                            if (object != null && !((String)object).equals(DERBMPString.getInstance(aSN1Primitive).getString())) {
                                                throw new IOException("attempt to add existing attribute with different value");
                                            }
                                            object = DERBMPString.getInstance(aSN1Primitive).getString();
                                            this.keys.put((String)object, object2);
                                            continue;
                                        }
                                        if (!((ASN1Primitive)object7).equals(pkcs_9_at_localKeyId)) continue;
                                        if (object10 != null && !((ASN1Primitive)object10).equals(aSN1Primitive)) {
                                            throw new IOException("attempt to add existing attribute with different value");
                                        }
                                        object10 = ASN1OctetString.getInstance(aSN1Primitive);
                                    }
                                }
                                if (object10 != null) {
                                    object9 = Strings.fromByteArray(Hex.encode(((ASN1OctetString)object10).getOctets()));
                                    if (object == null) {
                                        this.keys.put((String)object9, object2);
                                        continue;
                                    }
                                    this.localIds.put(object, object9);
                                    continue;
                                }
                                bl = true;
                                this.keys.put("unmarked", object2);
                                continue;
                            }
                            if (object4.getBagId().equals(certBag)) {
                                vector.addElement(object4);
                                continue;
                            }
                            System.out.println("extra in data " + object4.getBagId());
                            System.out.println(ASN1Dump.dumpAsString(object4));
                        }
                        continue;
                    }
                    if (((ContentInfo)object6[i]).getContentType().equals(encryptedData)) {
                        object5 = EncryptedData.getInstance(((ContentInfo)object6[i]).getContent());
                        object11 = this.cryptData(false, ((EncryptedData)object5).getEncryptionAlgorithm(), cArray, ((EncryptedData)object5).getContent().getOctets());
                        ASN1Sequence aSN1Sequence2 = (ASN1Sequence)ASN1Primitive.fromByteArray((byte[])object11);
                        for (int j = 0; j != aSN1Sequence2.size(); ++j) {
                            ASN1Primitive aSN1Primitive3;
                            object3 = SafeBag.getInstance(aSN1Sequence2.getObjectAt(j));
                            if (((SafeBag)object3).getBagId().equals(certBag)) {
                                vector.addElement(object3);
                                continue;
                            }
                            if (((SafeBag)object3).getBagId().equals(pkcs8ShroudedKeyBag)) {
                                object2 = EncryptedPrivateKeyInfo.getInstance(((SafeBag)object3).getBagValue());
                                object = this.unwrapKey(((EncryptedPrivateKeyInfo)object2).getEncryptionAlgorithm(), ((EncryptedPrivateKeyInfo)object2).getEncryptedData(), cArray);
                                object10 = null;
                                object9 = null;
                                object8 = ((SafeBag)object3).getBagAttributes().getObjects();
                                while (object8.hasMoreElements()) {
                                    object7 = (ASN1Sequence)object8.nextElement();
                                    aSN1Primitive2 = (ASN1ObjectIdentifier)((ASN1Sequence)object7).getObjectAt(0);
                                    aSN1Primitive = (ASN1Set)((ASN1Sequence)object7).getObjectAt(1);
                                    aSN1Primitive3 = null;
                                    if (((ASN1Set)aSN1Primitive).size() <= 0) continue;
                                    aSN1Primitive3 = (ASN1Primitive)((ASN1Set)aSN1Primitive).getObjectAt(0);
                                    if (aSN1Primitive2.equals(pkcs_9_at_friendlyName)) {
                                        if (object10 != null && !((String)object10).equals(DERBMPString.getInstance(aSN1Primitive3).getString())) {
                                            throw new IOException("attempt to add existing attribute with different value");
                                        }
                                        object10 = DERBMPString.getInstance(aSN1Primitive3).getString();
                                        this.keys.put((String)object10, object);
                                        continue;
                                    }
                                    if (!aSN1Primitive2.equals(pkcs_9_at_localKeyId)) continue;
                                    if (object9 != null && !((ASN1Primitive)object9).equals(aSN1Primitive3)) {
                                        throw new IOException("attempt to add existing attribute with different value");
                                    }
                                    object9 = ASN1OctetString.getInstance(aSN1Primitive3);
                                }
                                object7 = Strings.fromByteArray(Hex.encode(((ASN1OctetString)object9).getOctets()));
                                if (object10 == null) {
                                    this.keys.put((String)object7, object);
                                    continue;
                                }
                                this.localIds.put(object10, object7);
                                continue;
                            }
                            if (((SafeBag)object3).getBagId().equals(keyBag)) {
                                object2 = PrivateKeyInfo.getInstance(((SafeBag)object3).getBagValue());
                                object = BouncyCastleFipsProvider.getPrivateKey((PrivateKeyInfo)object2);
                                object10 = null;
                                object9 = null;
                                object8 = ((SafeBag)object3).getBagAttributes().getObjects();
                                while (object8.hasMoreElements()) {
                                    object7 = (ASN1Sequence)object8.nextElement();
                                    aSN1Primitive2 = (ASN1ObjectIdentifier)((ASN1Sequence)object7).getObjectAt(0);
                                    aSN1Primitive = (ASN1Set)((ASN1Sequence)object7).getObjectAt(1);
                                    aSN1Primitive3 = null;
                                    if (((ASN1Set)aSN1Primitive).size() <= 0) continue;
                                    aSN1Primitive3 = (ASN1Primitive)((ASN1Set)aSN1Primitive).getObjectAt(0);
                                    if (aSN1Primitive2.equals(pkcs_9_at_friendlyName)) {
                                        if (object10 != null && !((String)object10).equals(DERBMPString.getInstance(aSN1Primitive3).getString())) {
                                            throw new IOException("attempt to add existing attribute with different value");
                                        }
                                        object10 = DERBMPString.getInstance(aSN1Primitive3).getString();
                                        this.keys.put((String)object10, object);
                                        continue;
                                    }
                                    if (!aSN1Primitive2.equals(pkcs_9_at_localKeyId)) continue;
                                    if (object9 != null && !((ASN1Primitive)object9).equals(aSN1Primitive3)) {
                                        throw new IOException("attempt to add existing attribute with different value");
                                    }
                                    object9 = ASN1OctetString.getInstance(aSN1Primitive3);
                                }
                                object7 = Strings.fromByteArray(Hex.encode(((ASN1OctetString)object9).getOctets()));
                                if (object10 == null) {
                                    this.keys.put((String)object7, object);
                                    continue;
                                }
                                this.localIds.put(object10, object7);
                                continue;
                            }
                            System.out.println("extra in encryptedData " + ((SafeBag)object3).getBagId());
                            System.out.println(ASN1Dump.dumpAsString(object3));
                        }
                        continue;
                    }
                    System.out.println("extra " + ((ContentInfo)object6[i]).getContentType().getId());
                    System.out.println("extra " + ASN1Dump.dumpAsString(((ContentInfo)object6[i]).getContent()));
                }
            }
            this.certs = new IgnoresCaseHashtable();
            this.chainCerts = new Hashtable();
            this.keyCerts = new Hashtable();
            for (int i = 0; i != vector.size(); ++i) {
                Object object12;
                object6 = (SafeBag)vector.elementAt(i);
                CertBag certBag = CertBag.getInstance(((SafeBag)object6).getBagValue());
                if (!certBag.getCertId().equals(x509Certificate)) {
                    throw new IOException("Unsupported certificate type: " + certBag.getCertId());
                }
                try {
                    object12 = new ByteArrayInputStream(((ASN1OctetString)certBag.getCertValue()).getOctets());
                    object5 = this.certFact.generateCertificate((InputStream)object12);
                }
                catch (Exception exception) {
                    throw new ProvIOException(exception.toString(), exception);
                }
                object12 = null;
                String string = null;
                if (((SafeBag)object6).getBagAttributes() != null) {
                    object4 = ((SafeBag)object6).getBagAttributes().getObjects();
                    while (object4.hasMoreElements()) {
                        object3 = (ASN1Sequence)object4.nextElement();
                        object2 = (ASN1ObjectIdentifier)((ASN1Sequence)object3).getObjectAt(0);
                        object = (ASN1Primitive)((ASN1Set)((ASN1Sequence)object3).getObjectAt(1)).getObjectAt(0);
                        if (((ASN1Primitive)object2).equals(pkcs_9_at_friendlyName)) {
                            if (string != null && !string.equals(DERBMPString.getInstance(object).getString())) {
                                throw new IOException("attempt to add existing attribute with different value");
                            }
                            string = DERBMPString.getInstance(object).getString();
                            continue;
                        }
                        if (!((ASN1Primitive)object2).equals(pkcs_9_at_localKeyId)) continue;
                        if (object12 != null && !((ASN1Primitive)object12).equals(object)) {
                            throw new IOException("attempt to add existing attribute with different value");
                        }
                        object12 = ASN1OctetString.getInstance(object);
                    }
                }
                this.chainCerts.put(new CertId(((Certificate)object5).getPublicKey()), object5);
                if (bl) {
                    if (!this.keyCerts.isEmpty()) continue;
                    object4 = Strings.fromByteArray(Hex.encode(this.createSubjectKeyId(((Certificate)object5).getPublicKey()).getKeyIdentifier()));
                    this.keyCerts.put(object4, object5);
                    this.keys.put((String)object4, this.keys.remove("unmarked"));
                    continue;
                }
                if (object12 != null) {
                    object4 = Strings.fromByteArray(Hex.encode(((ASN1OctetString)object12).getOctets()));
                    this.keyCerts.put(object4, object5);
                }
                if (string == null) continue;
                this.certs.put(string, object5);
            }
        }

        public void engineStore(KeyStore.LoadStoreParameter loadStoreParameter) throws IOException, NoSuchAlgorithmException, CertificateException {
            char[] cArray;
            if (loadStoreParameter == null) {
                throw new IllegalArgumentException("'param' arg cannot be null");
            }
            if (!(loadStoreParameter instanceof PKCS12StoreParameter)) {
                throw new IllegalArgumentException("No support for 'param' of type " + loadStoreParameter.getClass().getName());
            }
            PKCS12StoreParameter pKCS12StoreParameter = (PKCS12StoreParameter)loadStoreParameter;
            KeyStore.ProtectionParameter protectionParameter = loadStoreParameter.getProtectionParameter();
            if (protectionParameter == null) {
                cArray = null;
            } else if (protectionParameter instanceof KeyStore.PasswordProtection) {
                cArray = ((KeyStore.PasswordProtection)protectionParameter).getPassword();
            } else {
                throw new IllegalArgumentException("No support for protection parameter of type " + protectionParameter.getClass().getName());
            }
            this.doStore(pKCS12StoreParameter.getOutputStream(), cArray, pKCS12StoreParameter.isForDEREncoding());
        }

        public void engineStore(OutputStream outputStream, char[] cArray) throws IOException {
            this.doStore(outputStream, cArray, false);
        }

        private void doStore(OutputStream outputStream, char[] cArray, boolean bl) throws IOException {
            MacData macData;
            ASN1Object aSN1Object;
            Object object;
            Object object2;
            ContentInfo[] contentInfoArray;
            ASN1Object aSN1Object2;
            Object object3;
            Object object4;
            Enumeration enumeration;
            Object object5;
            Object object6;
            ASN1Object aSN1Object3;
            Object object7;
            Object object8;
            Object object9;
            byte[] byArray;
            if (cArray == null) {
                throw new NullPointerException("No password supplied for PKCS#12 KeyStore.");
            }
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            Enumeration enumeration2 = this.keys.keys();
            while (enumeration2.hasMoreElements()) {
                byArray = new byte[20];
                this.random.nextBytes(byArray);
                object9 = (String)enumeration2.nextElement();
                object8 = (PrivateKey)this.keys.get((String)object9);
                object7 = new PKCS12PBEParams(byArray, 1024);
                aSN1Object3 = new AlgorithmIdentifier(this.keyAlgorithm, (ASN1Encodable)object7);
                object6 = this.wrapKey((AlgorithmIdentifier)aSN1Object3, (Key)object8, cArray);
                object5 = new EncryptedPrivateKeyInfo((AlgorithmIdentifier)aSN1Object3, (byte[])object6);
                enumeration = new ASN1EncodableVector();
                object4 = new ASN1EncodableVector();
                object3 = this.engineGetCertificate((String)object9);
                ((ASN1EncodableVector)object4).add(pkcs_9_at_localKeyId);
                ((ASN1EncodableVector)object4).add(new DERSet(this.createSubjectKeyId(((Certificate)object3).getPublicKey())));
                ((ASN1EncodableVector)((Object)enumeration)).add(new DERSequence((ASN1EncodableVector)object4));
                object4 = new ASN1EncodableVector();
                ((ASN1EncodableVector)object4).add(pkcs_9_at_friendlyName);
                ((ASN1EncodableVector)object4).add(new DERSet(new DERBMPString((String)object9)));
                ((ASN1EncodableVector)((Object)enumeration)).add(new DERSequence((ASN1EncodableVector)object4));
                SafeBag safeBag = new SafeBag(pkcs8ShroudedKeyBag, ((EncryptedPrivateKeyInfo)object5).toASN1Primitive(), new DERSet((ASN1EncodableVector)((Object)enumeration)));
                aSN1EncodableVector.add(safeBag);
            }
            byArray = new DERSequence(aSN1EncodableVector).getEncoded("DER");
            object9 = new BEROctetString(byArray);
            object8 = new byte[20];
            this.random.nextBytes((byte[])object8);
            object7 = new ASN1EncodableVector();
            aSN1Object3 = new PKCS12PBEParams((byte[])object8, 1024);
            object6 = new AlgorithmIdentifier(this.certAlgorithm, ((PKCS12PBEParams)aSN1Object3).toASN1Primitive());
            object5 = new Hashtable();
            enumeration = this.keys.keys();
            while (enumeration.hasMoreElements()) {
                try {
                    object4 = (String)enumeration.nextElement();
                    object3 = this.engineGetCertificate((String)object4);
                    boolean bl2 = false;
                    aSN1Object2 = new CertBag(x509Certificate, new DEROctetString(((Certificate)object3).getEncoded()));
                    contentInfoArray = new ASN1EncodableVector();
                    object2 = new ASN1EncodableVector();
                    ((ASN1EncodableVector)object2).add(pkcs_9_at_localKeyId);
                    ((ASN1EncodableVector)object2).add(new DERSet(this.createSubjectKeyId(((Certificate)object3).getPublicKey())));
                    contentInfoArray.add(new DERSequence((ASN1EncodableVector)object2));
                    object2 = new ASN1EncodableVector();
                    ((ASN1EncodableVector)object2).add(pkcs_9_at_friendlyName);
                    ((ASN1EncodableVector)object2).add(new DERSet(new DERBMPString((String)object4)));
                    contentInfoArray.add(new DERSequence((ASN1EncodableVector)object2));
                    object = new SafeBag(certBag, ((CertBag)aSN1Object2).toASN1Primitive(), new DERSet((ASN1EncodableVector)contentInfoArray));
                    ((ASN1EncodableVector)object7).add((ASN1Encodable)object);
                    ((Hashtable)object5).put(object3, object3);
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    throw new IOException("Error encoding certificate: " + certificateEncodingException.toString());
                }
            }
            enumeration = this.certs.keys();
            while (enumeration.hasMoreElements()) {
                try {
                    object4 = (String)enumeration.nextElement();
                    object3 = (Certificate)this.certs.get((String)object4);
                    boolean bl3 = false;
                    if (this.keys.get((String)object4) != null) continue;
                    aSN1Object2 = new CertBag(x509Certificate, new DEROctetString(((Certificate)object3).getEncoded()));
                    contentInfoArray = new ASN1EncodableVector();
                    object2 = new ASN1EncodableVector();
                    ((ASN1EncodableVector)object2).add(pkcs_9_at_friendlyName);
                    ((ASN1EncodableVector)object2).add(new DERSet(new DERBMPString((String)object4)));
                    contentInfoArray.add(new DERSequence((ASN1EncodableVector)object2));
                    object = new SafeBag(certBag, ((CertBag)aSN1Object2).toASN1Primitive(), new DERSet((ASN1EncodableVector)contentInfoArray));
                    ((ASN1EncodableVector)object7).add((ASN1Encodable)object);
                    ((Hashtable)object5).put(object3, object3);
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    throw new IOException("Error encoding certificate: " + certificateEncodingException.toString());
                }
            }
            object4 = this.getUsedCertificateSet();
            enumeration = this.chainCerts.keys();
            while (enumeration.hasMoreElements()) {
                try {
                    object3 = (CertId)enumeration.nextElement();
                    Certificate certificate = (Certificate)this.chainCerts.get(object3);
                    if (!object4.contains(certificate) || ((Hashtable)object5).get(certificate) != null) continue;
                    aSN1Object2 = new CertBag(x509Certificate, new DEROctetString(certificate.getEncoded()));
                    contentInfoArray = new ASN1EncodableVector();
                    object2 = new SafeBag(certBag, ((CertBag)aSN1Object2).toASN1Primitive(), new DERSet((ASN1EncodableVector)contentInfoArray));
                    ((ASN1EncodableVector)object7).add((ASN1Encodable)object2);
                }
                catch (CertificateEncodingException certificateEncodingException) {
                    throw new IOException("Error encoding certificate: " + certificateEncodingException.toString());
                }
            }
            object3 = new DERSequence((ASN1EncodableVector)object7).getEncoded("DER");
            byte[] byArray2 = this.cryptData(true, (AlgorithmIdentifier)object6, cArray, (byte[])object3);
            aSN1Object2 = new EncryptedData(data, (AlgorithmIdentifier)object6, new BEROctetString(byArray2));
            contentInfoArray = new ContentInfo[]{new ContentInfo(data, (ASN1Encodable)object9), new ContentInfo(encryptedData, ((EncryptedData)aSN1Object2).toASN1Primitive())};
            object2 = new AuthenticatedSafe(contentInfoArray);
            object = new ByteArrayOutputStream();
            DEROutputStream dEROutputStream = bl ? new DEROutputStream((OutputStream)object) : new BEROutputStream((OutputStream)object);
            dEROutputStream.writeObject((ASN1Encodable)object2);
            byte[] byArray3 = ((ByteArrayOutputStream)object).toByteArray();
            ContentInfo contentInfo = new ContentInfo(data, new BEROctetString(byArray3));
            byte[] byArray4 = new byte[20];
            int n = 1024;
            this.random.nextBytes(byArray4);
            byte[] byArray5 = ((ASN1OctetString)contentInfo.getContent()).getOctets();
            try {
                aSN1Object = new AlgorithmIdentifier(id_SHA1, DERNull.INSTANCE);
                byte[] byArray6 = this.calculatePbeMac((AlgorithmIdentifier)aSN1Object, byArray4, n, cArray, byArray5);
                DigestInfo digestInfo = new DigestInfo((AlgorithmIdentifier)aSN1Object, byArray6);
                macData = new MacData(digestInfo, byArray4, n);
            }
            catch (Exception exception) {
                throw new IOException("error constructing MAC: " + exception.toString());
            }
            aSN1Object = new Pfx(contentInfo, macData);
            dEROutputStream = bl ? new DEROutputStream(outputStream) : new BEROutputStream(outputStream);
            dEROutputStream.writeObject(aSN1Object);
        }

        private byte[] calculatePbeMacWrongZero(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, int n, byte[] byArray2) throws Exception {
            byte[] byArray3 = this.getDerivedMacKey(algorithmIdentifier, new byte[2], byArray, n);
            String string = algorithmIdentifier.getAlgorithm().getId();
            Mac mac = Mac.getInstance(string, this.fipsProvider);
            mac.init(new SecretKeySpec(byArray3, string));
            mac.update(byArray2);
            return mac.doFinal();
        }

        private byte[] calculatePbeMac(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, int n, char[] cArray, byte[] byArray2) throws Exception {
            byte[] byArray3 = this.getDerivedMacKey(algorithmIdentifier, PasswordConverter.PKCS12.convert(cArray), byArray, n);
            String string = algorithmIdentifier.getAlgorithm().getId();
            Mac mac = Mac.getInstance(string, this.fipsProvider);
            mac.init(new SecretKeySpec(byArray3, string));
            mac.update(byArray2);
            return mac.doFinal();
        }

        private byte[] getDerivedMacKey(AlgorithmIdentifier algorithmIdentifier, byte[] byArray, byte[] byArray2, int n) {
            int n2;
            PasswordBasedDeriver<PBKD.Parameters> passwordBasedDeriver;
            if (algorithmIdentifier.getAlgorithm().equals(CryptoProObjectIdentifiers.gostR3411)) {
                passwordBasedDeriver = new PBKD.DeriverFactory().createDeriver(PBKD.PKCS12.using(SecureHash.Algorithm.GOST3411, byArray).withSalt(byArray2).withIterationCount(n));
                n2 = 32;
            } else if (algorithmIdentifier.getAlgorithm().equals(NISTObjectIdentifiers.id_sha224)) {
                passwordBasedDeriver = new PBKD.DeriverFactory().createDeriver(PBKD.PKCS12.using(FipsSHS.Algorithm.SHA224, byArray).withSalt(byArray2).withIterationCount(n));
                n2 = 28;
            } else if (algorithmIdentifier.getAlgorithm().equals(NISTObjectIdentifiers.id_sha256)) {
                passwordBasedDeriver = new PBKD.DeriverFactory().createDeriver(PBKD.PKCS12.using(FipsSHS.Algorithm.SHA256, byArray).withSalt(byArray2).withIterationCount(n));
                n2 = 32;
            } else {
                passwordBasedDeriver = new PBKD.DeriverFactory().createDeriver(PBKD.PKCS12.using(FipsSHS.Algorithm.SHA1, byArray).withSalt(byArray2).withIterationCount(n));
                n2 = 20;
            }
            return passwordBasedDeriver.deriveKey(PasswordBasedDeriver.KeyType.MAC, n2);
        }

        private Set getUsedCertificateSet() {
            Object object;
            String string;
            HashSet<Object> hashSet = new HashSet<Object>();
            Enumeration enumeration = this.keys.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                object = this.engineGetCertificateChain(string);
                for (int i = 0; i != ((Certificate[])object).length; ++i) {
                    hashSet.add(object[i]);
                }
            }
            enumeration = this.certs.keys();
            while (enumeration.hasMoreElements()) {
                string = (String)enumeration.nextElement();
                object = this.engineGetCertificate(string);
                hashSet.add(object);
            }
            return hashSet;
        }

        private class CertId {
            byte[] id;

            CertId(PublicKey publicKey) throws IOException {
                this.id = PKCS12KeyStoreSpi.this.createSubjectKeyId(publicKey).getKeyIdentifier();
            }

            CertId(byte[] byArray) {
                this.id = byArray;
            }

            public int hashCode() {
                return Arrays.hashCode(this.id);
            }

            public boolean equals(Object object) {
                if (object == this) {
                    return true;
                }
                if (!(object instanceof CertId)) {
                    return false;
                }
                CertId certId = (CertId)object;
                return Arrays.areEqual(this.id, certId.id);
            }
        }

        private static class IgnoresCaseHashtable {
            private Hashtable orig = new Hashtable();
            private Hashtable keys = new Hashtable();

            private IgnoresCaseHashtable() {
            }

            public void put(String string, Object object) {
                String string2 = Strings.toLowerCase(string);
                String string3 = (String)this.keys.get(string2);
                if (string3 != null) {
                    this.orig.remove(string3);
                }
                this.keys.put(string2, string);
                this.orig.put(string, object);
            }

            public Enumeration keys() {
                return this.orig.keys();
            }

            public Object remove(String string) {
                if (string == null) {
                    return null;
                }
                String string2 = (String)this.keys.remove(Strings.toLowerCase(string));
                if (string2 == null) {
                    return null;
                }
                return this.orig.remove(string2);
            }

            public Object get(String string) {
                if (string == null) {
                    return null;
                }
                String string2 = (String)this.keys.get(Strings.toLowerCase(string));
                if (string2 == null) {
                    return null;
                }
                return this.orig.get(string2);
            }

            public Enumeration elements() {
                return this.orig.elements();
            }

            public void clear() {
                this.orig.clear();
            }
        }
    }
}

