/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.security.SecureRandom;
import java.security.SecureRandomSpi;
import org.bouncycastle.jcajce.provider.AsymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.EngineCreator;

class ProvRandom
extends AsymmetricAlgorithmProvider {
    private static final String PREFIX = "org.bouncycastle.jcajce.provider.random.";

    ProvRandom() {
    }

    public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("SecureRandom.DEFAULT", "org.bouncycastle.jcajce.provider.random.DefSecureRandom", new EngineCreator(){

            public Object createInstance(Object object) {
                final SecureRandom secureRandom = bouncyCastleFipsProvider.getDefaultSecureRandom();
                return new SecureRandomSpi(){

                    protected void engineSetSeed(byte[] byArray) {
                        secureRandom.setSeed(byArray);
                    }

                    protected void engineNextBytes(byte[] byArray) {
                        secureRandom.nextBytes(byArray);
                    }

                    protected byte[] engineGenerateSeed(int n) {
                        return secureRandom.generateSeed(n);
                    }
                };
            }
        });
    }
}

