/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.fips;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.JarException;
import java.util.logging.Logger;
import org.bouncycastle.crypto.fips.FipsNativeServices;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.crypto.fips.NativeLibIdentity;
import org.bouncycastle.crypto.fips.VariantSelector;
import org.bouncycastle.crypto.internal.ExtendedDigest;
import org.bouncycastle.crypto.internal.io.DigestOutputStream;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Properties;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.io.Streams;
import org.bouncycastle.util.io.TeeOutputStream;

class NativeLoader {
    private static final Logger LOG = Logger.getLogger(NativeLoader.class.getName());
    public static final String BCFIPS_LIB_CPU_VARIANT = "org.bouncycastle.native.cpu_variant";
    private static final AtomicBoolean nativeLibsAvailableForSystem = new AtomicBoolean(false);
    private static final AtomicBoolean nativeInstalled = new AtomicBoolean(false);
    private static final AtomicBoolean nativeEnabled = new AtomicBoolean(false);
    private static final AtomicReference<String> nativeStatusMessage = new AtomicReference<String>("Driver load not attempted");
    private static final AtomicReference<String> selectedVariant = new AtomicReference<Object>(null);
    private static final FipsNativeServices nativeServices = new FipsNativeServices();

    NativeLoader() {
    }

    static synchronized boolean isNativeInstalled() {
        return nativeInstalled.get();
    }

    static synchronized boolean isNativeAvailable() {
        return nativeLibsAvailableForSystem.get() && nativeInstalled.get() && nativeEnabled.get();
    }

    static synchronized void setNativeEnabled(boolean bl) {
        nativeEnabled.set(bl);
    }

    static synchronized String getNativeStatusMessage() {
        return nativeStatusMessage.get();
    }

    static synchronized String getSelectedVariant() {
        return selectedVariant.get();
    }

    static String getFile(String string) {
        String string2;
        try {
            InputStream inputStream = NativeLoader.class.getResourceAsStream(string);
            string2 = Strings.fromByteArray(Streams.readAll(inputStream));
            inputStream.close();
        }
        catch (Exception exception) {
            return null;
        }
        return string2;
    }

    static List<String> loadVariantsDeps(String string, String string2) {
        String string3 = NativeLoader.getFile(string);
        if (string3 == null) {
            return Collections.emptyList();
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string4 : string3.split("\n")) {
            String[] stringArray = (string4 = string4.trim()).split(":");
            if (!stringArray[0].trim().equals(string2)) continue;
            arrayList.add(stringArray[1].trim());
        }
        return Collections.unmodifiableList(arrayList);
    }

    static File installLib(String string, String string2, String string3, File file, Set<File> set) throws Exception {
        String string4 = System.mapLibraryName(string);
        List<String> list = NativeLoader.loadVariantsDeps(string3 + "/deps.list", string4);
        for (String string5 : list) {
            set.remove(NativeLoader.copyFromJar(string3 + "/" + string5, file, string5));
        }
        File file2 = NativeLoader.copyFromJar(string2 + "/" + string4, file, string4);
        set.remove(file2);
        return file2;
    }

    static synchronized void loadDriver() {
        String string = Properties.getPropertyValue(BCFIPS_LIB_CPU_VARIANT);
        if ("java".equals(string)) {
            nativeEnabled.set(false);
            nativeInstalled.set(false);
            nativeStatusMessage.set("java support only");
            return;
        }
        String string2 = Strings.toLowerCase(Properties.getPropertyValue("os.arch", ""));
        String string3 = Strings.toLowerCase(Properties.getPropertyValue("os.name", ""));
        String string4 = null;
        String string5 = null;
        if (string3.contains("linux")) {
            string4 = "linux";
        }
        if (string4 == null) {
            nativeStatusMessage.set("OS '" + string3 + "' is not supported.");
            return;
        }
        if (string2.contains("x86") || string2.contains("amd") && string2.contains("64")) {
            string5 = "x86_64";
        }
        if (string5 == null) {
            nativeStatusMessage.set("architecture '" + string2 + "' is not supported");
            return;
        }
        File file = AccessController.doPrivileged(new PrivilegedAction<File>(){

            @Override
            public File run() {
                File file = new File(Properties.getPropertyValue("java.io.tmpdir"));
                if (!file.exists()) {
                    nativeInstalled.set(false);
                    nativeStatusMessage.set(file + " did not exist");
                    return null;
                }
                try {
                    File file2 = null;
                    long l = System.nanoTime();
                    for (int i = 0; i < 1000 && !(file2 = new File(file, "bc-fips-jni" + Long.toString(l + (long)i, 32) + "-libs")).mkdirs(); ++i) {
                        file2 = null;
                        Thread.sleep(l % 97L);
                    }
                    if (file2 == null) {
                        nativeInstalled.set(false);
                        nativeStatusMessage.set("unable to create directory in " + file + " after 1000 unique attempts");
                        return null;
                    }
                    if (!file2.exists()) {
                        nativeInstalled.set(false);
                        nativeStatusMessage.set("unable to create temp directory for jni libs: " + file2);
                        return null;
                    }
                    final File file3 = file2;
                    Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                        @Override
                        public void run() {
                            if (!file3.exists()) {
                                return;
                            }
                            boolean bl = true;
                            if (file3.isDirectory()) {
                                for (File file : file3.listFiles()) {
                                    bl &= file.delete();
                                }
                            }
                            if (!(bl &= file3.delete())) {
                                LOG.fine(" failed to delete: " + file3.getAbsolutePath());
                            } else {
                                LOG.fine("successfully cleaned up: " + file3.getAbsolutePath());
                            }
                        }
                    }));
                    return file3;
                }
                catch (Exception exception) {
                    nativeInstalled.set(false);
                    nativeStatusMessage.set("failed because it was not able to create a temporary file in 'java.io.tmpdir' " + exception.getMessage());
                    return null;
                }
            }
        });
        if (file == null) {
            return;
        }
        HashSet<File> hashSet = new HashSet<File>();
        for (File iOException : file.listFiles()) {
            hashSet.add(iOException);
        }
        String string6 = String.format("/native/%s/%s", string4, string5);
        String string7 = String.format("/native/%s/%s/probe", string4, string5);
        InputStream inputStream = NativeLoader.class.getResourceAsStream(string7 + "/" + System.mapLibraryName("bc-probe"));
        if (inputStream == null) {
            nativeStatusMessage.set(String.format("platform '%s' and architecture '%s' are not supported", string4, string5));
            nativeInstalled.set(false);
            return;
        }
        try {
            inputStream.close();
        }
        catch (IOException exception) {
            // empty catch block
        }
        if (string != null) {
            selectedVariant.set(string);
        } else {
            try {
                final File file2 = NativeLoader.installLib("bc-probe", string7, string6, file, hashSet);
                AccessController.doPrivileged(new PrivilegedAction<Object>(){

                    @Override
                    public Object run() {
                        System.load(file2.getAbsolutePath());
                        return new Object();
                    }
                });
            }
            catch (Exception exception) {
                nativeStatusMessage.set("probe lib failed to load " + exception.getMessage());
                nativeInstalled.set(false);
                return;
            }
            try {
                selectedVariant.set(VariantSelector.getBestVariantName());
            }
            catch (Throwable throwable) {
                nativeStatusMessage.set("probe lib failed return a variant " + throwable.getMessage());
                nativeInstalled.set(false);
                return;
            }
        }
        if (selectedVariant.get().equals("none")) {
            nativeEnabled.set(false);
            nativeInstalled.set(false);
            nativeStatusMessage.set("probe returned no suitable CPU features, java support only");
            return;
        }
        String string8 = String.format("/native/%s/%s/%s", string4, string5, selectedVariant);
        try {
            final File file3 = NativeLoader.installLib("bc-fips-" + selectedVariant, string8, string6, file, hashSet);
            if (!hashSet.isEmpty()) {
                StringBuilder stringBuilder = new StringBuilder();
                for (File file4 : hashSet) {
                    if (stringBuilder.length() != 0) {
                        stringBuilder.append(",");
                    }
                    stringBuilder.append(file4.getName());
                }
                nativeStatusMessage.set(String.format("unexpected files in %s: %s", file.toString(), stringBuilder.toString()));
                nativeInstalled.set(false);
                return;
            }
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    System.load(file3.getAbsolutePath());
                    return new Object();
                }
            });
        }
        catch (Exception exception) {
            nativeStatusMessage.set("native capabilities lib failed to load " + exception.getMessage());
            nativeInstalled.set(false);
            return;
        }
        if (!selectedVariant.get().equals(NativeLibIdentity.getLibraryIdent())) {
            nativeStatusMessage.set(String.format("loaded native library variant is %s but the requested library variant is %s", NativeLibIdentity.getLibraryIdent(), selectedVariant));
            nativeInstalled.set(false);
            return;
        }
        nativeLibsAvailableForSystem.set(true);
        nativeStatusMessage.set("successfully loaded");
        nativeInstalled.set(true);
        nativeEnabled.set(true);
    }

    public static boolean isNativeLibsAvailableForSystem() {
        return nativeLibsAvailableForSystem.get();
    }

    static FipsNativeServices getNativeServices() {
        return nativeServices;
    }

    static boolean hasNativeService(String string) {
        return NativeLoader.isNativeAvailable() && nativeServices.hasService(string);
    }

    private static byte[] takeSHA256Digest(InputStream inputStream) {
        try {
            int n;
            byte[] byArray = new byte[65535];
            ExtendedDigest extendedDigest = FipsSHS.createBaseDigest(FipsSHS.Algorithm.SHA256);
            while ((n = inputStream.read(byArray)) >= 0) {
                extendedDigest.update(byArray, 0, n);
            }
            byte[] byArray2 = new byte[extendedDigest.getDigestSize()];
            extendedDigest.doFinal(byArray2, 0);
            return byArray2;
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException.getMessage(), iOException);
        }
    }

    private static File copyFromJar(String string, File file, String string2) throws Exception {
        InputStream inputStream = NativeLoader.class.getResourceAsStream(string);
        if (inputStream == null) {
            throw new JarException(string + " lib not found in jar");
        }
        File file2 = new File(file, string2);
        if (file2.exists()) {
            byte[] byArray = NativeLoader.takeSHA256Digest(inputStream);
            inputStream.close();
            FileInputStream fileInputStream = new FileInputStream(file2);
            byte[] byArray2 = NativeLoader.takeSHA256Digest(fileInputStream);
            fileInputStream.close();
            if (Arrays.constantTimeAreEqual(byArray2, byArray)) {
                return file2;
            }
            throw new IOException("pre existing file found and is different to file in jar file");
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        ExtendedDigest extendedDigest = FipsSHS.createBaseDigest(FipsSHS.Algorithm.SHA256);
        DigestOutputStream digestOutputStream = new DigestOutputStream(extendedDigest);
        TeeOutputStream teeOutputStream = new TeeOutputStream(fileOutputStream, digestOutputStream);
        Streams.pipeAll(inputStream, teeOutputStream);
        teeOutputStream.flush();
        teeOutputStream.close();
        inputStream.close();
        FileInputStream fileInputStream = new FileInputStream(file2);
        byte[] byArray = NativeLoader.takeSHA256Digest(fileInputStream);
        fileInputStream.close();
        byte[] byArray3 = digestOutputStream.getDigest();
        if (!Arrays.constantTimeAreEqual(byArray3, byArray)) {
            throw new IOException("file copied from jar does not have same digest as source file in jar");
        }
        return file2;
    }

    public static boolean isNativeEnabled() {
        return nativeEnabled.get();
    }
}

