/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.io.OutputStream;
import java.security.AlgorithmParameterGenerator;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.RC2ParameterSpec;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSEnvelopedGenerator;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.CMSException;

public class CMSAuthenticatedGenerator
extends CMSEnvelopedGenerator {
    public CMSAuthenticatedGenerator() {
    }

    public CMSAuthenticatedGenerator(SecureRandom secureRandom) {
        super(secureRandom);
    }

    protected AlgorithmIdentifier getAlgorithmIdentifier(String string, AlgorithmParameterSpec algorithmParameterSpec, Provider provider) throws IOException, NoSuchAlgorithmException, InvalidParameterSpecException {
        DERNull dERNull;
        ASN1InputStream aSN1InputStream;
        AlgorithmParameters algorithmParameters = CMSEnvelopedHelper.INSTANCE.createAlgorithmParameters(string, provider);
        algorithmParameters.init(algorithmParameterSpec);
        if (algorithmParameters != null) {
            aSN1InputStream = new ASN1InputStream(algorithmParameters.getEncoded("ASN.1"));
            dERNull = aSN1InputStream.readObject();
        } else {
            dERNull = new DERNull();
        }
        aSN1InputStream = new AlgorithmIdentifier(new DERObjectIdentifier(string), (DEREncodable)dERNull);
        return aSN1InputStream;
    }

    protected AlgorithmParameterSpec generateParameterSpec(String string, SecretKey secretKey, Provider provider) throws CMSException {
        try {
            if (string.equals(RC2_CBC)) {
                byte[] byArray = new byte[8];
                this.rand.setSeed(System.currentTimeMillis());
                this.rand.nextBytes(byArray);
                return new RC2ParameterSpec(secretKey.getEncoded().length * 8, byArray);
            }
            AlgorithmParameterGenerator algorithmParameterGenerator = CMSEnvelopedHelper.INSTANCE.createAlgorithmParameterGenerator(string, provider);
            AlgorithmParameters algorithmParameters = algorithmParameterGenerator.generateParameters();
            return algorithmParameters.getParameterSpec(IvParameterSpec.class);
        }
        catch (GeneralSecurityException generalSecurityException) {
            return null;
        }
    }

    protected class MacOutputStream
    extends OutputStream {
        private final OutputStream out;
        private Mac mac;

        MacOutputStream(OutputStream outputStream, Mac mac) {
            this.out = outputStream;
            this.mac = mac;
        }

        public void write(byte[] byArray) throws IOException {
            this.mac.update(byArray, 0, byArray.length);
            this.out.write(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.mac.update(byArray, n, n2);
            this.out.write(byArray, n, n2);
        }

        public void write(int n) throws IOException {
            this.mac.update((byte)n);
            this.out.write(n);
        }

        public void close() throws IOException {
            this.out.close();
        }

        public byte[] getMac() {
            return this.mac.doFinal();
        }
    }
}

