/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.AttributeTable;
import org.bouncycastle.asn1.cms.CMSAttributes;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.SignedData;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.cms.CMSAttributeTableGenerator;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedGenerator;
import org.bouncycastle.cms.CMSSignedHelper;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.DefaultSignedAttributeTableGenerator;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.cms.SimpleAttributeTableGenerator;

public class CMSSignedDataGenerator
extends CMSSignedGenerator {
    List signerInfs = new ArrayList();

    public CMSSignedDataGenerator() {
    }

    public CMSSignedDataGenerator(SecureRandom secureRandom) {
        super(secureRandom);
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string) throws IllegalArgumentException {
        String string2 = this.getEncOID(privateKey, string);
        this.signerInfs.add(new SignerInf(privateKey, x509Certificate, string, string2, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(), null, null));
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string) throws IllegalArgumentException {
        String string2 = this.getEncOID(privateKey, string);
        this.signerInfs.add(new SignerInf(privateKey, byArray, string, string2, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(), null, null));
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, AttributeTable attributeTable, AttributeTable attributeTable2) throws IllegalArgumentException {
        String string2 = this.getEncOID(privateKey, string);
        this.signerInfs.add(new SignerInf(privateKey, x509Certificate, string, string2, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(attributeTable), (CMSAttributeTableGenerator)new SimpleAttributeTableGenerator(attributeTable2), attributeTable));
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, AttributeTable attributeTable, AttributeTable attributeTable2) throws IllegalArgumentException {
        String string2 = this.getEncOID(privateKey, string);
        this.signerInfs.add(new SignerInf(privateKey, byArray, string, string2, (CMSAttributeTableGenerator)new DefaultSignedAttributeTableGenerator(attributeTable), (CMSAttributeTableGenerator)new SimpleAttributeTableGenerator(attributeTable2), attributeTable));
    }

    public void addSigner(PrivateKey privateKey, X509Certificate x509Certificate, String string, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2) throws IllegalArgumentException {
        String string2 = this.getEncOID(privateKey, string);
        this.signerInfs.add(new SignerInf(privateKey, x509Certificate, string, string2, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, null));
    }

    public void addSigner(PrivateKey privateKey, byte[] byArray, String string, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2) throws IllegalArgumentException {
        String string2 = this.getEncOID(privateKey, string);
        this.signerInfs.add(new SignerInf(privateKey, byArray, string, string2, cMSAttributeTableGenerator, cMSAttributeTableGenerator2, null));
    }

    private DERObject makeObj(byte[] byArray) throws IOException {
        if (byArray == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ASN1InputStream aSN1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
        return aSN1InputStream.readObject();
    }

    private AlgorithmIdentifier makeAlgId(String string, byte[] byArray) throws IOException {
        if (byArray != null) {
            return new AlgorithmIdentifier(new DERObjectIdentifier(string), (DEREncodable)this.makeObj(byArray));
        }
        return new AlgorithmIdentifier(new DERObjectIdentifier(string), (DEREncodable)new DERNull());
    }

    public CMSSignedData generate(CMSProcessable cMSProcessable, String string) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(cMSProcessable, CMSUtils.getProvider(string));
    }

    public CMSSignedData generate(CMSProcessable cMSProcessable, Provider provider) throws NoSuchAlgorithmException, CMSException {
        return this.generate(cMSProcessable, false, provider);
    }

    public CMSSignedData generate(String string, CMSProcessable cMSProcessable, boolean bl, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(string, cMSProcessable, bl, CMSUtils.getProvider(string2), true);
    }

    public CMSSignedData generate(String string, CMSProcessable cMSProcessable, boolean bl, Provider provider) throws NoSuchAlgorithmException, CMSException {
        return this.generate(string, cMSProcessable, bl, provider, true);
    }

    public CMSSignedData generate(String string, CMSProcessable cMSProcessable, boolean bl, String string2, boolean bl2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(string, cMSProcessable, bl, CMSUtils.getProvider(string2), bl2);
    }

    public CMSSignedData generate(String string, CMSProcessable cMSProcessable, boolean bl, Provider provider, boolean bl2) throws NoSuchAlgorithmException, CMSException {
        ContentInfo contentInfo;
        BERConstructedOctetString bERConstructedOctetString;
        ByteArrayOutputStream byteArrayOutputStream;
        AlgorithmIdentifier algorithmIdentifier;
        SignerInf signerInf;
        boolean bl3;
        SignerInformation signerInformation;
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        this._digests.clear();
        Iterator iterator = this._signers.iterator();
        while (iterator.hasNext()) {
            AlgorithmIdentifier algorithmIdentifier2;
            signerInformation = (SignerInformation)iterator.next();
            try {
                algorithmIdentifier2 = this.makeAlgId(signerInformation.getDigestAlgOID(), signerInformation.getDigestAlgParams());
            }
            catch (IOException iOException) {
                throw new CMSException("encoding error.", iOException);
            }
            aSN1EncodableVector.add((DEREncodable)algorithmIdentifier2);
            aSN1EncodableVector2.add((DEREncodable)signerInformation.toSignerInfo());
        }
        if (string != null) {
            signerInformation = new DERObjectIdentifier(string);
            bl3 = false;
        } else {
            signerInformation = CMSObjectIdentifiers.data;
            bl3 = true;
        }
        iterator = this.signerInfs.iterator();
        while (iterator.hasNext()) {
            signerInf = (SignerInf)iterator.next();
            try {
                algorithmIdentifier = this.makeAlgId(signerInf.getDigestAlgOID(), signerInf.getDigestAlgParams());
                aSN1EncodableVector.add((DEREncodable)algorithmIdentifier);
                aSN1EncodableVector2.add((DEREncodable)signerInf.toSignerInfo((DERObjectIdentifier)signerInformation, cMSProcessable, this.rand, provider, bl2, bl3));
            }
            catch (IOException iOException) {
                throw new CMSException("encoding error.", iOException);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new CMSException("key inappropriate for signature.", invalidKeyException);
            }
            catch (SignatureException signatureException) {
                throw new CMSException("error creating signature.", signatureException);
            }
            catch (CertificateEncodingException certificateEncodingException) {
                throw new CMSException("error creating sid.", certificateEncodingException);
            }
        }
        signerInf = null;
        if (this._certs.size() != 0) {
            signerInf = CMSUtils.createBerSetFromList(this._certs);
        }
        algorithmIdentifier = null;
        if (this._crls.size() != 0) {
            algorithmIdentifier = CMSUtils.createBerSetFromList(this._crls);
        }
        if (bl) {
            byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                cMSProcessable.write(byteArrayOutputStream);
            }
            catch (IOException iOException) {
                throw new CMSException("encapsulation error.", iOException);
            }
            bERConstructedOctetString = new BERConstructedOctetString(byteArrayOutputStream.toByteArray());
            contentInfo = new ContentInfo((DERObjectIdentifier)signerInformation, (DEREncodable)bERConstructedOctetString);
        } else {
            contentInfo = new ContentInfo((DERObjectIdentifier)signerInformation, null);
        }
        byteArrayOutputStream = new SignedData((ASN1Set)new DERSet((DEREncodableVector)aSN1EncodableVector), contentInfo, (ASN1Set)signerInf, (ASN1Set)algorithmIdentifier, (ASN1Set)new DERSet((DEREncodableVector)aSN1EncodableVector2));
        bERConstructedOctetString = new ContentInfo(PKCSObjectIdentifiers.signedData, (DEREncodable)byteArrayOutputStream);
        return new CMSSignedData(cMSProcessable, (ContentInfo)bERConstructedOctetString);
    }

    public CMSSignedData generate(CMSProcessable cMSProcessable, boolean bl, String string) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(DATA, cMSProcessable, bl, string);
    }

    public CMSSignedData generate(CMSProcessable cMSProcessable, boolean bl, Provider provider) throws NoSuchAlgorithmException, CMSException {
        return this.generate(DATA, cMSProcessable, bl, provider);
    }

    public SignerInformationStore generateCounterSigners(SignerInformation signerInformation, Provider provider) throws NoSuchAlgorithmException, CMSException {
        return this.generate(null, (CMSProcessable)new CMSProcessableByteArray(signerInformation.getSignature()), false, provider).getSignerInfos();
    }

    public SignerInformationStore generateCounterSigners(SignerInformation signerInformation, String string) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(null, (CMSProcessable)new CMSProcessableByteArray(signerInformation.getSignature()), false, CMSUtils.getProvider(string)).getSignerInfos();
    }

    private class SignerInf {
        private PrivateKey key;
        private X509Certificate cert;
        private String digestOID;
        private String encOID;
        private CMSAttributeTableGenerator sAttr;
        private CMSAttributeTableGenerator unsAttr;
        private AttributeTable baseSignedTable;
        private byte[] keyIdentifier;

        SignerInf(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2) {
            this(privateKey, x509Certificate, string, string2, null, null, null);
        }

        SignerInf(PrivateKey privateKey, byte[] byArray, String string, String string2) {
            this(privateKey, byArray, string, string2, null, null, null);
        }

        SignerInf(PrivateKey privateKey, X509Certificate x509Certificate, String string, String string2, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, AttributeTable attributeTable) {
            this.key = privateKey;
            this.cert = x509Certificate;
            this.digestOID = string;
            this.encOID = string2;
            this.sAttr = cMSAttributeTableGenerator;
            this.unsAttr = cMSAttributeTableGenerator2;
            this.baseSignedTable = attributeTable;
        }

        SignerInf(PrivateKey privateKey, byte[] byArray, String string, String string2, CMSAttributeTableGenerator cMSAttributeTableGenerator, CMSAttributeTableGenerator cMSAttributeTableGenerator2, AttributeTable attributeTable) {
            this.key = privateKey;
            this.keyIdentifier = byArray;
            this.digestOID = string;
            this.encOID = string2;
            this.sAttr = cMSAttributeTableGenerator;
            this.unsAttr = cMSAttributeTableGenerator2;
            this.baseSignedTable = attributeTable;
        }

        PrivateKey getKey() {
            return this.key;
        }

        X509Certificate getCertificate() {
            return this.cert;
        }

        String getDigestAlgOID() {
            return this.digestOID;
        }

        byte[] getDigestAlgParams() {
            return null;
        }

        String getEncryptionAlgOID() {
            return this.encOID;
        }

        CMSAttributeTableGenerator getSignedAttributes() {
            return this.sAttr;
        }

        CMSAttributeTableGenerator getUnsignedAttributes() {
            return this.unsAttr;
        }

        SignerInfo toSignerInfo(DERObjectIdentifier dERObjectIdentifier, CMSProcessable cMSProcessable, SecureRandom secureRandom, Provider provider, boolean bl, boolean bl2) throws IOException, SignatureException, InvalidKeyException, NoSuchAlgorithmException, CertificateEncodingException, CMSException {
            SignerIdentifier signerIdentifier;
            ByteArrayOutputStream byteArrayOutputStream;
            byte[] byArray;
            AttributeTable attributeTable;
            Map map;
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(new DERObjectIdentifier(this.getDigestAlgOID()), (DEREncodable)new DERNull());
            AlgorithmIdentifier algorithmIdentifier2 = CMSSignedDataGenerator.this.getEncAlgorithmIdentifier(this.getEncryptionAlgOID());
            String string = CMSSignedHelper.INSTANCE.getDigestAlgName(this.digestOID);
            String string2 = string + "with" + CMSSignedHelper.INSTANCE.getEncryptionAlgName(this.encOID);
            Signature signature = CMSSignedHelper.INSTANCE.getSignatureInstance(string2, provider);
            MessageDigest messageDigest = CMSSignedHelper.INSTANCE.getDigestInstance(string, provider);
            byte[] byArray2 = null;
            if (cMSProcessable != null) {
                cMSProcessable.write(new DigOutputStream(messageDigest));
                byArray2 = messageDigest.digest();
                CMSSignedDataGenerator.this._digests.put(this.digestOID, byArray2.clone());
            }
            if (bl) {
                map = CMSSignedDataGenerator.this.getBaseParameters(dERObjectIdentifier, algorithmIdentifier, byArray2);
                attributeTable = this.sAttr != null ? this.sAttr.getAttributes(Collections.unmodifiableMap(map)) : null;
            } else {
                attributeTable = this.baseSignedTable;
            }
            if (bl2) {
                map = attributeTable.toHashtable();
                ((Hashtable)map).remove(CMSAttributes.contentType);
                attributeTable = new AttributeTable((Hashtable)map);
            }
            if ((map = CMSSignedDataGenerator.this.getAttributeSet(attributeTable)) != null) {
                byArray = map.getEncoded("DER");
            } else {
                byteArrayOutputStream = new ByteArrayOutputStream();
                cMSProcessable.write(byteArrayOutputStream);
                byArray = byteArrayOutputStream.toByteArray();
            }
            signature.initSign(this.key, secureRandom);
            signature.update(byArray);
            byteArrayOutputStream = new DEROctetString(signature.sign());
            Map map2 = CMSSignedDataGenerator.this.getBaseParameters(dERObjectIdentifier, algorithmIdentifier, byArray2);
            map2.put("encryptedDigest", byteArrayOutputStream.getOctets().clone());
            AttributeTable attributeTable2 = this.unsAttr != null ? this.unsAttr.getAttributes(Collections.unmodifiableMap(map2)) : null;
            ASN1Set aSN1Set = CMSSignedDataGenerator.this.getAttributeSet(attributeTable2);
            X509Certificate x509Certificate = this.getCertificate();
            if (x509Certificate != null) {
                TBSCertificateStructure tBSCertificateStructure = TBSCertificateStructure.getInstance((Object)ASN1Object.fromByteArray((byte[])x509Certificate.getTBSCertificate()));
                IssuerAndSerialNumber issuerAndSerialNumber = new IssuerAndSerialNumber(tBSCertificateStructure.getIssuer(), tBSCertificateStructure.getSerialNumber().getValue());
                signerIdentifier = new SignerIdentifier(issuerAndSerialNumber);
            } else {
                signerIdentifier = new SignerIdentifier((ASN1OctetString)new DEROctetString(this.keyIdentifier));
            }
            return new SignerInfo(signerIdentifier, algorithmIdentifier, (ASN1Set)map, algorithmIdentifier2, (ASN1OctetString)byteArrayOutputStream, aSN1Set);
        }
    }

    static class SigOutputStream
    extends OutputStream {
        Signature sig;

        public SigOutputStream(Signature signature) {
            this.sig = signature;
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            try {
                this.sig.update(byArray, n, n2);
            }
            catch (SignatureException signatureException) {
                throw new IOException("signature problem: " + signatureException);
            }
        }

        public void write(int n) throws IOException {
            try {
                this.sig.update((byte)n);
            }
            catch (SignatureException signatureException) {
                throw new IOException("signature problem: " + signatureException);
            }
        }
    }

    static class DigOutputStream
    extends OutputStream {
        MessageDigest dig;

        public DigOutputStream(MessageDigest messageDigest) {
            this.dig = messageDigest;
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            this.dig.update(byArray, n, n2);
        }

        public void write(int n) throws IOException {
            this.dig.update((byte)n);
        }
    }
}

