/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidParameterSpecException;
import javax.crypto.KeyGenerator;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.BERConstructedOctetString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.cms.AuthenticatedData;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSAuthenticatedData;
import org.bouncycastle.cms.CMSAuthenticatedGenerator;
import org.bouncycastle.cms.CMSEnvelopedHelper;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSProcessable;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.RecipientInfoGenerator;

public class CMSAuthenticatedDataGenerator
extends CMSAuthenticatedGenerator {
    public CMSAuthenticatedDataGenerator() {
    }

    public CMSAuthenticatedDataGenerator(SecureRandom secureRandom) {
        super(secureRandom);
    }

    private CMSAuthenticatedData generate(CMSProcessable cMSProcessable, String string, KeyGenerator keyGenerator, Provider provider) throws NoSuchAlgorithmException, CMSException {
        DEROctetString dEROctetString;
        BERConstructedOctetString bERConstructedOctetString;
        ByteArrayOutputStream byteArrayOutputStream;
        AlgorithmIdentifier algorithmIdentifier;
        Object object;
        SecretKey secretKey;
        Object object2;
        Provider provider2 = keyGenerator.getProvider();
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        try {
            object2 = CMSEnvelopedHelper.INSTANCE.getMac(string, provider2);
            secretKey = keyGenerator.generateKey();
            object = this.generateParameterSpec(string, secretKey, provider2);
            ((Mac)object2).init(secretKey, (AlgorithmParameterSpec)object);
            algorithmIdentifier = this.getAlgorithmIdentifier(string, (AlgorithmParameterSpec)object, provider2);
            byteArrayOutputStream = new ByteArrayOutputStream();
            CMSAuthenticatedGenerator.MacOutputStream macOutputStream = new CMSAuthenticatedGenerator.MacOutputStream(this, byteArrayOutputStream, (Mac)object2);
            cMSProcessable.write(macOutputStream);
            macOutputStream.close();
            byteArrayOutputStream.close();
            bERConstructedOctetString = new BERConstructedOctetString(byteArrayOutputStream.toByteArray());
            dEROctetString = new DEROctetString(macOutputStream.getMac());
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
        catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
            throw new CMSException("algorithm parameters invalid.", invalidAlgorithmParameterException);
        }
        catch (IOException iOException) {
            throw new CMSException("exception decoding algorithm parameters.", iOException);
        }
        catch (InvalidParameterSpecException invalidParameterSpecException) {
            throw new CMSException("exception setting up parameters.", invalidParameterSpecException);
        }
        object2 = this.recipientInfoGenerators.iterator();
        while (object2.hasNext()) {
            object = (RecipientInfoGenerator)object2.next();
            try {
                aSN1EncodableVector.add((DEREncodable)object.generate(secretKey, this.rand, provider));
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new CMSException("key inappropriate for algorithm.", invalidKeyException);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new CMSException("error making encrypted content.", generalSecurityException);
            }
        }
        object = new ContentInfo(CMSObjectIdentifiers.data, (DEREncodable)bERConstructedOctetString);
        byteArrayOutputStream = new ContentInfo(CMSObjectIdentifiers.authenticatedData, (DEREncodable)new AuthenticatedData(null, (ASN1Set)new DERSet((DEREncodableVector)aSN1EncodableVector), algorithmIdentifier, null, (ContentInfo)object, null, (ASN1OctetString)dEROctetString, null));
        return new CMSAuthenticatedData((ContentInfo)byteArrayOutputStream);
    }

    public CMSAuthenticatedData generate(CMSProcessable cMSProcessable, String string, String string2) throws NoSuchAlgorithmException, NoSuchProviderException, CMSException {
        return this.generate(cMSProcessable, string, CMSUtils.getProvider(string2));
    }

    public CMSAuthenticatedData generate(CMSProcessable cMSProcessable, String string, Provider provider) throws NoSuchAlgorithmException, CMSException {
        KeyGenerator keyGenerator = CMSEnvelopedHelper.INSTANCE.createSymmetricKeyGenerator(string, provider);
        keyGenerator.init(this.rand);
        return this.generate(cMSProcessable, string, keyGenerator, provider);
    }
}

