/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms;

import java.io.IOException;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KeyAgreeRecipientInfo;
import org.bouncycastle.asn1.cms.OriginatorPublicKey;
import org.bouncycastle.asn1.cms.RecipientEncryptedKey;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.CMSTypedStream;
import org.bouncycastle.cms.CMSUtils;
import org.bouncycastle.cms.RecipientId;
import org.bouncycastle.cms.RecipientInformation;

public class KeyAgreeRecipientInformation
extends RecipientInformation {
    private KeyAgreeRecipientInfo info;
    private ASN1OctetString _encryptedKey;

    public KeyAgreeRecipientInformation(KeyAgreeRecipientInfo keyAgreeRecipientInfo, AlgorithmIdentifier algorithmIdentifier, InputStream inputStream) {
        this(keyAgreeRecipientInfo, algorithmIdentifier, null, inputStream);
    }

    public KeyAgreeRecipientInformation(KeyAgreeRecipientInfo keyAgreeRecipientInfo, AlgorithmIdentifier algorithmIdentifier, AlgorithmIdentifier algorithmIdentifier2, InputStream inputStream) {
        super(algorithmIdentifier, algorithmIdentifier2, AlgorithmIdentifier.getInstance((Object)keyAgreeRecipientInfo.getKeyEncryptionAlgorithm()), inputStream);
        this.info = keyAgreeRecipientInfo;
        try {
            ASN1Sequence aSN1Sequence = this.info.getRecipientEncryptedKeys();
            RecipientEncryptedKey recipientEncryptedKey = RecipientEncryptedKey.getInstance((Object)aSN1Sequence.getObjectAt(0));
            IssuerAndSerialNumber issuerAndSerialNumber = recipientEncryptedKey.getIdentifier().getIssuerAndSerialNumber();
            this.rid = new RecipientId();
            this.rid.setIssuer(issuerAndSerialNumber.getName().getEncoded());
            this.rid.setSerialNumber(issuerAndSerialNumber.getSerialNumber().getValue());
            this._encryptedKey = recipientEncryptedKey.getEncryptedKey();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid rid in KeyAgreeRecipientInformation");
        }
    }

    protected Key unwrapKey(Key key, Provider provider) throws CMSException {
        try {
            OriginatorPublicKey originatorPublicKey = this.info.getOriginator().getOriginatorKey();
            PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance((Object)ASN1Object.fromByteArray((byte[])key.getEncoded()));
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(privateKeyInfo.getAlgorithmId(), originatorPublicKey.getPublicKey().getBytes());
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(subjectPublicKeyInfo.getEncoded());
            KeyFactory keyFactory = KeyFactory.getInstance(this.keyEncAlg.getObjectId().getId(), provider);
            KeyAgreement keyAgreement = KeyAgreement.getInstance(this.keyEncAlg.getObjectId().getId(), provider);
            keyAgreement.init(key);
            keyAgreement.doPhase(keyFactory.generatePublic(x509EncodedKeySpec), true);
            String string = DERObjectIdentifier.getInstance((Object)ASN1Sequence.getInstance((Object)this.keyEncAlg.getParameters()).getObjectAt(0)).getId();
            SecretKey secretKey = keyAgreement.generateSecret(string);
            Cipher cipher = Cipher.getInstance(string, provider);
            cipher.init(4, secretKey);
            AlgorithmIdentifier algorithmIdentifier = this.encAlg;
            if (algorithmIdentifier == null) {
                algorithmIdentifier = this.macAlg;
            }
            String string2 = algorithmIdentifier.getObjectId().getId();
            byte[] byArray = this._encryptedKey.getOctets();
            return cipher.unwrap(byArray, string2, 3);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CMSException("can't find algorithm.", noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CMSException("key invalid in message.", invalidKeyException);
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            throw new CMSException("originator key spec invalid.", invalidKeySpecException);
        }
        catch (NoSuchPaddingException noSuchPaddingException) {
            throw new CMSException("required padding not supported.", noSuchPaddingException);
        }
        catch (Exception exception) {
            throw new CMSException("originator key invalid.", exception);
        }
    }

    @Override
    public CMSTypedStream getContentStream(Key key, String string) throws CMSException, NoSuchProviderException {
        return this.getContentStream(key, CMSUtils.getProvider(string));
    }

    @Override
    public CMSTypedStream getContentStream(Key key, Provider provider) throws CMSException {
        Key key2 = this.unwrapKey(key, provider);
        return this.getContentFromSessionKey(key2, provider);
    }
}

