/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureVerifier;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.util.Strings;

public class PGPSignatureVerifierBuilder {
    private final PGPContentVerifierBuilderProvider verifierBuilderProvider;
    private final PGPPublicKey verificationKey;

    public PGPSignatureVerifierBuilder(PGPContentVerifierBuilderProvider verifierBuilderProvider, PGPPublicKey verificationKey) {
        this.verifierBuilderProvider = verifierBuilderProvider;
        this.verificationKey = verificationKey;
    }

    public PGPSignatureVerifier buildDirectKeyVerifier(PGPSignature certification, PGPPublicKey publicKey) throws PGPException {
        if (certification.getSignatureType() != 31) {
            throw new PGPException("signature is not a direct key signature");
        }
        return this.doBuildKeyCertificationVerifier(certification, publicKey);
    }

    public PGPSignatureVerifier buildKeyRevocationVerifier(PGPSignature certification, PGPPublicKey publicKey) throws PGPException {
        if (certification.getSignatureType() != 32) {
            throw new PGPException("signature is not a key revocation signature");
        }
        return this.doBuildKeyCertificationVerifier(certification, publicKey);
    }

    public PGPSignatureVerifier buildPrimaryKeyBindingVerifier(PGPSignature certification, PGPPublicKey primaryKey, PGPPublicKey subKey) throws PGPException {
        if (certification.getSignatureType() != 25) {
            throw new PGPException("signature is not a primary key binding signature");
        }
        return this.doBuildKeyBindingVerifier(certification, primaryKey, subKey);
    }

    public PGPSignatureVerifier buildSubKeyBindingVerifier(PGPSignature certification, PGPPublicKey primaryKey, PGPPublicKey subKey) throws PGPException {
        if (certification.getSignatureType() != 24) {
            throw new PGPException("signature is not a subkey binding signature");
        }
        return this.doBuildKeyBindingVerifier(certification, primaryKey, subKey);
    }

    public PGPSignatureVerifier buildSubKeyRevocationVerifier(PGPSignature certification, PGPPublicKey primaryKey, PGPPublicKey subKey) throws PGPException {
        if (certification.getSignatureType() != 40) {
            throw new PGPException("signature is not a primary key binding signature");
        }
        return this.doBuildKeyBindingVerifier(certification, primaryKey, subKey);
    }

    public PGPSignatureVerifier buildCertificationVerifier(PGPSignature certification, String userID, PGPPublicKey publicKey) throws PGPException {
        return this.buildCertificationVerifier(certification, Strings.toUTF8ByteArray((String)userID), publicKey);
    }

    public PGPSignatureVerifier buildCertificationVerifier(PGPSignature certification, byte[] rawUserID, PGPPublicKey publicKey) throws PGPException {
        int signatureType = certification.getSignatureType();
        if (!PGPSignature.isCertification(signatureType) && 48 != signatureType) {
            throw new PGPException("signature is neither a certification signature nor a certification revocation");
        }
        return this.doBuildCertificationVerifier(certification, rawUserID, publicKey);
    }

    public PGPSignatureVerifier buildCertificationVerifier(PGPSignature certification, PGPUserAttributeSubpacketVector userAttributes, PGPPublicKey publicKey) throws PGPException {
        int signatureType = certification.getSignatureType();
        if (!PGPSignature.isCertification(signatureType) && 48 != signatureType) {
            throw new PGPException("signature is neither a certification signature nor a certification revocation");
        }
        return this.doBuildCertificationVerifier(certification, userAttributes, publicKey);
    }

    private PGPSignatureVerifier doBuildCertificationVerifier(PGPSignature certification, final byte[] rawUserID, final PGPPublicKey publicKey) throws PGPException {
        final PGPSignature localSig = this.createLocalSig(certification);
        return new PGPSignatureVerifier(){

            public int getSignatureType() {
                return localSig.getSignatureType();
            }

            public boolean isVerified() throws PGPException {
                return localSig.doVerifyCertification(rawUserID, publicKey);
            }
        };
    }

    private PGPSignature createLocalSig(PGPSignature certification) throws PGPException {
        PGPSignature localSig = new PGPSignature(certification);
        localSig.init(localSig.createVerifierProvider(this.verifierBuilderProvider).build(this.verificationKey));
        return localSig;
    }

    private PGPSignatureVerifier doBuildCertificationVerifier(PGPSignature certification, final PGPUserAttributeSubpacketVector userAttributes, final PGPPublicKey publicKey) throws PGPException {
        final PGPSignature localSig = this.createLocalSig(certification);
        return new PGPSignatureVerifier(){

            public int getSignatureType() {
                return localSig.getSignatureType();
            }

            public boolean isVerified() throws PGPException {
                return localSig.doVerifyCertification(userAttributes, publicKey);
            }
        };
    }

    private PGPSignatureVerifier doBuildKeyCertificationVerifier(PGPSignature keyCertification, final PGPPublicKey publicKey) throws PGPException {
        final PGPSignature localSig = this.createLocalSig(keyCertification);
        return new PGPSignatureVerifier(){

            public int getSignatureType() {
                return localSig.getSignatureType();
            }

            public boolean isVerified() throws PGPException {
                return localSig.doVerifyCertification(publicKey);
            }
        };
    }

    private PGPSignatureVerifier doBuildKeyBindingVerifier(PGPSignature certification, final PGPPublicKey primaryKey, final PGPPublicKey subKey) throws PGPException {
        final PGPSignature localSig = this.createLocalSig(certification);
        return new PGPSignatureVerifier(){

            public int getSignatureType() {
                return localSig.getSignatureType();
            }

            public boolean isVerified() throws PGPException {
                return localSig.doVerifyCertification(primaryKey, subKey);
            }
        };
    }
}

