/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.security.Provider;
import java.security.SecureRandom;
import org.bouncycastle.bcpg.AEADUtils;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.AEADSecretKeyEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.jcajce.JceAEADUtil;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;

public class JcaAEADSecretKeyEncryptorBuilder
implements AEADSecretKeyEncryptorBuilder {
    private int aeadAlgorithm;
    private int symmetricAlgorithm;
    private S2K.Argon2Params argon2Params;
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
    private JceAEADUtil aeadUtil = new JceAEADUtil(this.helper);

    public JcaAEADSecretKeyEncryptorBuilder(int aeadAlgorithm, int symmetricAlgorithm, S2K.Argon2Params argon2Params) {
        this.aeadAlgorithm = aeadAlgorithm;
        this.symmetricAlgorithm = symmetricAlgorithm;
        this.argon2Params = argon2Params;
    }

    public JcaAEADSecretKeyEncryptorBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        this.aeadUtil = new JceAEADUtil(this.helper);
        return this;
    }

    public JcaAEADSecretKeyEncryptorBuilder setProvider(String providerName) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(providerName));
        this.aeadUtil = new JceAEADUtil(this.helper);
        return this;
    }

    public PBESecretKeyEncryptor build(char[] passphrase, final PublicKeyPacket pubKey) {
        return new PBESecretKeyEncryptor(this.symmetricAlgorithm, this.aeadAlgorithm, this.argon2Params, new SecureRandom(), passphrase){
            private byte[] iv;
            {
                super(x0, x1, x2, x3, x4);
                this.iv = new byte[AEADUtils.getIVLength(this.aeadAlgorithm)];
                this.random.nextBytes(this.iv);
            }

            public byte[] encryptKeyData(byte[] key, byte[] keyData, int keyOff, int keyLen) throws PGPException {
                try {
                    return JceAEADUtil.processAeadKeyData(JcaAEADSecretKeyEncryptorBuilder.this.aeadUtil, 1, this.encAlgorithm, this.aeadAlgorithm, this.getKey(), this.iv, pubKey.getPacketTag() == 6 ? 5 : 7, pubKey.getVersion(), keyData, keyOff, keyLen, pubKey.getEncodedContents());
                }
                catch (Exception e) {
                    throw new PGPException("Exception AEAD protecting private key material", e);
                }
            }

            public byte[] getCipherIV() {
                return this.iv;
            }
        };
    }
}

