/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.Provider;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;

public class JcaPGPDigestCalculatorProviderBuilder {
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());

    public JcaPGPDigestCalculatorProviderBuilder() {
    }

    JcaPGPDigestCalculatorProviderBuilder(OperatorHelper helper) {
        this.helper = helper;
    }

    public JcaPGPDigestCalculatorProviderBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcaPGPDigestCalculatorProviderBuilder setProvider(String providerName) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(providerName));
        return this;
    }

    public PGPDigestCalculatorProvider build() throws PGPException {
        return new PGPDigestCalculatorProvider(){

            public PGPDigestCalculator get(int algorithm) throws PGPException {
                DigestOutputStream stream;
                MessageDigest dig;
                try {
                    dig = JcaPGPDigestCalculatorProviderBuilder.this.helper.createDigest(algorithm);
                    stream = new DigestOutputStream(dig);
                }
                catch (GeneralSecurityException e) {
                    throw new PGPException("exception on setup: " + e, e);
                }
                return new PGPDigestCalculator(this, algorithm, stream, dig){
                    private final /* synthetic */ int val$algorithm;
                    private final /* synthetic */ DigestOutputStream val$stream;
                    private final /* synthetic */ MessageDigest val$dig;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$algorithm = val$algorithm;
                        this.val$stream = val$stream;
                        this.val$dig = val$dig;
                    }

                    public int getAlgorithm() {
                        return this.val$algorithm;
                    }

                    public OutputStream getOutputStream() {
                        return this.val$stream;
                    }

                    public byte[] getDigest() {
                        return this.val$stream.getDigest();
                    }

                    public void reset() {
                        this.val$dig.reset();
                    }
                };
            }
        };
    }

    private static class DigestOutputStream
    extends OutputStream {
        private MessageDigest dig;

        DigestOutputStream(MessageDigest dig) {
            this.dig = dig;
        }

        public void write(byte[] bytes, int off, int len) throws IOException {
            this.dig.update(bytes, off, len);
        }

        public void write(byte[] bytes) throws IOException {
            this.dig.update(bytes);
        }

        public void write(int b) throws IOException {
            this.dig.update((byte)b);
        }

        byte[] getDigest() {
            return this.dig.digest();
        }
    }
}

