/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.api;

import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.bcpg.SignatureSubpacket;
import org.bouncycastle.bcpg.sig.NotationData;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.api.OpenPGPPolicy;
import org.bouncycastle.openpgp.api.util.UTCUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenPGPDefaultPolicy
implements OpenPGPPolicy {
    private final Map<Integer, Date> documentHashAlgorithmCutoffDates = new HashMap<Integer, Date>();
    private final Map<Integer, Date> certificateHashAlgorithmCutoffDates = new HashMap<Integer, Date>();
    private final Map<Integer, Date> symmetricKeyAlgorithmCutoffDates = new HashMap<Integer, Date>();
    private final Map<Integer, Integer> publicKeyMinimalBitStrengths = new HashMap<Integer, Integer>();
    private int defaultDocumentSignatureHashAlgorithm = 10;
    private int defaultCertificationSignatureHashAlgorithm = 10;
    private int defaultSymmetricKeyAlgorithm = 7;

    public OpenPGPDefaultPolicy() {
        this.setDefaultCertificationSignatureHashAlgorithm(10);
        this.acceptCertificationSignatureHashAlgorithm(14);
        this.acceptCertificationSignatureHashAlgorithm(12);
        this.acceptCertificationSignatureHashAlgorithm(10);
        this.acceptCertificationSignatureHashAlgorithm(9);
        this.acceptCertificationSignatureHashAlgorithm(8);
        this.acceptCertificationSignatureHashAlgorithm(11);
        this.acceptCertificationSignatureHashAlgorithmUntil(2, UTCUtil.parse("2023-02-01 00:00:00 UTC"));
        this.acceptCertificationSignatureHashAlgorithmUntil(3, UTCUtil.parse("2023-02-01 00:00:00 UTC"));
        this.acceptCertificationSignatureHashAlgorithmUntil(1, UTCUtil.parse("1997-02-01 00:00:00 UTC"));
        this.setDefaultDocumentSignatureHashAlgorithm(10);
        this.acceptDocumentSignatureHashAlgorithm(14);
        this.acceptDocumentSignatureHashAlgorithm(12);
        this.acceptDocumentSignatureHashAlgorithm(10);
        this.acceptDocumentSignatureHashAlgorithm(9);
        this.acceptDocumentSignatureHashAlgorithm(8);
        this.acceptDocumentSignatureHashAlgorithm(11);
        this.setDefaultSymmetricKeyAlgorithm(7);
        this.acceptSymmetricKeyAlgorithm(9);
        this.acceptSymmetricKeyAlgorithm(8);
        this.acceptSymmetricKeyAlgorithm(7);
        this.acceptSymmetricKeyAlgorithm(10);
        this.acceptSymmetricKeyAlgorithm(13);
        this.acceptSymmetricKeyAlgorithm(12);
        this.acceptSymmetricKeyAlgorithm(11);
        this.acceptPublicKeyAlgorithmWithMinimalStrength(1, 2000);
        this.acceptPublicKeyAlgorithmWithMinimalStrength(2, 2000);
        this.acceptPublicKeyAlgorithmWithMinimalStrength(3, 2000);
        this.acceptPublicKeyAlgorithmWithMinimalStrength(19, 250);
        this.acceptPublicKeyAlgorithmWithMinimalStrength(22, 250);
        this.acceptPublicKeyAlgorithmWithMinimalStrength(18, 250);
        this.acceptPublicKeyAlgorithm(25);
        this.acceptPublicKeyAlgorithm(26);
        this.acceptPublicKeyAlgorithm(27);
        this.acceptPublicKeyAlgorithm(28);
    }

    @Override
    public boolean isAcceptableSigningKey(PGPPublicKey key) {
        return this.isAcceptablePublicKey(key);
    }

    @Override
    public boolean isAcceptableVerificationKey(PGPPublicKey key) {
        return this.isAcceptablePublicKey(key);
    }

    @Override
    public boolean isAcceptableEncryptionKey(PGPPublicKey key) {
        return this.isAcceptablePublicKey(key);
    }

    @Override
    public boolean isAcceptableDecryptionKey(PGPPublicKey key) {
        return this.isAcceptablePublicKey(key);
    }

    @Override
    public boolean isAcceptablePublicKey(PGPPublicKey key) {
        return this.isAcceptablePublicKeyStrength(key.getAlgorithm(), key.getBitStrength());
    }

    @Override
    public boolean isAcceptableSignature(PGPSignature signature) {
        return this.hasAcceptableSignatureHashAlgorithm(signature) && this.hasNoCriticalUnknownNotations(signature) && this.hasNoCriticalUnknownSubpackets(signature);
    }

    @Override
    public boolean hasAcceptableSignatureHashAlgorithm(PGPSignature signature) {
        switch (signature.getSignatureType()) {
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 24: 
            case 25: 
            case 31: {
                return this.hasAcceptableCertificationSignatureHashAlgorithm(signature);
            }
            case 32: 
            case 40: 
            case 48: {
                return this.hasAcceptableRevocationSignatureHashAlgorithm(signature);
            }
        }
        return this.hasAcceptableDocumentSignatureHashAlgorithm(signature);
    }

    @Override
    public boolean hasAcceptableDocumentSignatureHashAlgorithm(PGPSignature signature) {
        return this.isAcceptableDocumentSignatureHashAlgorithm(signature.getHashAlgorithm(), signature.getCreationTime());
    }

    @Override
    public boolean hasAcceptableRevocationSignatureHashAlgorithm(PGPSignature signature) {
        return this.isAcceptableRevocationSignatureHashAlgorithm(signature.getHashAlgorithm(), signature.getCreationTime());
    }

    @Override
    public boolean hasAcceptableCertificationSignatureHashAlgorithm(PGPSignature signature) {
        return this.isAcceptableCertificationSignatureHashAlgorithm(signature.getHashAlgorithm(), signature.getCreationTime());
    }

    @Override
    public boolean hasNoCriticalUnknownNotations(PGPSignature signature) {
        NotationData[] notations;
        PGPSignatureSubpacketVector hashedSubpackets = signature.getHashedSubPackets();
        if (hashedSubpackets == null) {
            return true;
        }
        OpenPGPPolicy.OpenPGPNotationRegistry registry = this.getNotationRegistry();
        for (NotationData notation : notations = hashedSubpackets.getNotationDataOccurrences()) {
            if (!notation.isCritical() || registry.isNotationKnown(notation.getNotationName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean hasNoCriticalUnknownSubpackets(PGPSignature signature) {
        PGPSignatureSubpacketVector hashedSubpackets = signature.getHashedSubPackets();
        if (hashedSubpackets == null) {
            return true;
        }
        for (SignatureSubpacket subpacket : hashedSubpackets.toArray()) {
            if (!subpacket.isCritical() || !subpacket.getClass().equals(SignatureSubpacket.class) || this.isKnownSignatureSubpacket(subpacket.getType())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isKnownSignatureSubpacket(int signatureSubpacketTag) {
        return false;
    }

    public OpenPGPDefaultPolicy rejectHashAlgorithm(int hashAlgorithmId) {
        this.certificateHashAlgorithmCutoffDates.remove(hashAlgorithmId);
        this.documentHashAlgorithmCutoffDates.remove(hashAlgorithmId);
        return this;
    }

    public OpenPGPDefaultPolicy acceptCertificationSignatureHashAlgorithm(int hashAlgorithmId) {
        return this.acceptCertificationSignatureHashAlgorithmUntil(hashAlgorithmId, null);
    }

    public OpenPGPDefaultPolicy acceptCertificationSignatureHashAlgorithmUntil(int hashAlgorithmId, Date until) {
        this.certificateHashAlgorithmCutoffDates.put(hashAlgorithmId, until);
        return this;
    }

    public OpenPGPDefaultPolicy acceptDocumentSignatureHashAlgorithm(int hashAlgorithmId) {
        return this.acceptDocumentSignatureHashAlgorithmUntil(hashAlgorithmId, null);
    }

    public OpenPGPDefaultPolicy acceptDocumentSignatureHashAlgorithmUntil(int hashAlgorithmId, Date until) {
        this.documentHashAlgorithmCutoffDates.put(hashAlgorithmId, until);
        return this;
    }

    public OpenPGPDefaultPolicy rejectSymmetricKeyAlgorithm(int symmetricKeyAlgorithmId) {
        this.symmetricKeyAlgorithmCutoffDates.remove(symmetricKeyAlgorithmId);
        return this;
    }

    public OpenPGPDefaultPolicy acceptSymmetricKeyAlgorithm(int symmetricKeyAlgorithmId) {
        return this.acceptSymmetricKeyAlgorithmUntil(symmetricKeyAlgorithmId, null);
    }

    public OpenPGPDefaultPolicy acceptSymmetricKeyAlgorithmUntil(int symmetricKeyAlgorithmId, Date until) {
        this.symmetricKeyAlgorithmCutoffDates.put(symmetricKeyAlgorithmId, until);
        return this;
    }

    public OpenPGPDefaultPolicy rejectPublicKeyAlgorithm(int publicKeyAlgorithmId) {
        this.publicKeyMinimalBitStrengths.remove(publicKeyAlgorithmId);
        return this;
    }

    public OpenPGPDefaultPolicy acceptPublicKeyAlgorithm(int publicKeyAlgorithmId) {
        this.publicKeyMinimalBitStrengths.put(publicKeyAlgorithmId, null);
        return this;
    }

    public OpenPGPDefaultPolicy acceptPublicKeyAlgorithmWithMinimalStrength(int publicKeyAlgorithmId, int minBitStrength) {
        this.publicKeyMinimalBitStrengths.put(publicKeyAlgorithmId, minBitStrength);
        return this;
    }

    @Override
    public boolean isAcceptableDocumentSignatureHashAlgorithm(int hashAlgorithmId, Date signatureCreationTime) {
        return this.isAcceptable(hashAlgorithmId, signatureCreationTime, this.documentHashAlgorithmCutoffDates);
    }

    @Override
    public boolean isAcceptableRevocationSignatureHashAlgorithm(int hashAlgorithmId, Date signatureCreationTime) {
        return this.isAcceptable(hashAlgorithmId, signatureCreationTime, this.certificateHashAlgorithmCutoffDates);
    }

    @Override
    public boolean isAcceptableCertificationSignatureHashAlgorithm(int hashAlgorithmId, Date signatureCreationTime) {
        return this.isAcceptable(hashAlgorithmId, signatureCreationTime, this.certificateHashAlgorithmCutoffDates);
    }

    @Override
    public int getDefaultCertificationSignatureHashAlgorithm() {
        return this.defaultCertificationSignatureHashAlgorithm;
    }

    public OpenPGPDefaultPolicy setDefaultCertificationSignatureHashAlgorithm(int hashAlgorithmId) {
        this.defaultCertificationSignatureHashAlgorithm = hashAlgorithmId;
        return this;
    }

    @Override
    public int getDefaultDocumentSignatureHashAlgorithm() {
        return this.defaultDocumentSignatureHashAlgorithm;
    }

    public OpenPGPDefaultPolicy setDefaultDocumentSignatureHashAlgorithm(int hashAlgorithmId) {
        this.defaultDocumentSignatureHashAlgorithm = hashAlgorithmId;
        return this;
    }

    @Override
    public boolean isAcceptableSymmetricKeyAlgorithm(int symmetricKeyAlgorithmId) {
        return this.isAcceptable(symmetricKeyAlgorithmId, this.symmetricKeyAlgorithmCutoffDates);
    }

    @Override
    public int getDefaultSymmetricKeyAlgorithm() {
        return this.defaultSymmetricKeyAlgorithm;
    }

    public OpenPGPDefaultPolicy setDefaultSymmetricKeyAlgorithm(int symmetricKeyAlgorithmId) {
        this.defaultSymmetricKeyAlgorithm = symmetricKeyAlgorithmId;
        return this;
    }

    @Override
    public boolean isAcceptablePublicKeyStrength(int publicKeyAlgorithmId, int bitStrength) {
        return this.isAcceptable(publicKeyAlgorithmId, bitStrength, this.publicKeyMinimalBitStrengths);
    }

    @Override
    public OpenPGPPolicy.OpenPGPNotationRegistry getNotationRegistry() {
        return null;
    }

    private boolean isAcceptable(int algorithmId, Date usageDate, Map<Integer, Date> cutoffTable) {
        if (!cutoffTable.containsKey(algorithmId)) {
            return false;
        }
        Date cutoffDate = cutoffTable.get(algorithmId);
        if (cutoffDate == null) {
            return true;
        }
        return usageDate.before(cutoffDate);
    }

    private boolean isAcceptable(int algorithmId, Map<Integer, Date> cutoffTable) {
        return cutoffTable.containsKey(algorithmId);
    }

    private boolean isAcceptable(int algorithmId, int bitStrength, Map<Integer, Integer> minBitStrengths) {
        if (!minBitStrengths.containsKey(algorithmId)) {
            return false;
        }
        Integer minBitStrength = minBitStrengths.get(algorithmId);
        if (minBitStrength == null) {
            return true;
        }
        return bitStrength >= minBitStrength;
    }
}

