/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.examples;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import org.bouncycastle.bcpg.ArmoredOutputStream;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openpgp.PGPCompressedData;
import org.bouncycastle.openpgp.PGPCompressedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataGenerator;
import org.bouncycastle.openpgp.PGPEncryptedDataList;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralData;
import org.bouncycastle.openpgp.PGPPBEEncryptedData;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.jcajce.JcaPGPObjectFactory;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBEDataDecryptorFactoryBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcePBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.jcajce.JcePGPDataEncryptorBuilder;
import org.bouncycastle.util.io.Streams;

public class PBEFileProcessor {
    private static void decryptFile(String inputFileName, char[] passPhrase) throws IOException, PGPException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(inputFileName));
        PBEFileProcessor.decryptFile(in, passPhrase);
        ((InputStream)in).close();
    }

    private static void decryptFile(InputStream in, char[] passPhrase) throws IOException, PGPException {
        JcaPGPObjectFactory pgpF = new JcaPGPObjectFactory(in = PGPUtil.getDecoderStream(in));
        Object o = pgpF.nextObject();
        PGPEncryptedDataList enc = o instanceof PGPEncryptedDataList ? (PGPEncryptedDataList)o : (PGPEncryptedDataList)pgpF.nextObject();
        PGPPBEEncryptedData pbe = (PGPPBEEncryptedData)enc.get(0);
        if (!pbe.isIntegrityProtected()) {
            throw new PGPException("Message is not integrity protected!");
        }
        JcePBEDataDecryptorFactoryBuilder decryptorFactoryBuilder = new JcePBEDataDecryptorFactoryBuilder(new JcaPGPDigestCalculatorProviderBuilder().setProvider("BC").build()).setProvider("BC");
        InputStream clear = pbe.getDataStream(decryptorFactoryBuilder.build(passPhrase));
        pgpF = new JcaPGPObjectFactory(clear);
        o = pgpF.nextObject();
        if (o instanceof PGPCompressedData) {
            PGPCompressedData cData = (PGPCompressedData)o;
            pgpF = new JcaPGPObjectFactory(cData.getDataStream());
            o = pgpF.nextObject();
        }
        PGPLiteralData ld = (PGPLiteralData)o;
        InputStream unc = ld.getInputStream();
        FileOutputStream fOut = new FileOutputStream(ld.getFileName());
        Streams.pipeAll((InputStream)unc, (OutputStream)fOut, (int)8192);
        ((OutputStream)fOut).close();
        if (!pbe.verify()) {
            System.err.println("message failed integrity check");
        } else {
            System.err.println("message integrity check passed");
        }
    }

    private static void encryptFile(String outputFileName, String inputFileName, char[] passPhrase, boolean armor) throws IOException {
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outputFileName));
        PBEFileProcessor.encryptToStream(out, inputFileName, passPhrase, armor);
        ((OutputStream)out).close();
    }

    private static void encryptToStream(OutputStream out, String fileName, char[] passPhrase, boolean armor) throws IOException {
        block4: {
            if (armor) {
                out = new ArmoredOutputStream(out);
            }
            File file = new File(fileName);
            try {
                JcePGPDataEncryptorBuilder dataEncBuilder = new JcePGPDataEncryptorBuilder(9).setProvider("BC").setSecureRandom(new SecureRandom()).setWithIntegrityPacket(true);
                PGPEncryptedDataGenerator encGen = new PGPEncryptedDataGenerator(dataEncBuilder);
                encGen.addMethod(new JcePBEKeyEncryptionMethodGenerator(passPhrase).setProvider("BC"));
                OutputStream encOut = encGen.open(out, new byte[8192]);
                PGPCompressedDataGenerator compGen = new PGPCompressedDataGenerator(1);
                OutputStream compOut = compGen.open(encOut);
                PGPUtil.writeFileToLiteralData(compOut, 'b', file);
                compOut.flush();
                compOut.close();
                encOut.flush();
                encOut.close();
                if (armor) {
                    out.flush();
                    out.close();
                }
            }
            catch (PGPException e) {
                System.err.println(e);
                if (e.getUnderlyingException() == null) break block4;
                e.getUnderlyingException().printStackTrace();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (args[0].equals("-e")) {
            if (args[1].equals("-a")) {
                PBEFileProcessor.encryptFile(args[2] + ".asc", args[2], args[3].toCharArray(), true);
            } else {
                PBEFileProcessor.encryptFile(args[1] + ".bpg", args[1], args[2].toCharArray(), false);
            }
        } else if (args[0].equals("-d")) {
            PBEFileProcessor.decryptFile(args[1], args[2].toCharArray());
        } else {
            System.err.println("usage: PBEFileProcessor -e [-a]|-d file passPhrase");
        }
    }
}

