/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.gnu.GNUObjectIdentifiers;
import org.bouncycastle.bcpg.BCPGKey;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.DSAPublicBCPGKey;
import org.bouncycastle.bcpg.ECPublicBCPGKey;
import org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.bcpg.OctetArrayBCPGKey;
import org.bouncycastle.bcpg.PublicKeyAlgorithmTags;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.PublicSubkeyPacket;
import org.bouncycastle.bcpg.RSAPublicBCPGKey;
import org.bouncycastle.bcpg.TrustPacket;
import org.bouncycastle.bcpg.UserAttributePacket;
import org.bouncycastle.bcpg.UserDataPacket;
import org.bouncycastle.bcpg.UserIDPacket;
import org.bouncycastle.crypto.asymmetric.ECDomainParametersIndex;
import org.bouncycastle.crypto.asymmetric.NamedECDomainParameters;
import org.bouncycastle.openpgp.CryptlibObjectIdentifiers;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPSignatureSubpacketVector;
import org.bouncycastle.openpgp.PGPUserAttributeSubpacketVector;
import org.bouncycastle.openpgp.Util;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.util.Arrays;

public class PGPPublicKey
implements PublicKeyAlgorithmTags {
    private static final int[] MASTER_KEY_CERTIFICATION_TYPES = new int[]{19, 18, 17, 16, 31};
    PublicKeyPacket publicPk;
    TrustPacket trustPk;
    List<PGPSignature> keySigs = new ArrayList<PGPSignature>();
    List<UserDataPacket> ids = new ArrayList<UserDataPacket>();
    List<TrustPacket> idTrusts = new ArrayList<TrustPacket>();
    List<List<PGPSignature>> idSigs = new ArrayList<List<PGPSignature>>();
    List<PGPSignature> subSigs = null;
    private KeyIdentifier keyIdentifier;
    private int keyStrength;

    private void init(KeyFingerPrintCalculator keyFingerPrintCalculator) throws PGPException {
        BCPGKey bCPGKey = this.publicPk.getKey();
        byte[] byArray = keyFingerPrintCalculator.calculateFingerprint(this.publicPk);
        long l = PublicKeyPacket.getKeyID(this.publicPk, byArray);
        this.keyIdentifier = new KeyIdentifier(byArray, l);
        if (this.publicPk.getVersion() <= 3) {
            RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)bCPGKey;
            this.keyStrength = rSAPublicBCPGKey.getModulus().bitLength();
        } else if (this.publicPk.getVersion() >= 4) {
            if (bCPGKey instanceof RSAPublicBCPGKey) {
                this.keyStrength = ((RSAPublicBCPGKey)bCPGKey).getModulus().bitLength();
            } else if (bCPGKey instanceof DSAPublicBCPGKey) {
                this.keyStrength = ((DSAPublicBCPGKey)bCPGKey).getP().bitLength();
            } else if (bCPGKey instanceof ElGamalPublicBCPGKey) {
                this.keyStrength = ((ElGamalPublicBCPGKey)bCPGKey).getP().bitLength();
            } else if (bCPGKey instanceof ECPublicBCPGKey) {
                NamedECDomainParameters namedECDomainParameters;
                ASN1ObjectIdentifier aSN1ObjectIdentifier = ((ECPublicBCPGKey)bCPGKey).getCurveOID();
                this.keyStrength = aSN1ObjectIdentifier.equals((ASN1Primitive)GNUObjectIdentifiers.Ed25519) || aSN1ObjectIdentifier.equals((ASN1Primitive)CryptlibObjectIdentifiers.curvey25519) ? 256 : (aSN1ObjectIdentifier.equals((ASN1Primitive)EdECObjectIdentifiers.id_X448) ? 448 : (aSN1ObjectIdentifier.equals((ASN1Primitive)EdECObjectIdentifiers.id_Ed448) ? 456 : ((namedECDomainParameters = ECDomainParametersIndex.lookupDomainParameters((ASN1ObjectIdentifier)aSN1ObjectIdentifier)) != null ? namedECDomainParameters.getCurve().getFieldSize() : -1)));
            } else if (bCPGKey instanceof OctetArrayBCPGKey) {
                this.keyStrength = bCPGKey.getEncoded().length * 8;
            }
        }
    }

    public PGPPublicKey(PublicKeyPacket publicKeyPacket, KeyFingerPrintCalculator keyFingerPrintCalculator) throws PGPException {
        this.publicPk = publicKeyPacket;
        this.ids = new ArrayList<UserDataPacket>();
        this.idSigs = new ArrayList<List<PGPSignature>>();
        this.init(keyFingerPrintCalculator);
    }

    PGPPublicKey(PublicKeyPacket publicKeyPacket, TrustPacket trustPacket, List<PGPSignature> list, KeyFingerPrintCalculator keyFingerPrintCalculator) throws PGPException {
        this.publicPk = publicKeyPacket;
        this.trustPk = trustPacket;
        this.subSigs = list;
        this.init(keyFingerPrintCalculator);
    }

    PGPPublicKey(PGPPublicKey pGPPublicKey, TrustPacket trustPacket, List<PGPSignature> list) {
        this.publicPk = pGPPublicKey.publicPk;
        this.trustPk = trustPacket;
        this.subSigs = list;
        this.keyStrength = pGPPublicKey.keyStrength;
        this.keyIdentifier = pGPPublicKey.keyIdentifier;
    }

    PGPPublicKey(PGPPublicKey pGPPublicKey) {
        this.publicPk = pGPPublicKey.publicPk;
        this.keySigs = new ArrayList<PGPSignature>(pGPPublicKey.keySigs);
        this.ids = new ArrayList<UserDataPacket>(pGPPublicKey.ids);
        this.idTrusts = new ArrayList<TrustPacket>(pGPPublicKey.idTrusts);
        this.idSigs = new ArrayList<List<PGPSignature>>(pGPPublicKey.idSigs.size());
        for (int i = 0; i != pGPPublicKey.idSigs.size(); ++i) {
            this.idSigs.add(new ArrayList<PGPSignature>(pGPPublicKey.idSigs.get(i)));
        }
        if (pGPPublicKey.subSigs != null) {
            this.subSigs = new ArrayList<PGPSignature>(pGPPublicKey.subSigs.size());
            this.subSigs.addAll(pGPPublicKey.subSigs);
        }
        this.keyStrength = pGPPublicKey.keyStrength;
        this.keyIdentifier = pGPPublicKey.keyIdentifier;
    }

    PGPPublicKey(PublicKeyPacket publicKeyPacket, TrustPacket trustPacket, List<PGPSignature> list, List<UserDataPacket> list2, List<TrustPacket> list3, List<List<PGPSignature>> list4, KeyFingerPrintCalculator keyFingerPrintCalculator) throws PGPException {
        this.publicPk = publicKeyPacket;
        this.trustPk = trustPacket;
        this.keySigs = list;
        this.ids = list2;
        this.idTrusts = list3;
        this.idSigs = list4;
        this.init(keyFingerPrintCalculator);
    }

    PGPPublicKey(PGPPublicKey pGPPublicKey, TrustPacket trustPacket, List<PGPSignature> list, List<UserDataPacket> list2, List<TrustPacket> list3, List<List<PGPSignature>> list4) throws PGPException {
        this.publicPk = pGPPublicKey.publicPk;
        this.keyStrength = pGPPublicKey.keyStrength;
        this.keyIdentifier = pGPPublicKey.keyIdentifier;
        this.trustPk = trustPacket;
        this.keySigs = list;
        this.ids = list2;
        this.idTrusts = list3;
        this.idSigs = list4;
    }

    public int getVersion() {
        return this.publicPk.getVersion();
    }

    public Date getCreationTime() {
        return this.publicPk.getTime();
    }

    public int getValidDays() {
        if (this.publicPk.getVersion() > 3) {
            long l = this.getValidSeconds() % 86400L;
            int n = (int)(this.getValidSeconds() / 86400L);
            if (l > 0L && n == 0) {
                return 1;
            }
            return n;
        }
        return this.publicPk.getValidDays();
    }

    public byte[] getTrustData() {
        if (this.trustPk == null) {
            return null;
        }
        return Arrays.clone((byte[])this.trustPk.getLevelAndTrustAmount());
    }

    public long getValidSeconds() {
        if (this.publicPk.getVersion() > 3) {
            if (this.isMasterKey()) {
                for (int i = 0; i != MASTER_KEY_CERTIFICATION_TYPES.length; ++i) {
                    long l = this.getExpirationTimeFromSig(true, MASTER_KEY_CERTIFICATION_TYPES[i]);
                    if (l < 0L) continue;
                    return l;
                }
            } else {
                long l = this.getExpirationTimeFromSig(false, 24);
                if (l >= 0L) {
                    return l;
                }
                l = this.getExpirationTimeFromSig(false, 31);
                if (l >= 0L) {
                    return l;
                }
            }
            return 0L;
        }
        return (long)this.publicPk.getValidDays() * 24L * 60L * 60L;
    }

    private long getExpirationTimeFromSig(boolean bl, int n) {
        Iterator<PGPSignature> iterator = this.getSignaturesOfType(n);
        long l = -1L;
        long l2 = -1L;
        while (iterator.hasNext()) {
            PGPSignatureSubpacketVector pGPSignatureSubpacketVector;
            PGPSignature pGPSignature = iterator.next();
            if (bl && pGPSignature.getKeyID() != this.getKeyID() || (pGPSignatureSubpacketVector = pGPSignature.getHashedSubPackets()) == null || !pGPSignatureSubpacketVector.hasSubpacket(9)) continue;
            long l3 = pGPSignatureSubpacketVector.getKeyExpirationTime();
            if (pGPSignature.getKeyID() == this.getKeyID()) {
                if (pGPSignature.getCreationTime().getTime() <= l2) continue;
                l2 = pGPSignature.getCreationTime().getTime();
                l = l3;
                continue;
            }
            if (l3 != 0L && l3 <= l) continue;
            l = l3;
        }
        return l;
    }

    public long getKeyID() {
        return this.keyIdentifier.getKeyId();
    }

    public KeyIdentifier getKeyIdentifier() {
        return this.keyIdentifier;
    }

    public byte[] getFingerprint() {
        return this.keyIdentifier.getFingerprint();
    }

    public boolean hasFingerprint(byte[] byArray) {
        return this.keyIdentifier.hasFingerprint(byArray);
    }

    public boolean isEncryptionKey() {
        int n = this.publicPk.getAlgorithm();
        return n == 1 || n == 2 || n == 16 || n == 20 || n == 21 || n == 18 || n == 26 || n == 25;
    }

    public boolean isMasterKey() {
        return !(this.publicPk instanceof PublicSubkeyPacket) && (!this.isEncryptionKey() || this.publicPk.getAlgorithm() == 1);
    }

    public int getAlgorithm() {
        return this.publicPk.getAlgorithm();
    }

    public int getBitStrength() {
        return this.keyStrength;
    }

    public Iterator<String> getUserIDs() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i != this.ids.size(); ++i) {
            if (!(this.ids.get(i) instanceof UserIDPacket)) continue;
            arrayList.add(((UserIDPacket)this.ids.get(i)).getID());
        }
        return arrayList.iterator();
    }

    public Iterator<byte[]> getRawUserIDs() {
        ArrayList<byte[]> arrayList = new ArrayList<byte[]>();
        for (int i = 0; i != this.ids.size(); ++i) {
            if (!(this.ids.get(i) instanceof UserIDPacket)) continue;
            arrayList.add(((UserIDPacket)this.ids.get(i)).getRawID());
        }
        return arrayList.iterator();
    }

    public Iterator<PGPUserAttributeSubpacketVector> getUserAttributes() {
        ArrayList<PGPUserAttributeSubpacketVector> arrayList = new ArrayList<PGPUserAttributeSubpacketVector>();
        for (int i = 0; i != this.ids.size(); ++i) {
            if (!(this.ids.get(i) instanceof PGPUserAttributeSubpacketVector)) continue;
            arrayList.add((PGPUserAttributeSubpacketVector)this.ids.get(i));
        }
        return arrayList.iterator();
    }

    public Iterator<PGPSignature> getSignaturesForID(String string) {
        return this.getSignaturesForID(new UserIDPacket(string));
    }

    public Iterator<PGPSignature> getSignaturesForID(byte[] byArray) {
        return this.getSignaturesForID(new UserIDPacket(byArray));
    }

    public Iterator<PGPSignature> getSignaturesForKeyID(long l) {
        ArrayList<PGPSignature> arrayList = new ArrayList<PGPSignature>();
        Iterator<PGPSignature> iterator = this.getSignatures();
        while (iterator.hasNext()) {
            PGPSignature pGPSignature = iterator.next();
            if (pGPSignature.getKeyID() != l) continue;
            arrayList.add(pGPSignature);
        }
        return arrayList.iterator();
    }

    public Iterator<PGPSignature> getSignaturesForKey(KeyIdentifier keyIdentifier) {
        ArrayList<PGPSignature> arrayList = new ArrayList<PGPSignature>();
        Iterator<PGPSignature> iterator = this.getSignatures();
        while (iterator.hasNext()) {
            PGPSignature pGPSignature = iterator.next();
            if (!keyIdentifier.isPresentIn(pGPSignature.getKeyIdentifiers())) continue;
            arrayList.add(pGPSignature);
        }
        return arrayList.iterator();
    }

    private Iterator<PGPSignature> getSignaturesForID(UserIDPacket userIDPacket) {
        ArrayList<PGPSignature> arrayList = new ArrayList<PGPSignature>();
        boolean bl = false;
        for (int i = 0; i != this.ids.size(); ++i) {
            if (!userIDPacket.equals(this.ids.get(i))) continue;
            bl = true;
            arrayList.addAll(this.idSigs.get(i));
        }
        return bl ? arrayList.iterator() : null;
    }

    public Iterator<PGPSignature> getSignaturesForUserAttribute(PGPUserAttributeSubpacketVector pGPUserAttributeSubpacketVector) {
        ArrayList<PGPSignature> arrayList = new ArrayList<PGPSignature>();
        boolean bl = false;
        for (int i = 0; i != this.ids.size(); ++i) {
            if (!pGPUserAttributeSubpacketVector.equals(this.ids.get(i))) continue;
            bl = true;
            arrayList.addAll(this.idSigs.get(i));
        }
        return bl ? arrayList.iterator() : null;
    }

    public Iterator<PGPSignature> getSignaturesOfType(int n) {
        ArrayList<PGPSignature> arrayList = new ArrayList<PGPSignature>();
        Iterator<PGPSignature> iterator = this.getSignatures();
        while (iterator.hasNext()) {
            PGPSignature pGPSignature = iterator.next();
            if (pGPSignature.getSignatureType() != n) continue;
            arrayList.add(pGPSignature);
        }
        return arrayList.iterator();
    }

    public Iterator<PGPSignature> getSignatures() {
        if (this.subSigs == null) {
            ArrayList<PGPSignature> arrayList = new ArrayList<PGPSignature>(this.keySigs);
            for (int i = 0; i != this.idSigs.size(); ++i) {
                arrayList.addAll(this.idSigs.get(i));
            }
            return arrayList.iterator();
        }
        return this.subSigs.iterator();
    }

    public Iterator<PGPSignature> getKeySignatures() {
        if (this.subSigs == null) {
            ArrayList<PGPSignature> arrayList = new ArrayList<PGPSignature>(this.keySigs);
            return arrayList.iterator();
        }
        return this.subSigs.iterator();
    }

    public PublicKeyPacket getPublicKeyPacket() {
        return this.publicPk;
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream, false);
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] getEncoded(boolean bl) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.encode(byteArrayOutputStream, bl);
        return byteArrayOutputStream.toByteArray();
    }

    public void encode(OutputStream outputStream) throws IOException {
        this.encode(outputStream, false);
    }

    public void encode(OutputStream outputStream, boolean bl) throws IOException {
        BCPGOutputStream bCPGOutputStream = BCPGOutputStream.wrap(outputStream);
        bCPGOutputStream.writePacket(this.publicPk);
        if (!bl && this.trustPk != null) {
            bCPGOutputStream.writePacket(this.trustPk);
        }
        if (this.subSigs == null) {
            Util.encodePGPSignatures(bCPGOutputStream, this.keySigs, false);
            for (int i = 0; i != this.ids.size(); ++i) {
                Object object;
                if (this.ids.get(i) instanceof UserIDPacket) {
                    object = (UserIDPacket)this.ids.get(i);
                    bCPGOutputStream.writePacket((ContainedPacket)object);
                } else {
                    object = (PGPUserAttributeSubpacketVector)this.ids.get(i);
                    bCPGOutputStream.writePacket(new UserAttributePacket(((PGPUserAttributeSubpacketVector)object).toSubpacketArray()));
                }
                if (!bl && this.idTrusts.get(i) != null) {
                    bCPGOutputStream.writePacket(this.idTrusts.get(i));
                }
                object = this.idSigs.get(i);
                Util.encodePGPSignatures(bCPGOutputStream, (List<PGPSignature>)object, bl);
            }
        } else {
            Util.encodePGPSignatures(bCPGOutputStream, this.subSigs, bl);
        }
    }

    public boolean isRevoked() {
        return this.hasRevocation();
    }

    public boolean hasRevocation() {
        int n = 0;
        boolean bl = false;
        if (this.isMasterKey()) {
            while (!bl && n < this.keySigs.size()) {
                if (this.keySigs.get(n++).getSignatureType() != 32) continue;
                bl = true;
            }
        } else {
            while (!bl && n < this.subSigs.size()) {
                if (this.subSigs.get(n++).getSignatureType() != 40) continue;
                bl = true;
            }
        }
        return bl;
    }

    public static PGPPublicKey addCertification(PGPPublicKey pGPPublicKey, byte[] byArray, PGPSignature pGPSignature) {
        return PGPPublicKey.addCert(pGPPublicKey, new UserIDPacket(byArray), pGPSignature);
    }

    public static PGPPublicKey addCertification(PGPPublicKey pGPPublicKey, String string, PGPSignature pGPSignature) {
        return PGPPublicKey.addCert(pGPPublicKey, new UserIDPacket(string), pGPSignature);
    }

    public static PGPPublicKey addCertification(PGPPublicKey pGPPublicKey, PGPUserAttributeSubpacketVector pGPUserAttributeSubpacketVector, PGPSignature pGPSignature) {
        return PGPPublicKey.addCert(pGPPublicKey, pGPUserAttributeSubpacketVector, pGPSignature);
    }

    private static PGPPublicKey addCert(PGPPublicKey pGPPublicKey, UserDataPacket userDataPacket, PGPSignature pGPSignature) {
        PGPPublicKey pGPPublicKey2 = new PGPPublicKey(pGPPublicKey);
        List<PGPSignature> list = null;
        for (int i = 0; i != pGPPublicKey2.ids.size(); ++i) {
            if (!userDataPacket.equals(pGPPublicKey2.ids.get(i))) continue;
            list = pGPPublicKey2.idSigs.get(i);
        }
        if (list != null) {
            list.add(pGPSignature);
        } else {
            list = new ArrayList<PGPSignature>();
            list.add(pGPSignature);
            pGPPublicKey2.ids.add(userDataPacket);
            pGPPublicKey2.idTrusts.add(null);
            pGPPublicKey2.idSigs.add(list);
        }
        return pGPPublicKey2;
    }

    public static PGPPublicKey removeCertification(PGPPublicKey pGPPublicKey, PGPUserAttributeSubpacketVector pGPUserAttributeSubpacketVector) {
        return PGPPublicKey.removeCert(pGPPublicKey, pGPUserAttributeSubpacketVector);
    }

    public static PGPPublicKey removeCertification(PGPPublicKey pGPPublicKey, String string) {
        return PGPPublicKey.removeCert(pGPPublicKey, new UserIDPacket(string));
    }

    public static PGPPublicKey removeCertification(PGPPublicKey pGPPublicKey, byte[] byArray) {
        return PGPPublicKey.removeCert(pGPPublicKey, new UserIDPacket(byArray));
    }

    private static PGPPublicKey removeCert(PGPPublicKey pGPPublicKey, UserDataPacket userDataPacket) {
        PGPPublicKey pGPPublicKey2 = new PGPPublicKey(pGPPublicKey);
        boolean bl = false;
        for (int i = pGPPublicKey2.ids.size() - 1; i >= 0; --i) {
            if (!userDataPacket.equals(pGPPublicKey2.ids.get(i))) continue;
            bl = true;
            pGPPublicKey2.ids.remove(i);
            pGPPublicKey2.idTrusts.remove(i);
            pGPPublicKey2.idSigs.remove(i);
        }
        return bl ? pGPPublicKey2 : null;
    }

    public static PGPPublicKey removeCertification(PGPPublicKey pGPPublicKey, byte[] byArray, PGPSignature pGPSignature) {
        return PGPPublicKey.removeCert(pGPPublicKey, new UserIDPacket(byArray), pGPSignature);
    }

    public static PGPPublicKey removeCertification(PGPPublicKey pGPPublicKey, String string, PGPSignature pGPSignature) {
        return PGPPublicKey.removeCert(pGPPublicKey, new UserIDPacket(string), pGPSignature);
    }

    public static PGPPublicKey removeCertification(PGPPublicKey pGPPublicKey, PGPUserAttributeSubpacketVector pGPUserAttributeSubpacketVector, PGPSignature pGPSignature) {
        return PGPPublicKey.removeCert(pGPPublicKey, pGPUserAttributeSubpacketVector, pGPSignature);
    }

    private static PGPPublicKey removeCert(PGPPublicKey pGPPublicKey, UserDataPacket userDataPacket, PGPSignature pGPSignature) {
        PGPPublicKey pGPPublicKey2 = new PGPPublicKey(pGPPublicKey);
        boolean bl = false;
        for (int i = 0; i < pGPPublicKey2.ids.size(); ++i) {
            if (!userDataPacket.equals(pGPPublicKey2.ids.get(i))) continue;
            bl |= pGPPublicKey2.idSigs.get(i).remove(pGPSignature);
        }
        return bl ? pGPPublicKey2 : null;
    }

    public static PGPPublicKey addCertification(PGPPublicKey pGPPublicKey, PGPSignature pGPSignature) {
        if (pGPPublicKey.isMasterKey()) {
            if (pGPSignature.getSignatureType() == 40) {
                throw new IllegalArgumentException("signature type incorrect for master key revocation.");
            }
        } else if (pGPSignature.getSignatureType() == 32) {
            throw new IllegalArgumentException("signature type incorrect for sub-key revocation.");
        }
        PGPPublicKey pGPPublicKey2 = new PGPPublicKey(pGPPublicKey);
        List<PGPSignature> list = pGPPublicKey2.subSigs != null ? pGPPublicKey2.subSigs : pGPPublicKey2.keySigs;
        list.add(pGPSignature);
        return pGPPublicKey2;
    }

    public static PGPPublicKey removeCertification(PGPPublicKey pGPPublicKey, PGPSignature pGPSignature) {
        PGPPublicKey pGPPublicKey2 = new PGPPublicKey(pGPPublicKey);
        List<PGPSignature> list = pGPPublicKey2.subSigs != null ? pGPPublicKey2.subSigs : pGPPublicKey2.keySigs;
        boolean bl = list.remove(pGPSignature);
        for (List<PGPSignature> list2 : pGPPublicKey2.idSigs) {
            bl |= list2.remove(pGPSignature);
        }
        return bl ? pGPPublicKey2 : null;
    }

    public static PGPPublicKey join(PGPPublicKey pGPPublicKey, PGPPublicKey pGPPublicKey2, boolean bl, boolean bl2) throws PGPException {
        ArrayList<PGPSignature> arrayList;
        if (pGPPublicKey.getKeyID() != pGPPublicKey2.getKeyID()) {
            throw new IllegalArgumentException("Key-ID mismatch.");
        }
        TrustPacket trustPacket = pGPPublicKey.trustPk;
        ArrayList<PGPSignature> arrayList2 = new ArrayList<PGPSignature>(pGPPublicKey.keySigs);
        ArrayList<UserDataPacket> arrayList3 = new ArrayList<UserDataPacket>(pGPPublicKey.ids);
        ArrayList<TrustPacket> arrayList4 = new ArrayList<TrustPacket>(pGPPublicKey.idTrusts);
        ArrayList<List<PGPSignature>> arrayList5 = new ArrayList<List<PGPSignature>>(pGPPublicKey.idSigs);
        ArrayList<PGPSignature> arrayList6 = arrayList = pGPPublicKey.subSigs == null ? null : new ArrayList<PGPSignature>(pGPPublicKey.subSigs);
        if (bl && pGPPublicKey2.trustPk != null) {
            trustPacket = pGPPublicKey2.trustPk;
        }
        PGPPublicKey.joinPgpSignatureList(pGPPublicKey2.keySigs, arrayList2, true, true);
        for (int i = 0; i < pGPPublicKey2.ids.size(); ++i) {
            TrustPacket trustPacket2;
            UserDataPacket userDataPacket = pGPPublicKey2.ids.get(i);
            ArrayList<PGPSignature> arrayList7 = new ArrayList<PGPSignature>(pGPPublicKey2.idSigs.get(i));
            TrustPacket trustPacket3 = pGPPublicKey2.idTrusts.get(i);
            int n = -1;
            for (int j = 0; j < arrayList3.size(); ++j) {
                UserDataPacket userDataPacket2 = (UserDataPacket)arrayList3.get(j);
                if (!userDataPacket2.equals(userDataPacket)) continue;
                n = j;
                break;
            }
            if (n == -1) {
                arrayList3.add(userDataPacket);
                arrayList5.add(arrayList7);
                arrayList4.add(bl ? trustPacket3 : null);
                continue;
            }
            if (bl && trustPacket3 != null && ((trustPacket2 = (TrustPacket)arrayList4.get(n)) == null || Arrays.areEqual((byte[])trustPacket3.getLevelAndTrustAmount(), (byte[])trustPacket2.getLevelAndTrustAmount()))) {
                arrayList4.set(n, trustPacket3);
            }
            List list = (List)arrayList5.get(n);
            PGPPublicKey.joinPgpSignatureList(arrayList7, list, false, true);
        }
        if (pGPPublicKey2.subSigs != null) {
            if (arrayList == null && bl2) {
                arrayList = new ArrayList<PGPSignature>(pGPPublicKey2.subSigs);
            } else {
                PGPPublicKey.joinPgpSignatureList(pGPPublicKey2.subSigs, arrayList, false, arrayList != null);
            }
        }
        PGPPublicKey pGPPublicKey3 = new PGPPublicKey(pGPPublicKey, trustPacket, arrayList2, arrayList3, arrayList4, arrayList5);
        pGPPublicKey3.subSigs = arrayList;
        return pGPPublicKey3;
    }

    private static void joinPgpSignatureList(List<PGPSignature> list, List<PGPSignature> list2, boolean bl, boolean bl2) throws PGPException {
        for (PGPSignature pGPSignature : list) {
            boolean bl3 = false;
            for (int i = 0; bl2 && i < list2.size(); ++i) {
                PGPSignature pGPSignature2 = list2.get(i);
                if (pGPSignature2.getVersion() != pGPSignature.getVersion() || !PGPSignature.isSignatureEncodingEqual(pGPSignature2, pGPSignature)) continue;
                bl3 = true;
                pGPSignature2 = PGPSignature.join(pGPSignature2, pGPSignature);
                list2.set(i, pGPSignature2);
                break;
            }
            if (bl3 && bl) break;
            if (bl3 || !bl2) continue;
            list2.add(pGPSignature);
        }
    }
}

