/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Date;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.bcpg.ArmoredInputStream;
import org.bouncycastle.bcpg.HashAlgorithmTags;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPLiteralDataGenerator;
import org.bouncycastle.util.encoders.Base64;

public class PGPUtil
implements HashAlgorithmTags {
    private static String defProvider = "BC";
    private static final int READ_AHEAD = 60;

    public static String getDefaultProvider() {
        return defProvider;
    }

    public static void setDefaultProvider(String string) {
        defProvider = string;
    }

    static MPInteger[] dsaSigToMpi(byte[] byArray) throws PGPException {
        DERInteger dERInteger;
        DERInteger dERInteger2;
        MPInteger[] mPIntegerArray;
        ASN1InputStream aSN1InputStream = new ASN1InputStream(byArray);
        try {
            mPIntegerArray = (MPInteger[])aSN1InputStream.readObject();
            dERInteger2 = (DERInteger)mPIntegerArray.getObjectAt(0);
            dERInteger = (DERInteger)mPIntegerArray.getObjectAt(1);
        }
        catch (IOException iOException) {
            throw new PGPException("exception encoding signature", iOException);
        }
        mPIntegerArray = new MPInteger[]{new MPInteger(dERInteger2.getValue()), new MPInteger(dERInteger.getValue())};
        return mPIntegerArray;
    }

    static String getDigestName(int n) throws PGPException {
        switch (n) {
            case 2: {
                return "SHA1";
            }
            case 5: {
                return "MD2";
            }
            case 1: {
                return "MD5";
            }
            case 3: {
                return "RIPEMD160";
            }
            case 8: {
                return "SHA256";
            }
            case 9: {
                return "SHA384";
            }
            case 10: {
                return "SHA512";
            }
            case 11: {
                return "SHA224";
            }
        }
        throw new PGPException("unknown hash algorithm tag in getDigestName: " + n);
    }

    static String getSignatureName(int n, int n2) throws PGPException {
        String string;
        switch (n) {
            case 1: 
            case 3: {
                string = "RSA";
                break;
            }
            case 17: {
                string = "DSA";
                break;
            }
            case 16: 
            case 20: {
                string = "ElGamal";
                break;
            }
            default: {
                throw new PGPException("unknown algorithm tag in signature:" + n);
            }
        }
        return PGPUtil.getDigestName(n2) + "with" + string;
    }

    static String getSymmetricCipherName(int n) throws PGPException {
        switch (n) {
            case 0: {
                return null;
            }
            case 2: {
                return "DESEDE";
            }
            case 1: {
                return "IDEA";
            }
            case 3: {
                return "CAST5";
            }
            case 4: {
                return "Blowfish";
            }
            case 5: {
                return "SAFER";
            }
            case 6: {
                return "DES";
            }
            case 7: {
                return "AES";
            }
            case 8: {
                return "AES";
            }
            case 9: {
                return "AES";
            }
            case 10: {
                return "Twofish";
            }
        }
        throw new PGPException("unknown symmetric algorithm: " + n);
    }

    public static SecretKey makeRandomKey(int n, SecureRandom secureRandom) throws PGPException {
        String string = null;
        int n2 = 0;
        switch (n) {
            case 2: {
                n2 = 192;
                string = "DES_EDE";
                break;
            }
            case 1: {
                n2 = 128;
                string = "IDEA";
                break;
            }
            case 3: {
                n2 = 128;
                string = "CAST5";
                break;
            }
            case 4: {
                n2 = 128;
                string = "Blowfish";
                break;
            }
            case 5: {
                n2 = 128;
                string = "SAFER";
                break;
            }
            case 6: {
                n2 = 64;
                string = "DES";
                break;
            }
            case 7: {
                n2 = 128;
                string = "AES";
                break;
            }
            case 8: {
                n2 = 192;
                string = "AES";
                break;
            }
            case 9: {
                n2 = 256;
                string = "AES";
                break;
            }
            case 10: {
                n2 = 256;
                string = "Twofish";
                break;
            }
            default: {
                throw new PGPException("unknown symmetric algorithm: " + n);
            }
        }
        byte[] byArray = new byte[(n2 + 7) / 8];
        secureRandom.nextBytes(byArray);
        return new SecretKeySpec(byArray, string);
    }

    public static SecretKey makeKeyFromPassPhrase(int n, char[] cArray, String string) throws NoSuchProviderException, PGPException {
        return PGPUtil.makeKeyFromPassPhrase(n, null, cArray, string);
    }

    public static SecretKey makeKeyFromPassPhrase(int n, S2K s2K, char[] cArray, String string) throws PGPException, NoSuchProviderException {
        Provider provider = PGPUtil.getProvider(string);
        return PGPUtil.makeKeyFromPassPhrase(n, s2K, cArray, provider);
    }

    public static SecretKey makeKeyFromPassPhrase(int n, S2K s2K, char[] cArray, Provider provider) throws PGPException, NoSuchProviderException {
        String string = null;
        int n2 = 0;
        switch (n) {
            case 2: {
                n2 = 192;
                string = "DES_EDE";
                break;
            }
            case 1: {
                n2 = 128;
                string = "IDEA";
                break;
            }
            case 3: {
                n2 = 128;
                string = "CAST5";
                break;
            }
            case 4: {
                n2 = 128;
                string = "Blowfish";
                break;
            }
            case 5: {
                n2 = 128;
                string = "SAFER";
                break;
            }
            case 6: {
                n2 = 64;
                string = "DES";
                break;
            }
            case 7: {
                n2 = 128;
                string = "AES";
                break;
            }
            case 8: {
                n2 = 192;
                string = "AES";
                break;
            }
            case 9: {
                n2 = 256;
                string = "AES";
                break;
            }
            case 10: {
                n2 = 256;
                string = "Twofish";
                break;
            }
            default: {
                throw new PGPException("unknown symmetric algorithm: " + n);
            }
        }
        byte[] byArray = new byte[cArray.length];
        for (int i = 0; i != cArray.length; ++i) {
            byArray[i] = (byte)cArray[i];
        }
        byte[] byArray2 = new byte[(n2 + 7) / 8];
        int n3 = 0;
        int n4 = 0;
        while (n3 < byArray2.length) {
            MessageDigest messageDigest;
            Object object;
            block32: {
                block31: {
                    if (s2K == null) break block31;
                    object = PGPUtil.getDigestName(s2K.getHashAlgorithm());
                    try {
                        messageDigest = PGPUtil.getDigestInstance((String)object, provider);
                    }
                    catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                        throw new PGPException("can't find S2K digest", noSuchAlgorithmException);
                    }
                    for (int i = 0; i != n4; ++i) {
                        messageDigest.update((byte)0);
                    }
                    byte[] byArray3 = s2K.getIV();
                    block14 : switch (s2K.getType()) {
                        case 0: {
                            messageDigest.update(byArray);
                            break;
                        }
                        case 1: {
                            messageDigest.update(byArray3);
                            messageDigest.update(byArray);
                            break;
                        }
                        case 3: {
                            long l = s2K.getIterationCount();
                            messageDigest.update(byArray3);
                            messageDigest.update(byArray);
                            l -= (long)(byArray3.length + byArray.length);
                            while (l > 0L) {
                                if (l < (long)byArray3.length) {
                                    messageDigest.update(byArray3, 0, (int)l);
                                    break block14;
                                }
                                messageDigest.update(byArray3);
                                if ((l -= (long)byArray3.length) < (long)byArray.length) {
                                    messageDigest.update(byArray, 0, (int)l);
                                    l = 0L;
                                    continue;
                                }
                                messageDigest.update(byArray);
                                l -= (long)byArray.length;
                            }
                            break block32;
                        }
                        default: {
                            throw new PGPException("unknown S2K type: " + s2K.getType());
                        }
                    }
                    break block32;
                }
                try {
                    messageDigest = PGPUtil.getDigestInstance("MD5", provider);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw new PGPException("can't find MD5 digest", noSuchAlgorithmException);
                }
                for (int i = 0; i != n4; ++i) {
                    messageDigest.update((byte)0);
                }
                messageDigest.update(byArray);
            }
            object = messageDigest.digest();
            if (((Object)object).length > byArray2.length - n3) {
                System.arraycopy(object, 0, byArray2, n3, byArray2.length - n3);
            } else {
                System.arraycopy(object, 0, byArray2, n3, ((Object)object).length);
            }
            n3 += ((Object)object).length;
            ++n4;
        }
        for (int i = 0; i != byArray.length; ++i) {
            byArray[i] = 0;
        }
        return new SecretKeySpec(byArray2, string);
    }

    static MessageDigest getDigestInstance(String string, Provider provider) throws NoSuchAlgorithmException {
        try {
            return MessageDigest.getInstance(string, provider);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return MessageDigest.getInstance(string);
        }
    }

    public static void writeFileToLiteralData(OutputStream outputStream, char c, File file) throws IOException {
        PGPLiteralDataGenerator pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
        OutputStream outputStream2 = pGPLiteralDataGenerator.open(outputStream, c, file.getName(), file.length(), new Date(file.lastModified()));
        PGPUtil.pipeFileContents(file, outputStream2, 4096);
    }

    public static void writeFileToLiteralData(OutputStream outputStream, char c, File file, byte[] byArray) throws IOException {
        PGPLiteralDataGenerator pGPLiteralDataGenerator = new PGPLiteralDataGenerator();
        OutputStream outputStream2 = pGPLiteralDataGenerator.open(outputStream, c, file.getName(), new Date(file.lastModified()), byArray);
        PGPUtil.pipeFileContents(file, outputStream2, byArray.length);
    }

    private static void pipeFileContents(File file, OutputStream outputStream, int n) throws IOException {
        int n2;
        FileInputStream fileInputStream = new FileInputStream(file);
        byte[] byArray = new byte[n];
        while ((n2 = fileInputStream.read(byArray)) > 0) {
            outputStream.write(byArray, 0, n2);
        }
        outputStream.close();
        fileInputStream.close();
    }

    private static boolean isPossiblyBase64(int n) {
        return n >= 65 && n <= 90 || n >= 97 && n <= 122 || n >= 48 && n <= 57 || n == 43 || n == 47 || n == 13 || n == 10;
    }

    public static InputStream getDecoderStream(InputStream inputStream) throws IOException {
        int n;
        if (!inputStream.markSupported()) {
            inputStream = new BufferedInputStreamExt(inputStream);
        }
        inputStream.mark(60);
        int n2 = inputStream.read();
        if ((n2 & 0x80) != 0) {
            inputStream.reset();
            return inputStream;
        }
        if (!PGPUtil.isPossiblyBase64(n2)) {
            inputStream.reset();
            return new ArmoredInputStream(inputStream);
        }
        byte[] byArray = new byte[60];
        int n3 = 1;
        byArray[0] = (byte)n2;
        for (n = 1; n != 60 && (n2 = inputStream.read()) >= 0; ++n) {
            if (!PGPUtil.isPossiblyBase64(n2)) {
                inputStream.reset();
                return new ArmoredInputStream(inputStream);
            }
            if (n2 == 10 || n2 == 13) continue;
            byArray[n3++] = (byte)n2;
        }
        inputStream.reset();
        if (n < 4) {
            return new ArmoredInputStream(inputStream);
        }
        byte[] byArray2 = new byte[8];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        byte[] byArray3 = Base64.decode((byte[])byArray2);
        if ((byArray3[0] & 0x80) != 0) {
            return new ArmoredInputStream(inputStream, false);
        }
        return new ArmoredInputStream(inputStream);
    }

    static Provider getProvider(String string) throws NoSuchProviderException {
        Provider provider = Security.getProvider(string);
        if (provider == null) {
            throw new NoSuchProviderException("provider " + string + " not found.");
        }
        return provider;
    }

    static class BufferedInputStreamExt
    extends BufferedInputStream {
        BufferedInputStreamExt(InputStream inputStream) {
            super(inputStream);
        }

        public synchronized int available() throws IOException {
            int n = super.available();
            if (n < 0) {
                n = Integer.MAX_VALUE;
            }
            return n;
        }
    }
}

