/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.AEADUtils;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.bcpg.SymmetricKeyUtils;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JceAEADCipherUtil;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import org.bouncycastle.openpgp.operator.jcajce.SHA1PGPDigestCalculator;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Exceptions;
import org.bouncycastle.util.Pack;
import org.bouncycastle.util.io.Streams;

class JceAEADUtil {
    private final OperatorHelper helper;

    public JceAEADUtil(OperatorHelper operatorHelper) {
        this.helper = operatorHelper;
    }

    protected static byte[] getNonce(byte[] byArray, long l) {
        byte[] byArray2 = Arrays.clone((byte[])byArray);
        JceAEADUtil.xorChunkId(byArray2, l);
        return byArray2;
    }

    protected static void xorChunkId(byte[] byArray, long l) {
        int n = byArray.length - 8;
        int n2 = n++;
        byArray[n2] = (byte)(byArray[n2] ^ (byte)(l >> 56));
        int n3 = n++;
        byArray[n3] = (byte)(byArray[n3] ^ (byte)(l >> 48));
        int n4 = n++;
        byArray[n4] = (byte)(byArray[n4] ^ (byte)(l >> 40));
        int n5 = n++;
        byArray[n5] = (byte)(byArray[n5] ^ (byte)(l >> 32));
        int n6 = n++;
        byArray[n6] = (byte)(byArray[n6] ^ (byte)(l >> 24));
        int n7 = n++;
        byArray[n7] = (byte)(byArray[n7] ^ (byte)(l >> 16));
        int n8 = n++;
        byArray[n8] = (byte)(byArray[n8] ^ (byte)(l >> 8));
        int n9 = n;
        byArray[n9] = (byte)(byArray[n9] ^ (byte)l);
    }

    protected static long getChunkLength(int n) {
        return 1L << n + 6;
    }

    static byte[][] deriveMessageKeyAndIv(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3) throws PGPException {
        HKDFParameters hKDFParameters = new HKDFParameters(byArray, byArray2, byArray3);
        HKDFBytesGenerator hKDFBytesGenerator = new HKDFBytesGenerator((Digest)new SHA256Digest());
        hKDFBytesGenerator.init((DerivationParameters)hKDFParameters);
        int n3 = SymmetricKeyUtils.getKeyLengthInOctets(n2);
        int n4 = AEADUtils.getIVLength(n);
        byte[] byArray4 = new byte[n3 + n4 - 8];
        hKDFBytesGenerator.generateBytes(byArray4, 0, byArray4.length);
        return new byte[][]{Arrays.copyOfRange((byte[])byArray4, (int)0, (int)n3), Arrays.copyOfRange((byte[])byArray4, (int)n3, (int)(n3 + n4))};
    }

    PGPDataDecryptor createOpenPgpV5DataDecryptor(AEADEncDataPacket aEADEncDataPacket, PGPSessionKey pGPSessionKey) throws PGPException {
        final byte by = aEADEncDataPacket.getAEADAlgorithm();
        final byte[] byArray = aEADEncDataPacket.getIV();
        final int n = aEADEncDataPacket.getChunkSize();
        final int n2 = pGPSessionKey.getAlgorithm();
        byte[] byArray2 = pGPSessionKey.getKey();
        final byte[] byArray3 = aEADEncDataPacket.getAAData();
        try {
            final SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, PGPUtil.getSymmetricCipherName(n2));
            final Cipher cipher = this.createAEADCipher(n2, by);
            return new PGPDataDecryptor(){

                public InputStream getInputStream(InputStream inputStream) {
                    try {
                        return new PGPAeadInputStream(true, inputStream, cipher, secretKeySpec, byArray, n2, by, n, byArray3);
                    }
                    catch (IOException iOException) {
                        throw Exceptions.illegalStateException((String)("unable to open stream: " + iOException.getMessage()), (Throwable)iOException);
                    }
                }

                public int getBlockSize() {
                    return cipher.getBlockSize();
                }

                public PGPDigestCalculator getIntegrityCalculator() {
                    return new SHA1PGPDigestCalculator();
                }
            };
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception creating cipher", exception);
        }
    }

    PGPDataDecryptor createOpenPgpV6DataDecryptor(SymmetricEncIntegrityPacket symmetricEncIntegrityPacket, PGPSessionKey pGPSessionKey) throws PGPException {
        final int n = symmetricEncIntegrityPacket.getCipherAlgorithm();
        final int n2 = symmetricEncIntegrityPacket.getAeadAlgorithm();
        final int n3 = symmetricEncIntegrityPacket.getChunkSize();
        byte[] byArray = symmetricEncIntegrityPacket.getSalt();
        final byte[] byArray2 = symmetricEncIntegrityPacket.getAAData();
        byte[][] byArray3 = JceAEADUtil.deriveMessageKeyAndIv(n2, n, pGPSessionKey.getKey(), byArray, byArray2);
        byte[] byArray4 = byArray3[0];
        final byte[] byArray5 = byArray3[1];
        try {
            final SecretKeySpec secretKeySpec = new SecretKeySpec(byArray4, PGPUtil.getSymmetricCipherName(n));
            final Cipher cipher = this.createAEADCipher(n, n2);
            return new PGPDataDecryptor(){

                public InputStream getInputStream(InputStream inputStream) {
                    try {
                        return new PGPAeadInputStream(false, inputStream, cipher, secretKeySpec, byArray5, n, n2, n3, byArray2);
                    }
                    catch (IOException iOException) {
                        throw Exceptions.illegalStateException((String)("unable to open stream: " + iOException.getMessage()), (Throwable)iOException);
                    }
                }

                public int getBlockSize() {
                    return cipher.getBlockSize();
                }

                public PGPDigestCalculator getIntegrityCalculator() {
                    return new SHA1PGPDigestCalculator();
                }
            };
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception creating cipher", exception);
        }
    }

    Cipher createAEADCipher(int n, int n2) throws PGPException {
        String string;
        if (n != 7 && n != 8 && n != 9 && n != 11 && n != 12 && n != 13) {
            throw new PGPException("AEAD only supported for AES and Camellia based algorithms");
        }
        switch (n2) {
            case 1: {
                string = "EAX";
                break;
            }
            case 2: {
                string = "OCB";
                break;
            }
            case 3: {
                string = "GCM";
                break;
            }
            default: {
                throw new PGPException("encountered unknown AEAD algorithm: " + n2);
            }
        }
        String string2 = PGPUtil.getSymmetricCipherName(n) + "/" + string + "/NoPadding";
        return this.helper.createCipher(string2);
    }

    static class PGPAeadInputStream
    extends InputStream {
        private final InputStream in;
        private final byte[] buf;
        private final Cipher c;
        private final SecretKey secretKey;
        private final byte[] aaData;
        private final byte[] iv;
        private final int chunkLength;
        private final int aeadTagLength;
        private byte[] data;
        private int dataOff;
        private long chunkIndex = 0L;
        private long totalBytes = 0L;
        private boolean v5StyleAEAD;

        public PGPAeadInputStream(boolean bl, InputStream inputStream, Cipher cipher, SecretKey secretKey, byte[] byArray, int n, int n2, int n3, byte[] byArray2) throws IOException {
            this.v5StyleAEAD = bl;
            this.in = inputStream;
            this.iv = byArray;
            this.chunkLength = (int)JceAEADUtil.getChunkLength(n3);
            this.aeadTagLength = AEADUtils.getAuthTagLength(n2);
            this.buf = new byte[this.chunkLength + this.aeadTagLength + this.aeadTagLength];
            this.c = cipher;
            this.secretKey = secretKey;
            this.aaData = byArray2;
            Streams.readFully((InputStream)inputStream, (byte[])this.buf, (int)0, (int)(this.aeadTagLength + this.aeadTagLength));
            this.data = this.readBlock();
            this.dataOff = 0;
        }

        public int read() throws IOException {
            if (this.data != null && this.dataOff == this.data.length) {
                this.data = this.readBlock();
                this.dataOff = 0;
            }
            if (this.data == null) {
                return -1;
            }
            return this.data[this.dataOff++] & 0xFF;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this.data != null && this.dataOff == this.data.length) {
                this.data = this.readBlock();
                this.dataOff = 0;
            }
            if (this.data == null) {
                return -1;
            }
            int n3 = Math.min(n2, this.available());
            System.arraycopy(this.data, this.dataOff, byArray, n, n3);
            this.dataOff += n3;
            return n3;
        }

        public long skip(long l) throws IOException {
            if (l <= 0L) {
                return 0L;
            }
            int n = (int)Math.min(l, (long)this.available());
            this.dataOff += n;
            return n;
        }

        public int available() throws IOException {
            if (this.data != null && this.dataOff == this.data.length) {
                this.data = this.readBlock();
                this.dataOff = 0;
            }
            if (this.data == null) {
                return -1;
            }
            return this.data.length - this.dataOff;
        }

        private byte[] readBlock() throws IOException {
            byte[] byArray;
            int n = Streams.readFully((InputStream)this.in, (byte[])this.buf, (int)(this.aeadTagLength + this.aeadTagLength), (int)this.chunkLength);
            if (n == 0) {
                return null;
            }
            byte[] byArray2 = new byte[this.v5StyleAEAD ? 13 : this.aaData.length];
            System.arraycopy(this.aaData, 0, byArray2, 0, this.aaData.length);
            if (this.v5StyleAEAD) {
                JceAEADUtil.xorChunkId(byArray2, this.chunkIndex);
            }
            try {
                JceAEADCipherUtil.setUpAeadCipher(this.c, this.secretKey, 2, JceAEADUtil.getNonce(this.iv, this.chunkIndex), 128, byArray2);
                byArray = this.c.doFinal(this.buf, 0, n + this.aeadTagLength);
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new IOException("exception processing chunk " + this.chunkIndex + ": " + generalSecurityException.getMessage());
            }
            this.totalBytes += (long)byArray.length;
            ++this.chunkIndex;
            System.arraycopy(this.buf, n + this.aeadTagLength, this.buf, 0, this.aeadTagLength);
            if (n != this.chunkLength) {
                byArray2 = PGPAeadOutputStream.getAdata(this.v5StyleAEAD, this.aaData, this.chunkIndex, this.totalBytes);
                try {
                    if (this.v5StyleAEAD) {
                        JceAEADCipherUtil.setUpAeadCipher(this.c, this.secretKey, 2, JceAEADUtil.getNonce(this.iv, this.chunkIndex), 128, Arrays.concatenate((byte[])byArray2, (byte[])Pack.longToBigEndian((long)this.totalBytes)));
                    } else {
                        JceAEADCipherUtil.setUpAeadCipher(this.c, this.secretKey, 2, JceAEADUtil.getNonce(this.iv, this.chunkIndex), 128, byArray2);
                    }
                    this.c.doFinal(this.buf, 0, this.aeadTagLength);
                }
                catch (GeneralSecurityException generalSecurityException) {
                    throw new IOException("exception processing final tag: " + generalSecurityException.getMessage());
                }
            } else {
                Streams.readFully((InputStream)this.in, (byte[])this.buf, (int)this.aeadTagLength, (int)this.aeadTagLength);
            }
            return byArray;
        }
    }

    static class PGPAeadOutputStream
    extends OutputStream {
        private final boolean isV5AEAD;
        private final OutputStream out;
        private final byte[] data;
        private final Cipher c;
        private final SecretKey secretKey;
        private final byte[] aaData;
        private final byte[] iv;
        private final int chunkLength;
        private int dataOff;
        private long chunkIndex = 0L;
        private long totalBytes = 0L;

        public PGPAeadOutputStream(boolean bl, OutputStream outputStream, Cipher cipher, SecretKey secretKey, byte[] byArray, int n, int n2, int n3) {
            this.isV5AEAD = bl;
            this.out = outputStream;
            this.iv = byArray;
            this.chunkLength = (int)JceAEADUtil.getChunkLength(n3);
            this.data = new byte[this.chunkLength];
            this.c = cipher;
            this.secretKey = secretKey;
            this.aaData = this.createAAD(bl, n, n2, n3);
        }

        private byte[] createAAD(boolean bl, int n, int n2, int n3) {
            if (bl) {
                return AEADEncDataPacket.createAAData(1, n, n2, n3);
            }
            return SymmetricEncIntegrityPacket.createAAData(2, n, n2, n3);
        }

        public void write(int n) throws IOException {
            if (this.dataOff == this.data.length) {
                this.writeBlock();
            }
            this.data[this.dataOff++] = (byte)n;
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this.dataOff == this.data.length) {
                this.writeBlock();
            }
            if (n2 < this.data.length - this.dataOff) {
                System.arraycopy(byArray, n, this.data, this.dataOff, n2);
                this.dataOff += n2;
            } else {
                int n3 = this.data.length - this.dataOff;
                System.arraycopy(byArray, n, this.data, this.dataOff, n3);
                this.dataOff += n3;
                this.writeBlock();
                n2 -= n3;
                n += n3;
                while (n2 >= this.data.length) {
                    System.arraycopy(byArray, n, this.data, 0, this.data.length);
                    this.dataOff = this.data.length;
                    this.writeBlock();
                    n2 -= this.data.length;
                    n += this.data.length;
                }
                if (n2 > 0) {
                    System.arraycopy(byArray, n, this.data, 0, n2);
                    this.dataOff = n2;
                }
            }
        }

        public void close() throws IOException {
            this.finish();
        }

        private void writeBlock() throws IOException {
            byte[] byArray = this.isV5AEAD ? new byte[13] : new byte[this.aaData.length];
            System.arraycopy(this.aaData, 0, byArray, 0, this.aaData.length);
            if (this.isV5AEAD) {
                JceAEADUtil.xorChunkId(byArray, this.chunkIndex);
            }
            try {
                JceAEADCipherUtil.setUpAeadCipher(this.c, this.secretKey, 1, JceAEADUtil.getNonce(this.iv, this.chunkIndex), 128, byArray);
                this.out.write(this.c.doFinal(this.data, 0, this.dataOff));
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new IOException("exception processing chunk " + this.chunkIndex + ": " + generalSecurityException.getMessage());
            }
            this.totalBytes += (long)this.dataOff;
            ++this.chunkIndex;
            this.dataOff = 0;
        }

        private void finish() throws IOException {
            if (this.dataOff > 0) {
                this.writeBlock();
            }
            byte[] byArray = PGPAeadOutputStream.getAdata(this.isV5AEAD, this.aaData, this.chunkIndex, this.totalBytes);
            try {
                if (this.isV5AEAD) {
                    JceAEADCipherUtil.setUpAeadCipher(this.c, this.secretKey, 1, JceAEADUtil.getNonce(this.iv, this.chunkIndex), 128, Arrays.concatenate((byte[])byArray, (byte[])Pack.longToBigEndian((long)this.totalBytes)));
                } else {
                    JceAEADCipherUtil.setUpAeadCipher(this.c, this.secretKey, 1, JceAEADUtil.getNonce(this.iv, this.chunkIndex), 128, byArray);
                }
                this.out.write(this.c.doFinal(this.aaData, 0, 0));
            }
            catch (GeneralSecurityException generalSecurityException) {
                throw new IOException("exception processing final tag: " + generalSecurityException.getMessage());
            }
            this.out.close();
        }

        private static byte[] getAdata(boolean bl, byte[] byArray, long l, long l2) {
            byte[] byArray2;
            if (bl) {
                byArray2 = new byte[13];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                JceAEADUtil.xorChunkId(byArray2, l);
            } else {
                byArray2 = new byte[byArray.length + 8];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                System.arraycopy(Pack.longToBigEndian((long)l2), 0, byArray2, byArray.length, 8);
            }
            return byArray2;
        }
    }
}

