/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.bcpg.PublicKeyAlgorithmTags;
import org.bouncycastle.bcpg.SecretKeyPacket;
import org.bouncycastle.gpg.SExprParser;
import org.bouncycastle.gpg.SExpression;
import org.bouncycastle.openpgp.ExtendedPGPSecretKey;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPExtendedKeyAttribute;
import org.bouncycastle.openpgp.PGPExtendedKeyHeader;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PBEProtectionRemoverFactory;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenedPGPKeyData {
    private final List<PGPExtendedKeyHeader> headerList;
    private final SExpression keyExpression;

    public OpenedPGPKeyData(List<PGPExtendedKeyHeader> list, SExpression sExpression) {
        this.headerList = Collections.unmodifiableList(list);
        this.keyExpression = sExpression;
    }

    public List<PGPExtendedKeyHeader> getHeaderList() {
        return this.headerList;
    }

    public SExpression getKeyExpression() {
        return this.keyExpression;
    }

    public static Builder builder() {
        return new Builder();
    }

    public String getKeyType() {
        return null;
    }

    public ExtendedPGPSecretKey getKeyData(PGPPublicKey pGPPublicKey, PGPDigestCalculatorProvider pGPDigestCalculatorProvider, PBEProtectionRemoverFactory pBEProtectionRemoverFactory, KeyFingerPrintCalculator keyFingerPrintCalculator, int n) throws PGPException, IOException {
        int n2 = SExprParser.getProtectionType(this.keyExpression.getString(0));
        ArrayList<PGPExtendedKeyAttribute> arrayList = new ArrayList<PGPExtendedKeyAttribute>();
        if (n2 == 1 || n2 == 2 || n2 == 3) {
            SExpression sExpression = this.getKeyExpression().getExpression(1);
            String string = sExpression.getString(0);
            PublicKeyAlgorithmTags[] publicKeyAlgorithmTagsArray = SExprParser.getPGPSecretKey(pBEProtectionRemoverFactory, keyFingerPrintCalculator, pGPPublicKey, n, n2, sExpression, string, pGPDigestCalculatorProvider);
            if (string.equals("rsa")) {
                for (Object object : sExpression.filterOut("rsa", "e", "n", "d", "p", "q", "u", "protected").getValues()) {
                    if (object instanceof SExpression) {
                        arrayList.add(((SExpression)object).toAttribute());
                        continue;
                    }
                    arrayList.add(PGPExtendedKeyAttribute.builder().addAttribute(object).build());
                }
            }
            return new ExtendedPGPSecretKey(this.headerList, arrayList, (SecretKeyPacket)publicKeyAlgorithmTagsArray[0], (PGPPublicKey)publicKeyAlgorithmTagsArray[1]);
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private List<PGPExtendedKeyHeader> headerList = new ArrayList<PGPExtendedKeyHeader>();
        private SExpression keyExpression;

        public Builder setHeaderList(List<PGPExtendedKeyHeader> list) {
            this.headerList = list;
            return this;
        }

        public Builder setKeyExpression(SExpression sExpression) {
            this.keyExpression = sExpression;
            return this;
        }

        public OpenedPGPKeyData build() {
            return new OpenedPGPKeyData(this.headerList, this.keyExpression);
        }

        public void add(PGPExtendedKeyHeader pGPExtendedKeyHeader) {
            this.headerList.add(pGPExtendedKeyHeader);
        }
    }
}

