/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.InputStream;
import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.bcpg.PublicKeyEncSessionPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.bcpg.UnsupportedPacketVersionException;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PGPDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PublicKeyDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.SessionKeyDataDecryptorFactory;
import org.bouncycastle.util.Arrays;

public class PGPPublicKeyEncryptedData
extends PGPEncryptedData {
    PublicKeyEncSessionPacket keyData;

    PGPPublicKeyEncryptedData(PublicKeyEncSessionPacket publicKeyEncSessionPacket, InputStreamPacket inputStreamPacket) {
        super(inputStreamPacket);
        this.keyData = publicKeyEncSessionPacket;
    }

    private boolean confirmCheckSum(byte[] byArray) {
        int n = 0;
        for (int i = 1; i != byArray.length - 2; ++i) {
            n += byArray[i] & 0xFF;
        }
        return byArray[byArray.length - 2] == (byte)(n >> 8) && byArray[byArray.length - 1] == (byte)n;
    }

    @Deprecated
    public long getKeyID() {
        return this.keyData.getKeyID();
    }

    public KeyIdentifier getKeyIdentifier() {
        return new KeyIdentifier(this.keyData.getKeyFingerprint(), this.keyData.getKeyID());
    }

    public int getSymmetricAlgorithm(PublicKeyDataDecryptorFactory publicKeyDataDecryptorFactory) throws PGPException {
        if (this.keyData.getVersion() == 3) {
            byte[] byArray = publicKeyDataDecryptorFactory.recoverSessionData(this.keyData, this.encData);
            return byArray[0];
        }
        if (this.keyData.getVersion() == 6) {
            return ((SymmetricEncIntegrityPacket)this.encData).getCipherAlgorithm();
        }
        throw new UnsupportedPacketVersionException("Unsupported packet version: " + this.keyData.getVersion());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public PGPSessionKey getSessionKey(PublicKeyDataDecryptorFactory publicKeyDataDecryptorFactory) throws PGPException {
        int n;
        byte[] byArray = publicKeyDataDecryptorFactory.recoverSessionData(this.keyData, this.encData);
        if (this.containsChecksum(this.keyData.getAlgorithm())) {
            if (!this.confirmCheckSum(byArray)) {
                throw new PGPException("Key checksum failed.");
            }
            byArray = Arrays.copyOf((byte[])byArray, (int)(byArray.length - 2));
        }
        byte[] byArray2 = Arrays.copyOfRange((byte[])byArray, (int)1, (int)byArray.length);
        if (this.encData instanceof AEADEncDataPacket) {
            n = ((AEADEncDataPacket)this.encData).getAlgorithm();
            return new PGPSessionKey(n & 0xFF, byArray2);
        } else if (this.encData instanceof SymmetricEncIntegrityPacket) {
            SymmetricEncIntegrityPacket symmetricEncIntegrityPacket = (SymmetricEncIntegrityPacket)this.encData;
            if (symmetricEncIntegrityPacket.getVersion() == 1) {
                n = byArray[0];
                return new PGPSessionKey(n & 0xFF, byArray2);
            } else {
                if (symmetricEncIntegrityPacket.getVersion() != 2) throw new UnsupportedPacketVersionException("Unsupported SEIPD packet version: " + symmetricEncIntegrityPacket.getVersion());
                n = symmetricEncIntegrityPacket.getCipherAlgorithm();
            }
            return new PGPSessionKey(n & 0xFF, byArray2);
        } else {
            n = byArray[0];
        }
        return new PGPSessionKey(n & 0xFF, byArray2);
    }

    private boolean containsChecksum(int n) {
        return n != 25 && n != 26;
    }

    public InputStream getDataStream(PublicKeyDataDecryptorFactory publicKeyDataDecryptorFactory) throws PGPException {
        return this.getDataStream(publicKeyDataDecryptorFactory, this.getSessionKey(publicKeyDataDecryptorFactory));
    }

    public InputStream getDataStream(SessionKeyDataDecryptorFactory sessionKeyDataDecryptorFactory) throws PGPException {
        return this.getDataStream(sessionKeyDataDecryptorFactory, sessionKeyDataDecryptorFactory.getSessionKey());
    }

    private InputStream getDataStream(PGPDataDecryptorFactory pGPDataDecryptorFactory, PGPSessionKey pGPSessionKey) throws PGPException {
        if (pGPSessionKey.getAlgorithm() != 0) {
            try {
                if (this.encData instanceof AEADEncDataPacket) {
                    AEADEncDataPacket aEADEncDataPacket = (AEADEncDataPacket)this.encData;
                    if (aEADEncDataPacket.getAlgorithm() != pGPSessionKey.getAlgorithm()) {
                        throw new PGPException("session key and AEAD algorithm mismatch");
                    }
                    PGPDataDecryptor pGPDataDecryptor = pGPDataDecryptorFactory.createDataDecryptor(aEADEncDataPacket, pGPSessionKey);
                    BCPGInputStream bCPGInputStream = this.encData.getInputStream();
                    this.encStream = new BCPGInputStream(pGPDataDecryptor.getInputStream(bCPGInputStream));
                } else if (this.encData instanceof SymmetricEncIntegrityPacket) {
                    SymmetricEncIntegrityPacket symmetricEncIntegrityPacket = (SymmetricEncIntegrityPacket)this.encData;
                    if (symmetricEncIntegrityPacket.getVersion() == 1) {
                        PGPDataDecryptor pGPDataDecryptor = pGPDataDecryptorFactory.createDataDecryptor(true, pGPSessionKey.getAlgorithm(), pGPSessionKey.getKey());
                        BCPGInputStream bCPGInputStream = this.encData.getInputStream();
                        this.processSymmetricEncIntegrityPacketDataStream(true, pGPDataDecryptor, bCPGInputStream);
                    } else {
                        PGPDataDecryptor pGPDataDecryptor = pGPDataDecryptorFactory.createDataDecryptor(symmetricEncIntegrityPacket, pGPSessionKey);
                        BCPGInputStream bCPGInputStream = this.encData.getInputStream();
                        this.encStream = new BCPGInputStream(pGPDataDecryptor.getInputStream(bCPGInputStream));
                    }
                } else {
                    PGPDataDecryptor pGPDataDecryptor = pGPDataDecryptorFactory.createDataDecryptor(false, pGPSessionKey.getAlgorithm(), pGPSessionKey.getKey());
                    BCPGInputStream bCPGInputStream = this.encData.getInputStream();
                    this.processSymmetricEncIntegrityPacketDataStream(false, pGPDataDecryptor, bCPGInputStream);
                }
                return this.encStream;
            }
            catch (PGPException pGPException) {
                throw pGPException;
            }
            catch (Exception exception) {
                throw new PGPException("Exception starting decryption", exception);
            }
        }
        return this.encData.getInputStream();
    }

    public int getAlgorithm() {
        return this.keyData.getAlgorithm();
    }

    public int getVersion() {
        return this.keyData.getVersion();
    }
}

