/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.bcpg.SymmetricKeyEncSessionPacket;
import org.bouncycastle.bcpg.SymmetricKeyUtils;
import org.bouncycastle.bcpg.UnsupportedPacketVersionException;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.modes.AEADBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.operator.PBEDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.bc.BcAEADUtil;
import org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcUtil;

public class BcPBEDataDecryptorFactory
extends PBEDataDecryptorFactory {
    public BcPBEDataDecryptorFactory(char[] cArray, BcPGPDigestCalculatorProvider bcPGPDigestCalculatorProvider) {
        super(cArray, bcPGPDigestCalculatorProvider);
    }

    public byte[] recoverSessionData(int n, byte[] byArray, byte[] byArray2) throws PGPException {
        try {
            if (byArray2 != null && byArray2.length > 0) {
                BlockCipher blockCipher = BcImplProvider.createBlockCipher(n);
                BufferedBlockCipher bufferedBlockCipher = BcUtil.createSymmetricKeyWrapper(false, blockCipher, byArray, new byte[blockCipher.getBlockSize()]);
                byte[] byArray3 = new byte[byArray2.length];
                int n2 = bufferedBlockCipher.processBytes(byArray2, 0, byArray2.length, byArray3, 0);
                n2 += bufferedBlockCipher.doFinal(byArray3, n2);
                return byArray3;
            }
            byte[] byArray4 = new byte[byArray.length + 1];
            byArray4[0] = (byte)n;
            System.arraycopy(byArray, 0, byArray4, 1, byArray.length);
            return byArray4;
        }
        catch (Exception exception) {
            throw new PGPException("Exception recovering session info", exception);
        }
    }

    public byte[] recoverAEADEncryptedSessionData(SymmetricKeyEncSessionPacket symmetricKeyEncSessionPacket, byte[] byArray) throws PGPException {
        KeyParameter keyParameter;
        if (symmetricKeyEncSessionPacket.getVersion() < 5) {
            throw new PGPException("SKESK packet MUST be version 5 or later.");
        }
        byte[] byArray2 = symmetricKeyEncSessionPacket.getAAData();
        if (symmetricKeyEncSessionPacket.getVersion() == 5) {
            keyParameter = new KeyParameter(byArray);
        } else if (symmetricKeyEncSessionPacket.getVersion() == 6) {
            int n = SymmetricKeyUtils.getKeyLengthInOctets(symmetricKeyEncSessionPacket.getEncAlgorithm());
            byte[] byArray3 = BcAEADUtil.generateHKDFBytes(byArray, null, byArray2, n);
            keyParameter = new KeyParameter(byArray3);
        } else {
            throw new UnsupportedPacketVersionException("Unsupported SKESK packet version encountered: " + symmetricKeyEncSessionPacket.getVersion());
        }
        AEADBlockCipher aEADBlockCipher = BcAEADUtil.createAEADCipher(symmetricKeyEncSessionPacket.getEncAlgorithm(), symmetricKeyEncSessionPacket.getAeadAlgorithm());
        int n = 128;
        byte[] byArray4 = symmetricKeyEncSessionPacket.getAuthTag();
        byte[] byArray5 = symmetricKeyEncSessionPacket.getIv();
        byte[] byArray6 = symmetricKeyEncSessionPacket.getSecKeyData();
        AEADParameters aEADParameters = new AEADParameters(keyParameter, n, byArray5, symmetricKeyEncSessionPacket.getAAData());
        aEADBlockCipher.init(false, (CipherParameters)aEADParameters);
        int n2 = aEADBlockCipher.getOutputSize(byArray6.length + byArray4.length);
        byte[] byArray7 = new byte[n2];
        int n3 = aEADBlockCipher.processBytes(byArray6, 0, byArray6.length, byArray7, 0);
        n3 += aEADBlockCipher.processBytes(byArray4, 0, byArray4.length, byArray7, n3);
        try {
            aEADBlockCipher.doFinal(byArray7, n3);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new PGPException("Exception recovering session info", (Exception)((Object)invalidCipherTextException));
        }
        return byArray7;
    }

    public PGPDataDecryptor createDataDecryptor(boolean bl, int n, byte[] byArray) throws PGPException {
        BlockCipher blockCipher = BcImplProvider.createBlockCipher(n);
        return BcUtil.createDataDecryptor(bl, blockCipher, byArray);
    }

    public PGPDataDecryptor createDataDecryptor(AEADEncDataPacket aEADEncDataPacket, PGPSessionKey pGPSessionKey) throws PGPException {
        return BcAEADUtil.createOpenPgpV5DataDecryptor(aEADEncDataPacket, pGPSessionKey);
    }

    public PGPDataDecryptor createDataDecryptor(SymmetricEncIntegrityPacket symmetricEncIntegrityPacket, PGPSessionKey pGPSessionKey) throws PGPException {
        return BcAEADUtil.createOpenPgpV6DataDecryptor(symmetricEncIntegrityPacket, pGPSessionKey);
    }
}

