/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.io.IOException;
import java.math.BigInteger;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.interfaces.DSAParams;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.RSAPrivateCrtKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.ECPrivateKeySpec;
import java.security.spec.ECPublicKeySpec;
import java.security.spec.KeySpec;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.RSAPrivateCrtKeySpec;
import java.security.spec.RSAPublicKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import java.util.Enumeration;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cryptlib.CryptlibObjectIdentifiers;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.bouncycastle.asn1.gnu.GNUObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.bcpg.BCPGKey;
import org.bouncycastle.bcpg.DSAPublicBCPGKey;
import org.bouncycastle.bcpg.DSASecretBCPGKey;
import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.ECDSAPublicBCPGKey;
import org.bouncycastle.bcpg.ECPublicBCPGKey;
import org.bouncycastle.bcpg.ECSecretBCPGKey;
import org.bouncycastle.bcpg.Ed25519PublicBCPGKey;
import org.bouncycastle.bcpg.Ed25519SecretBCPGKey;
import org.bouncycastle.bcpg.Ed448PublicBCPGKey;
import org.bouncycastle.bcpg.Ed448SecretBCPGKey;
import org.bouncycastle.bcpg.EdDSAPublicBCPGKey;
import org.bouncycastle.bcpg.EdSecretBCPGKey;
import org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import org.bouncycastle.bcpg.ElGamalSecretBCPGKey;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.RSAPublicBCPGKey;
import org.bouncycastle.bcpg.RSASecretBCPGKey;
import org.bouncycastle.bcpg.X25519PublicBCPGKey;
import org.bouncycastle.bcpg.X25519SecretBCPGKey;
import org.bouncycastle.bcpg.X448PublicBCPGKey;
import org.bouncycastle.bcpg.X448SecretBCPGKey;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.openpgp.PGPAlgorithmParameters;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPKdfParameters;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;
import org.bouncycastle.openpgp.operator.PGPKeyConverter;
import org.bouncycastle.openpgp.operator.jcajce.JcaJcePGPUtil;
import org.bouncycastle.openpgp.operator.jcajce.JcaKeyFingerprintCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPPrivateKey;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.BigIntegers;

public class JcaPGPKeyConverter
extends PGPKeyConverter {
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
    private KeyFingerPrintCalculator fingerPrintCalculator = new JcaKeyFingerprintCalculator();

    public JcaPGPKeyConverter setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        return this;
    }

    public JcaPGPKeyConverter setProvider(String string) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(string));
        return this;
    }

    public PGPPrivateKey getPGPPrivateKey(PGPPublicKey pGPPublicKey, PrivateKey privateKey) throws PGPException {
        BCPGKey bCPGKey = this.getPrivateBCPGKey(pGPPublicKey, privateKey);
        return new PGPPrivateKey(pGPPublicKey.getKeyID(), pGPPublicKey.getPublicKeyPacket(), bCPGKey);
    }

    @Deprecated
    public PGPPublicKey getPGPPublicKey(int n, PGPAlgorithmParameters pGPAlgorithmParameters, PublicKey publicKey, Date date) throws PGPException {
        return this.getPGPPublicKey(4, n, pGPAlgorithmParameters, publicKey, date);
    }

    public PGPPublicKey getPGPPublicKey(int n, int n2, PGPAlgorithmParameters pGPAlgorithmParameters, PublicKey publicKey, Date date) throws PGPException {
        BCPGKey bCPGKey = this.getPublicBCPGKey(n2, pGPAlgorithmParameters, publicKey);
        return new PGPPublicKey(new PublicKeyPacket(n, n2, date, bCPGKey), this.fingerPrintCalculator);
    }

    @Deprecated
    public PGPPublicKey getPGPPublicKey(int n, PublicKey publicKey, Date date) throws PGPException {
        return this.getPGPPublicKey(n, null, publicKey, date);
    }

    public PGPPublicKey getPGPPublicKey(int n, int n2, PublicKey publicKey, Date date) throws PGPException {
        return this.getPGPPublicKey(n, n2, null, publicKey, date);
    }

    public PrivateKey getPrivateKey(PGPPrivateKey pGPPrivateKey) throws PGPException {
        if (pGPPrivateKey instanceof JcaPGPPrivateKey) {
            return ((JcaPGPPrivateKey)pGPPrivateKey).getPrivateKey();
        }
        PublicKeyPacket publicKeyPacket = pGPPrivateKey.getPublicKeyPacket();
        final BCPGKey bCPGKey = pGPPrivateKey.getPrivateKeyDataPacket();
        try {
            switch (publicKeyPacket.getAlgorithm()) {
                case 17: {
                    DSAPublicBCPGKey dSAPublicBCPGKey = (DSAPublicBCPGKey)publicKeyPacket.getKey();
                    DSASecretBCPGKey dSASecretBCPGKey = (DSASecretBCPGKey)bCPGKey;
                    DSAPrivateKeySpec dSAPrivateKeySpec = new DSAPrivateKeySpec(dSASecretBCPGKey.getX(), dSAPublicBCPGKey.getP(), dSAPublicBCPGKey.getQ(), dSAPublicBCPGKey.getG());
                    return this.implGeneratePrivate("DSA", dSAPrivateKeySpec);
                }
                case 18: {
                    ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)publicKeyPacket.getKey();
                    ECSecretBCPGKey eCSecretBCPGKey = (ECSecretBCPGKey)bCPGKey;
                    if (JcaJcePGPUtil.isX25519(eCDHPublicBCPGKey.getCurveOID())) {
                        return this.implGeneratePrivate("XDH", new Operation(){

                            public PrivateKeyInfo getPrivateKeyInfos() throws IOException {
                                return JcaPGPKeyConverter.this.getPrivateKeyInfo(EdECObjectIdentifiers.id_X25519, Arrays.reverseInPlace((byte[])BigIntegers.asUnsignedByteArray((BigInteger)((ECSecretBCPGKey)bCPGKey).getX())));
                            }
                        });
                    }
                    if (EdECObjectIdentifiers.id_X448.equals((ASN1Primitive)eCDHPublicBCPGKey.getCurveOID())) {
                        return this.implGeneratePrivate("XDH", new Operation(){

                            public PrivateKeyInfo getPrivateKeyInfos() throws IOException {
                                return JcaPGPKeyConverter.this.getPrivateKeyInfo(EdECObjectIdentifiers.id_X448, Arrays.reverseInPlace((byte[])BigIntegers.asUnsignedByteArray((BigInteger)((ECSecretBCPGKey)bCPGKey).getX())));
                            }
                        });
                    }
                    return this.implGetPrivateKeyEC("ECDH", eCDHPublicBCPGKey, eCSecretBCPGKey);
                }
                case 25: {
                    return this.implGeneratePrivate("XDH", new Operation(){

                        public PrivateKeyInfo getPrivateKeyInfos() throws IOException {
                            return JcaPGPKeyConverter.this.getPrivateKeyInfo(EdECObjectIdentifiers.id_X25519, 32, bCPGKey.getEncoded());
                        }
                    });
                }
                case 26: {
                    return this.implGeneratePrivate("XDH", new Operation(){

                        public PrivateKeyInfo getPrivateKeyInfos() throws IOException {
                            return JcaPGPKeyConverter.this.getPrivateKeyInfo(EdECObjectIdentifiers.id_X448, 56, bCPGKey.getEncoded());
                        }
                    });
                }
                case 19: {
                    return this.implGetPrivateKeyEC("EC", (ECDSAPublicBCPGKey)publicKeyPacket.getKey(), (ECSecretBCPGKey)bCPGKey);
                }
                case 22: {
                    EdDSAPublicBCPGKey edDSAPublicBCPGKey = (EdDSAPublicBCPGKey)publicKeyPacket.getKey();
                    if (EdECObjectIdentifiers.id_Ed448.equals((ASN1Primitive)edDSAPublicBCPGKey.getCurveOID())) {
                        return this.implGeneratePrivate("EdDSA", new Operation(){

                            public PrivateKeyInfo getPrivateKeyInfos() throws IOException {
                                return JcaPGPKeyConverter.this.getPrivateKeyInfo(EdECObjectIdentifiers.id_Ed448, BigIntegers.asUnsignedByteArray((int)57, (BigInteger)((EdSecretBCPGKey)bCPGKey).getX()));
                            }
                        });
                    }
                    return this.implGeneratePrivate("EdDSA", new Operation(){

                        public PrivateKeyInfo getPrivateKeyInfos() throws IOException {
                            return JcaPGPKeyConverter.this.getPrivateKeyInfo(EdECObjectIdentifiers.id_Ed25519, BigIntegers.asUnsignedByteArray((int)32, (BigInteger)((EdSecretBCPGKey)bCPGKey).getX()));
                        }
                    });
                }
                case 27: {
                    return this.implGeneratePrivate("EdDSA", new Operation(){

                        public PrivateKeyInfo getPrivateKeyInfos() throws IOException {
                            return JcaPGPKeyConverter.this.getPrivateKeyInfo(EdECObjectIdentifiers.id_Ed25519, 32, bCPGKey.getEncoded());
                        }
                    });
                }
                case 28: {
                    return this.implGeneratePrivate("EdDSA", new Operation(){

                        public PrivateKeyInfo getPrivateKeyInfos() throws IOException {
                            return JcaPGPKeyConverter.this.getPrivateKeyInfo(EdECObjectIdentifiers.id_Ed448, 57, bCPGKey.getEncoded());
                        }
                    });
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elGamalPublicBCPGKey = (ElGamalPublicBCPGKey)publicKeyPacket.getKey();
                    ElGamalSecretBCPGKey elGamalSecretBCPGKey = (ElGamalSecretBCPGKey)bCPGKey;
                    DHPrivateKeySpec dHPrivateKeySpec = new DHPrivateKeySpec(elGamalSecretBCPGKey.getX(), elGamalPublicBCPGKey.getP(), elGamalPublicBCPGKey.getG());
                    return this.implGeneratePrivate("ElGamal", dHPrivateKeySpec);
                }
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)publicKeyPacket.getKey();
                    RSASecretBCPGKey rSASecretBCPGKey = (RSASecretBCPGKey)bCPGKey;
                    RSAPrivateCrtKeySpec rSAPrivateCrtKeySpec = new RSAPrivateCrtKeySpec(rSASecretBCPGKey.getModulus(), rSAPublicBCPGKey.getPublicExponent(), rSASecretBCPGKey.getPrivateExponent(), rSASecretBCPGKey.getPrimeP(), rSASecretBCPGKey.getPrimeQ(), rSASecretBCPGKey.getPrimeExponentP(), rSASecretBCPGKey.getPrimeExponentQ(), rSASecretBCPGKey.getCrtCoefficient());
                    return this.implGeneratePrivate("RSA", rSAPrivateCrtKeySpec);
                }
            }
            throw new PGPException("unknown public key algorithm encountered: " + publicKeyPacket.getAlgorithm());
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception constructing key", exception);
        }
    }

    public PublicKey getPublicKey(PGPPublicKey pGPPublicKey) throws PGPException {
        PublicKeyPacket publicKeyPacket = pGPPublicKey.getPublicKeyPacket();
        try {
            switch (publicKeyPacket.getAlgorithm()) {
                case 17: {
                    DSAPublicBCPGKey dSAPublicBCPGKey = (DSAPublicBCPGKey)publicKeyPacket.getKey();
                    DSAPublicKeySpec dSAPublicKeySpec = new DSAPublicKeySpec(dSAPublicBCPGKey.getY(), dSAPublicBCPGKey.getP(), dSAPublicBCPGKey.getQ(), dSAPublicBCPGKey.getG());
                    return this.implGeneratePublic("DSA", dSAPublicKeySpec);
                }
                case 18: {
                    ECDHPublicBCPGKey eCDHPublicBCPGKey = (ECDHPublicBCPGKey)publicKeyPacket.getKey();
                    if (JcaJcePGPUtil.isX25519(eCDHPublicBCPGKey.getCurveOID())) {
                        return this.get25519PublicKey(eCDHPublicBCPGKey.getEncodedPoint(), EdECObjectIdentifiers.id_X25519, "XDH", "Curve");
                    }
                    if (eCDHPublicBCPGKey.getCurveOID().equals((ASN1Primitive)EdECObjectIdentifiers.id_X448)) {
                        return this.get448PublicKey(eCDHPublicBCPGKey.getEncodedPoint(), EdECObjectIdentifiers.id_X448, "XDH", "Curve");
                    }
                    return this.implGetPublicKeyEC("ECDH", eCDHPublicBCPGKey);
                }
                case 25: {
                    return this.implGetPublicKeyX509(publicKeyPacket.getKey().getEncoded(), 0, EdECObjectIdentifiers.id_X25519, "XDH");
                }
                case 26: {
                    return this.implGetPublicKeyX509(publicKeyPacket.getKey().getEncoded(), 0, EdECObjectIdentifiers.id_X448, "XDH");
                }
                case 19: {
                    return this.implGetPublicKeyEC("EC", (ECDSAPublicBCPGKey)publicKeyPacket.getKey());
                }
                case 22: {
                    EdDSAPublicBCPGKey edDSAPublicBCPGKey = (EdDSAPublicBCPGKey)publicKeyPacket.getKey();
                    if (EdECObjectIdentifiers.id_Ed448.equals((ASN1Primitive)edDSAPublicBCPGKey.getCurveOID())) {
                        return this.get448PublicKey(edDSAPublicBCPGKey.getEncodedPoint(), EdECObjectIdentifiers.id_Ed448, "EdDSA", "Ed");
                    }
                    return this.get25519PublicKey(edDSAPublicBCPGKey.getEncodedPoint(), EdECObjectIdentifiers.id_Ed25519, "EdDSA", "Ed");
                }
                case 27: {
                    return this.implGetPublicKeyX509(publicKeyPacket.getKey().getEncoded(), 0, EdECObjectIdentifiers.id_Ed25519, "EdDSA");
                }
                case 28: {
                    return this.implGetPublicKeyX509(publicKeyPacket.getKey().getEncoded(), 0, EdECObjectIdentifiers.id_Ed448, "EdDSA");
                }
                case 16: 
                case 20: {
                    ElGamalPublicBCPGKey elGamalPublicBCPGKey = (ElGamalPublicBCPGKey)publicKeyPacket.getKey();
                    DHPublicKeySpec dHPublicKeySpec = new DHPublicKeySpec(elGamalPublicBCPGKey.getY(), elGamalPublicBCPGKey.getP(), elGamalPublicBCPGKey.getG());
                    return this.implGeneratePublic("ElGamal", dHPublicKeySpec);
                }
                case 1: 
                case 2: 
                case 3: {
                    RSAPublicBCPGKey rSAPublicBCPGKey = (RSAPublicBCPGKey)publicKeyPacket.getKey();
                    RSAPublicKeySpec rSAPublicKeySpec = new RSAPublicKeySpec(rSAPublicBCPGKey.getModulus(), rSAPublicBCPGKey.getPublicExponent());
                    return this.implGeneratePublic("RSA", rSAPublicKeySpec);
                }
            }
            throw new PGPException("unknown public key algorithm encountered: " + publicKeyPacket.getAlgorithm());
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("exception constructing public key", exception);
        }
    }

    private ECParameterSpec getECParameterSpec(ASN1ObjectIdentifier aSN1ObjectIdentifier) throws IOException, GeneralSecurityException {
        AlgorithmParameters algorithmParameters = this.helper.createAlgorithmParameters("EC");
        algorithmParameters.init(new X962Parameters(aSN1ObjectIdentifier).getEncoded());
        return algorithmParameters.getParameterSpec(ECParameterSpec.class);
    }

    private BCPGKey getPrivateBCPGKey(PrivateKey privateKey, BCPGKeyOperation bCPGKeyOperation) throws PGPException {
        PrivateKeyInfo privateKeyInfo = PrivateKeyInfo.getInstance((Object)privateKey.getEncoded());
        try {
            return bCPGKeyOperation.getBCPGKey(ASN1OctetString.getInstance((Object)privateKeyInfo.parsePrivateKey()).getOctets());
        }
        catch (IOException iOException) {
            throw new PGPException(iOException.getMessage(), iOException);
        }
    }

    private BCPGKey getPrivateBCPGKey(PGPPublicKey pGPPublicKey, PrivateKey privateKey) throws PGPException {
        switch (pGPPublicKey.getAlgorithm()) {
            case 17: {
                DSAPrivateKey dSAPrivateKey = (DSAPrivateKey)privateKey;
                return new DSASecretBCPGKey(dSAPrivateKey.getX());
            }
            case 18: {
                if (privateKey instanceof ECPrivateKey) {
                    ECPrivateKey eCPrivateKey = (ECPrivateKey)privateKey;
                    return new ECSecretBCPGKey(eCPrivateKey.getS());
                }
                return this.getPrivateBCPGKey(privateKey, new BCPGKeyOperation(){

                    public BCPGKey getBCPGKey(byte[] byArray) {
                        return new ECSecretBCPGKey(new BigInteger(1, Arrays.reverse((byte[])byArray)));
                    }
                });
            }
            case 25: {
                return this.getPrivateBCPGKey(privateKey, new BCPGKeyOperation(){

                    public BCPGKey getBCPGKey(byte[] byArray) {
                        return new X25519SecretBCPGKey(byArray);
                    }
                });
            }
            case 26: {
                return this.getPrivateBCPGKey(privateKey, new BCPGKeyOperation(){

                    public BCPGKey getBCPGKey(byte[] byArray) {
                        return new X448SecretBCPGKey(byArray);
                    }
                });
            }
            case 19: {
                return new ECSecretBCPGKey(((ECPrivateKey)privateKey).getS());
            }
            case 22: {
                return this.getPrivateBCPGKey(privateKey, new BCPGKeyOperation(){

                    public BCPGKey getBCPGKey(byte[] byArray) {
                        return new EdSecretBCPGKey(new BigInteger(1, byArray));
                    }
                });
            }
            case 27: {
                return this.getPrivateBCPGKey(privateKey, new BCPGKeyOperation(){

                    public BCPGKey getBCPGKey(byte[] byArray) {
                        return new Ed25519SecretBCPGKey(byArray);
                    }
                });
            }
            case 28: {
                return this.getPrivateBCPGKey(privateKey, new BCPGKeyOperation(){

                    public BCPGKey getBCPGKey(byte[] byArray) {
                        return new Ed448SecretBCPGKey(byArray);
                    }
                });
            }
            case 16: 
            case 20: {
                DHPrivateKey dHPrivateKey = (DHPrivateKey)privateKey;
                return new ElGamalSecretBCPGKey(dHPrivateKey.getX());
            }
            case 1: 
            case 2: 
            case 3: {
                RSAPrivateCrtKey rSAPrivateCrtKey = (RSAPrivateCrtKey)privateKey;
                return new RSASecretBCPGKey(rSAPrivateCrtKey.getPrivateExponent(), rSAPrivateCrtKey.getPrimeP(), rSAPrivateCrtKey.getPrimeQ());
            }
        }
        throw new PGPException("unknown public key algorithm encountered: " + pGPPublicKey.getAlgorithm());
    }

    private BCPGKey getPublicBCPGKey(int n, PGPAlgorithmParameters pGPAlgorithmParameters, PublicKey publicKey) throws PGPException {
        switch (n) {
            case 1: 
            case 2: 
            case 3: {
                RSAPublicKey rSAPublicKey = (RSAPublicKey)publicKey;
                return new RSAPublicBCPGKey(rSAPublicKey.getModulus(), rSAPublicKey.getPublicExponent());
            }
            case 16: 
            case 20: {
                DHPublicKey dHPublicKey = (DHPublicKey)publicKey;
                return new ElGamalPublicBCPGKey(dHPublicKey.getParams().getP(), dHPublicKey.getParams().getG(), dHPublicKey.getY());
            }
            case 17: {
                DSAPublicKey dSAPublicKey = (DSAPublicKey)publicKey;
                DSAParams dSAParams = dSAPublicKey.getParams();
                return new DSAPublicBCPGKey(dSAParams.getP(), dSAParams.getQ(), dSAParams.getG(), dSAPublicKey.getY());
            }
            case 21: {
                DHPublicKey dHPublicKey = (DHPublicKey)publicKey;
                DHParameterSpec dHParameterSpec = dHPublicKey.getParams();
                return new ElGamalPublicBCPGKey(dHParameterSpec.getP(), dHParameterSpec.getG(), dHPublicKey.getY());
            }
            case 18: 
            case 19: {
                Object object;
                SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded());
                ASN1ObjectIdentifier aSN1ObjectIdentifier = subjectPublicKeyInfo.getAlgorithm().getAlgorithm();
                ASN1ObjectIdentifier aSN1ObjectIdentifier2 = ASN1ObjectIdentifier.getInstance((Object)aSN1ObjectIdentifier);
                if (X9ObjectIdentifiers.id_ecPublicKey.equals((ASN1Primitive)aSN1ObjectIdentifier2) && (object = ASN1ObjectIdentifier.getInstance((Object)(aSN1ObjectIdentifier = this.getNamedCurveOID(X962Parameters.getInstance((Object)subjectPublicKeyInfo.getAlgorithm().getParameters()))))) != null) {
                    aSN1ObjectIdentifier2 = object;
                }
                if (publicKey.getAlgorithm().regionMatches(true, 0, "X2", 0, 2)) {
                    object = this.implGetKdfParameters(CryptlibObjectIdentifiers.curvey25519, pGPAlgorithmParameters);
                    return new ECDHPublicBCPGKey(CryptlibObjectIdentifiers.curvey25519, new BigInteger(1, this.getPointEncUncompressed(publicKey, 32)), ((PGPKdfParameters)object).getHashAlgorithm(), ((PGPKdfParameters)object).getSymmetricWrapAlgorithm());
                }
                if (publicKey.getAlgorithm().regionMatches(true, 0, "X4", 0, 2)) {
                    object = this.implGetKdfParameters(EdECObjectIdentifiers.id_X448, pGPAlgorithmParameters);
                    return new ECDHPublicBCPGKey(EdECObjectIdentifiers.id_X448, new BigInteger(1, this.getPointEncUncompressed(publicKey, 56)), ((PGPKdfParameters)object).getHashAlgorithm(), ((PGPKdfParameters)object).getSymmetricWrapAlgorithm());
                }
                if (publicKey.getAlgorithm().regionMatches(true, 0, "XDH", 0, 3)) {
                    if (44 == publicKey.getEncoded().length) {
                        object = this.implGetKdfParameters(CryptlibObjectIdentifiers.curvey25519, pGPAlgorithmParameters);
                        return new ECDHPublicBCPGKey(CryptlibObjectIdentifiers.curvey25519, new BigInteger(1, this.getPointEncUncompressed(publicKey, 32)), ((PGPKdfParameters)object).getHashAlgorithm(), ((PGPKdfParameters)object).getSymmetricWrapAlgorithm());
                    }
                    object = this.implGetKdfParameters(EdECObjectIdentifiers.id_X448, pGPAlgorithmParameters);
                    return new ECDHPublicBCPGKey(EdECObjectIdentifiers.id_X448, new BigInteger(1, this.getPointEncUncompressed(publicKey, 56)), ((PGPKdfParameters)object).getHashAlgorithm(), ((PGPKdfParameters)object).getSymmetricWrapAlgorithm());
                }
                object = ECNamedCurveTable.getByOIDLazy((ASN1ObjectIdentifier)aSN1ObjectIdentifier2);
                DEROctetString dEROctetString = new DEROctetString(subjectPublicKeyInfo.getPublicKeyData().getBytes());
                X9ECPoint x9ECPoint = new X9ECPoint(object.getCurve(), (ASN1OctetString)dEROctetString);
                if (n == 18) {
                    PGPKdfParameters pGPKdfParameters = this.implGetKdfParameters(aSN1ObjectIdentifier2, pGPAlgorithmParameters);
                    return new ECDHPublicBCPGKey(aSN1ObjectIdentifier2, x9ECPoint.getPoint(), pGPKdfParameters.getHashAlgorithm(), pGPKdfParameters.getSymmetricWrapAlgorithm());
                }
                return new ECDSAPublicBCPGKey(aSN1ObjectIdentifier2, x9ECPoint.getPoint());
            }
            case 22: {
                if (publicKey.getAlgorithm().regionMatches(true, 0, "ED2", 0, 3)) {
                    return new EdDSAPublicBCPGKey(GNUObjectIdentifiers.Ed25519, new BigInteger(1, this.getPointEncUncompressed(publicKey, 32)));
                }
                if (publicKey.getAlgorithm().regionMatches(true, 0, "ED4", 0, 3)) {
                    return new EdDSAPublicBCPGKey(EdECObjectIdentifiers.id_Ed448, new BigInteger(1, this.getPointEncUncompressed(publicKey, 57)));
                }
                if (publicKey.getEncoded().length == 44) {
                    return new EdDSAPublicBCPGKey(GNUObjectIdentifiers.Ed25519, new BigInteger(1, this.getPointEncUncompressed(publicKey, 32)));
                }
                return new EdDSAPublicBCPGKey(EdECObjectIdentifiers.id_Ed448, new BigInteger(1, this.getPointEncUncompressed(publicKey, 57)));
            }
            case 27: {
                return this.getPublicBCPGKey(publicKey, 32, new BCPGKeyOperation(){

                    public BCPGKey getBCPGKey(byte[] byArray) {
                        return new Ed25519PublicBCPGKey(byArray);
                    }
                });
            }
            case 28: {
                return this.getPublicBCPGKey(publicKey, 57, new BCPGKeyOperation(){

                    public BCPGKey getBCPGKey(byte[] byArray) {
                        return new Ed448PublicBCPGKey(byArray);
                    }
                });
            }
            case 25: {
                return this.getPublicBCPGKey(publicKey, 32, new BCPGKeyOperation(){

                    public BCPGKey getBCPGKey(byte[] byArray) {
                        return new X25519PublicBCPGKey(byArray);
                    }
                });
            }
            case 26: {
                return this.getPublicBCPGKey(publicKey, 56, new BCPGKeyOperation(){

                    public BCPGKey getBCPGKey(byte[] byArray) {
                        return new X448PublicBCPGKey(byArray);
                    }
                });
            }
        }
        throw new PGPException("unknown public key algorithm encountered: " + n);
    }

    private ASN1Encodable getNamedCurveOID(X962Parameters x962Parameters) {
        ECCurve eCCurve = null;
        if (x962Parameters.isNamedCurve()) {
            return ASN1ObjectIdentifier.getInstance((Object)x962Parameters.getParameters());
        }
        eCCurve = x962Parameters.isImplicitlyCA() ? ((X9ECParameters)CryptoServicesRegistrar.getProperty((CryptoServicesRegistrar.Property)CryptoServicesRegistrar.Property.EC_IMPLICITLY_CA)).getCurve() : X9ECParameters.getInstance((Object)x962Parameters.getParameters()).getCurve();
        Enumeration enumeration = ECNamedCurveTable.getNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            X9ECParameters x9ECParameters = ECNamedCurveTable.getByName((String)string);
            if (!eCCurve.equals(x9ECParameters.getCurve())) continue;
            return ECNamedCurveTable.getOID((String)string);
        }
        return null;
    }

    private BCPGKey getPublicBCPGKey(PublicKey publicKey, int n, BCPGKeyOperation bCPGKeyOperation) {
        byte[] byArray = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded()).getPublicKeyData().getBytes();
        byte[] byArray2 = new byte[n];
        System.arraycopy(byArray, 0, byArray2, byArray2.length - byArray.length, byArray.length);
        return bCPGKeyOperation.getBCPGKey(byArray2);
    }

    private byte[] getPointEncUncompressed(PublicKey publicKey, int n) {
        byte[] byArray = SubjectPublicKeyInfo.getInstance((Object)publicKey.getEncoded()).getPublicKeyData().getBytes();
        byte[] byArray2 = new byte[1 + n];
        byArray2[0] = 64;
        System.arraycopy(byArray, 0, byArray2, byArray2.length - byArray.length, byArray.length);
        return byArray2;
    }

    private PrivateKey implGeneratePrivate(String string, Operation operation) throws GeneralSecurityException, PGPException, IOException {
        PKCS8EncodedKeySpec pKCS8EncodedKeySpec = new PKCS8EncodedKeySpec(operation.getPrivateKeyInfos().getEncoded());
        KeyFactory keyFactory = this.helper.createKeyFactory(string);
        return keyFactory.generatePrivate(pKCS8EncodedKeySpec);
    }

    private PrivateKey implGeneratePrivate(String string, KeySpec keySpec) throws GeneralSecurityException, PGPException {
        KeyFactory keyFactory = this.helper.createKeyFactory(string);
        return keyFactory.generatePrivate(keySpec);
    }

    private PublicKey implGeneratePublic(String string, KeySpec keySpec) throws GeneralSecurityException, PGPException {
        KeyFactory keyFactory = this.helper.createKeyFactory(string);
        return keyFactory.generatePublic(keySpec);
    }

    private PublicKey implGetPublicKeyX509(byte[] byArray, int n, ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) throws IOException, PGPException, GeneralSecurityException {
        return this.implGeneratePublic(string, new X509EncodedKeySpec(new SubjectPublicKeyInfo(new AlgorithmIdentifier(aSN1ObjectIdentifier), Arrays.copyOfRange((byte[])byArray, (int)n, (int)byArray.length)).getEncoded()));
    }

    private PrivateKey implGetPrivateKeyEC(String string, ECPublicBCPGKey eCPublicBCPGKey, ECSecretBCPGKey eCSecretBCPGKey) throws GeneralSecurityException, PGPException, IOException {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = eCPublicBCPGKey.getCurveOID();
        ECPrivateKeySpec eCPrivateKeySpec = new ECPrivateKeySpec(eCSecretBCPGKey.getX(), this.getECParameterSpec(aSN1ObjectIdentifier));
        return this.implGeneratePrivate(string, eCPrivateKeySpec);
    }

    private PublicKey implGetPublicKeyEC(String string, ECPublicBCPGKey eCPublicBCPGKey) throws GeneralSecurityException, IOException, PGPException {
        ASN1ObjectIdentifier aSN1ObjectIdentifier = eCPublicBCPGKey.getCurveOID();
        X9ECParameters x9ECParameters = JcaJcePGPUtil.getX9Parameters(aSN1ObjectIdentifier);
        org.bouncycastle.math.ec.ECPoint eCPoint = JcaJcePGPUtil.decodePoint(eCPublicBCPGKey.getEncodedPoint(), x9ECParameters.getCurve());
        ECPublicKeySpec eCPublicKeySpec = new ECPublicKeySpec(new ECPoint(eCPoint.getAffineXCoord().toBigInteger(), eCPoint.getAffineYCoord().toBigInteger()), this.getECParameterSpec(aSN1ObjectIdentifier));
        return this.implGeneratePublic(string, eCPublicKeySpec);
    }

    private PublicKey get25519PublicKey(BigInteger bigInteger, ASN1ObjectIdentifier aSN1ObjectIdentifier, String string, String string2) throws PGPException, GeneralSecurityException, IOException {
        byte[] byArray = BigIntegers.asUnsignedByteArray((BigInteger)bigInteger);
        if (byArray.length < 1 || 64 != byArray[0]) {
            throw new IllegalArgumentException("Invalid " + string2 + "25519 public key");
        }
        return this.implGetPublicKeyX509(byArray, 1, aSN1ObjectIdentifier, string);
    }

    private PublicKey get448PublicKey(BigInteger bigInteger, ASN1ObjectIdentifier aSN1ObjectIdentifier, String string, String string2) throws PGPException, GeneralSecurityException, IOException {
        byte[] byArray = BigIntegers.asUnsignedByteArray((BigInteger)bigInteger);
        if (byArray.length < 1 || 64 != byArray[0]) {
            throw new IllegalArgumentException("Invalid " + string2 + "448 public key");
        }
        return this.implGetPublicKeyX509(byArray, 1, aSN1ObjectIdentifier, string);
    }

    @FunctionalInterface
    private static interface BCPGKeyOperation {
        public BCPGKey getBCPGKey(byte[] var1);
    }

    @FunctionalInterface
    private static interface Operation {
        public PrivateKeyInfo getPrivateKeyInfos() throws IOException;
    }
}

