/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.IOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.BCPGHeaderObject;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.bcpg.SymmetricEncDataPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.bcpg.SymmetricKeyAlgorithmTags;
import org.bouncycastle.openpgp.AEADUtil;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.StreamGenerator;
import org.bouncycastle.openpgp.WrappedGeneratorStream;
import org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PGPAEADDataEncryptor;
import org.bouncycastle.openpgp.operator.PGPDataEncryptorBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.PGPKeyEncryptionMethodGenerator;
import org.bouncycastle.util.io.TeeOutputStream;

public class PGPEncryptedDataGenerator
implements SymmetricKeyAlgorithmTags,
StreamGenerator {
    public static final int S2K_SHA1 = 2;
    public static final int S2K_SHA224 = 11;
    public static final int S2K_SHA256 = 8;
    public static final int S2K_SHA384 = 9;
    public static final int S2K_SHA512 = 10;
    private BCPGOutputStream pOut;
    private OutputStream cOut;
    private boolean useOldFormat = false;
    private PGPDigestCalculator digestCalc;
    private OutputStream genOut;
    private PGPDataEncryptorBuilder dataEncryptorBuilder;
    private byte[] salt = new byte[32];
    private List<PGPKeyEncryptionMethodGenerator> methods = new ArrayList<PGPKeyEncryptionMethodGenerator>();
    private int defAlgorithm;
    private SecureRandom rand;
    private boolean forceSessionKey = true;

    public PGPEncryptedDataGenerator(PGPDataEncryptorBuilder pGPDataEncryptorBuilder) {
        this(pGPDataEncryptorBuilder, false);
    }

    public PGPEncryptedDataGenerator(PGPDataEncryptorBuilder pGPDataEncryptorBuilder, boolean bl) {
        this.dataEncryptorBuilder = pGPDataEncryptorBuilder;
        this.useOldFormat = bl;
        this.defAlgorithm = this.dataEncryptorBuilder.getAlgorithm();
        this.rand = this.dataEncryptorBuilder.getSecureRandom();
        this.rand.nextBytes(this.salt);
    }

    public void setForceSessionKey(boolean bl) {
        this.forceSessionKey = bl;
    }

    public void addMethod(PGPKeyEncryptionMethodGenerator pGPKeyEncryptionMethodGenerator) {
        this.methods.add(pGPKeyEncryptionMethodGenerator);
    }

    private OutputStream open(OutputStream outputStream, long l, byte[] byArray) throws IOException, PGPException, IllegalStateException {
        byte[] byArray2;
        Object object;
        byte[] byArray3;
        if (this.cOut != null) {
            throw new IllegalStateException("generator already in open state");
        }
        if (this.methods.size() == 0) {
            throw new IllegalStateException("no encryption methods specified");
        }
        this.pOut = new BCPGOutputStream(outputStream, !this.useOldFormat);
        Object var6_4 = null;
        boolean bl = !this.forceSessionKey && this.methods.size() == 1 && this.methods.get(0) instanceof PBEKeyEncryptionMethodGenerator;
        boolean bl2 = this.dataEncryptorBuilder.isV5StyleAEAD();
        if (this.dataEncryptorBuilder.getAeadAlgorithm() != -1 && !bl2) {
            byArray3 = PGPUtil.makeRandomKey(this.defAlgorithm, this.rand);
            object = SymmetricEncIntegrityPacket.createAAData(2, this.defAlgorithm, this.dataEncryptorBuilder.getAeadAlgorithm(), this.dataEncryptorBuilder.getChunkSize());
            byArray2 = AEADUtil.deriveMessageKeyAndIv(this.dataEncryptorBuilder.getAeadAlgorithm(), this.defAlgorithm, byArray3, this.salt, (byte[])object);
        } else {
            byArray2 = bl ? (byArray3 = ((PBEKeyEncryptionMethodGenerator)this.methods.get(0)).getKey(this.defAlgorithm)) : (byArray3 = PGPUtil.makeRandomKey(this.defAlgorithm, this.rand));
        }
        object = this.dataEncryptorBuilder.build(byArray2);
        this.digestCalc = object.getIntegrityCalculator();
        for (int i = 0; i < this.methods.size(); ++i) {
            PGPKeyEncryptionMethodGenerator pGPKeyEncryptionMethodGenerator = this.methods.get(i);
            this.pOut.writePacket(pGPKeyEncryptionMethodGenerator.generate(this.dataEncryptorBuilder, byArray3));
        }
        try {
            if (object instanceof PGPAEADDataEncryptor) {
                long l2;
                InputStreamPacket inputStreamPacket;
                PGPAEADDataEncryptor pGPAEADDataEncryptor = (PGPAEADDataEncryptor)object;
                if (bl2) {
                    byte[] byArray4 = pGPAEADDataEncryptor.getIV();
                    inputStreamPacket = new AEADEncDataPacket(this.defAlgorithm, pGPAEADDataEncryptor.getAEADAlgorithm(), pGPAEADDataEncryptor.getChunkSize(), byArray4);
                    l2 = byArray4.length;
                } else {
                    inputStreamPacket = SymmetricEncIntegrityPacket.createVersion2Packet(this.defAlgorithm, pGPAEADDataEncryptor.getAEADAlgorithm(), pGPAEADDataEncryptor.getChunkSize(), this.salt);
                    l2 = this.salt.length;
                }
                if (byArray == null) {
                    long l3 = 1L << pGPAEADDataEncryptor.getChunkSize() + 6;
                    long l4 = (l + l3 - 1L) / l3 * 16L + 16L;
                    this.pOut = new ClosableBCPGOutputStream(outputStream, (BCPGHeaderObject)((Object)inputStreamPacket), l + l4 + 4L + l2);
                } else {
                    this.pOut = new ClosableBCPGOutputStream(outputStream, (BCPGHeaderObject)((Object)inputStreamPacket), byArray);
                }
                this.genOut = this.cOut = object.getOutputStream(this.pOut);
            } else {
                InputStreamPacket inputStreamPacket;
                if (this.digestCalc != null) {
                    inputStreamPacket = SymmetricEncIntegrityPacket.createVersion1Packet();
                    if (this.useOldFormat) {
                        throw new PGPException("symmetric-enc-integrity packets not supported in old PGP format");
                    }
                } else {
                    inputStreamPacket = new SymmetricEncDataPacket();
                }
                if (byArray == null) {
                    long l5 = this.digestCalc == null ? l + (long)object.getBlockSize() + 2L : l + (long)object.getBlockSize() + 2L + 1L + 22L;
                    this.pOut = new ClosableBCPGOutputStream(outputStream, (BCPGHeaderObject)((Object)inputStreamPacket), l5, this.useOldFormat);
                } else {
                    this.pOut = new ClosableBCPGOutputStream(outputStream, (BCPGHeaderObject)((Object)inputStreamPacket), byArray);
                }
                this.genOut = this.cOut = object.getOutputStream(this.pOut);
                if (this.digestCalc != null) {
                    this.genOut = new TeeOutputStream(this.digestCalc.getOutputStream(), this.cOut);
                }
                byte[] byArray5 = new byte[object.getBlockSize() + 2];
                this.rand.nextBytes(byArray5);
                byArray5[byArray5.length - 1] = byArray5[byArray5.length - 3];
                byArray5[byArray5.length - 2] = byArray5[byArray5.length - 4];
                this.genOut.write(byArray5);
            }
            return new WrappedGeneratorStream(this.genOut, this);
        }
        catch (IOException iOException) {
            throw iOException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception creating cipher", exception);
        }
    }

    public OutputStream open(OutputStream outputStream, long l) throws IOException, PGPException {
        return this.open(outputStream, l, null);
    }

    public OutputStream open(OutputStream outputStream, byte[] byArray) throws IOException, PGPException {
        return this.open(outputStream, 0L, byArray);
    }

    public void close() throws IOException {
        if (this.cOut != null) {
            if (this.digestCalc != null) {
                BCPGOutputStream bCPGOutputStream = new BCPGOutputStream(this.genOut, 19, 20L);
                bCPGOutputStream.flush();
                byte[] byArray = this.digestCalc.getDigest();
                this.cOut.write(byArray);
            }
            this.cOut.close();
            this.cOut = null;
            this.pOut = null;
        }
    }

    private static class ClosableBCPGOutputStream
    extends BCPGOutputStream {
        public ClosableBCPGOutputStream(OutputStream outputStream, BCPGHeaderObject bCPGHeaderObject, byte[] byArray) throws IOException {
            super(outputStream, bCPGHeaderObject.getType(), byArray);
            bCPGHeaderObject.encode(this);
        }

        public ClosableBCPGOutputStream(OutputStream outputStream, BCPGHeaderObject bCPGHeaderObject, long l, boolean bl) throws IOException {
            super(outputStream, bCPGHeaderObject.getType(), l, bl);
            bCPGHeaderObject.encode(this);
        }

        public ClosableBCPGOutputStream(OutputStream outputStream, BCPGHeaderObject bCPGHeaderObject, long l) throws IOException {
            super(outputStream, bCPGHeaderObject.getType(), l);
            bCPGHeaderObject.encode(this);
        }

        public void close() throws IOException {
            this.finish();
        }
    }
}

